/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser;

import com.github.javaparser.Position;
import com.github.javaparser.TokenRange;
import com.github.javaparser.utils.Utils;
import java.util.Comparator;
import java.util.Optional;

public class Problem {
    private final String message;
    private final TokenRange location;
    private final Throwable cause;
    public static Comparator<Problem> PROBLEM_BY_BEGIN_POSITION = (a2, b2) -> {
        Optional aBegin = a2.getLocation().flatMap(l2 -> l2.getBegin().getRange().map(r2 -> r2.begin));
        Optional bBegin = b2.getLocation().flatMap(l2 -> l2.getBegin().getRange().map(r2 -> r2.begin));
        if (aBegin.isPresent() && bBegin.isPresent()) {
            return ((Position)aBegin.get()).compareTo((Position)bBegin.get());
        }
        if (a2.getLocation().isPresent() || b2.getLocation().isPresent()) {
            if (a2.getLocation().isPresent()) {
                return 1;
            }
            return -1;
        }
        return 0;
    };

    public Problem(String message, TokenRange location, Throwable cause) {
        Utils.assertNotNull(message);
        this.message = message;
        this.location = location;
        this.cause = cause;
    }

    public String toString() {
        StringBuilder str = new StringBuilder(this.getVerboseMessage());
        if (this.cause != null) {
            str.append(Utils.EOL).append("Problem stacktrace : ").append(Utils.EOL);
            for (int i2 = 0; i2 < this.cause.getStackTrace().length; ++i2) {
                StackTraceElement ste = this.cause.getStackTrace()[i2];
                str.append("  ").append(ste.toString());
                if (i2 + 1 == this.cause.getStackTrace().length) continue;
                str.append(Utils.EOL);
            }
        }
        return str.toString();
    }

    public String getMessage() {
        return this.message;
    }

    public String getVerboseMessage() {
        return this.getLocation().map(l2 -> l2.getBegin().getRange().map(r2 -> r2.begin.toString()).orElse("(line ?,col ?)") + " " + this.message).orElse(this.message);
    }

    public Optional<TokenRange> getLocation() {
        return Optional.ofNullable(this.location);
    }

    @Deprecated
    public Optional<TokenRange> getRange() {
        return this.getLocation();
    }

    public Optional<Throwable> getCause() {
        return Optional.ofNullable(this.cause);
    }
}

