/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.nodeTypes;

import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.nodeTypes.NodeWithMembers;
import com.github.javaparser.ast.nodeTypes.NodeWithSimpleName;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public interface NodeWithConstructors<N extends Node>
extends NodeWithSimpleName<N>,
NodeWithMembers<N> {
    default public Optional<ConstructorDeclaration> getDefaultConstructor() {
        return this.getMembers().stream().filter(bd2 -> bd2 instanceof ConstructorDeclaration).map(bd2 -> (ConstructorDeclaration)bd2).filter(cd2 -> cd2.getParameters().isEmpty()).findFirst();
    }

    default public ConstructorDeclaration addConstructor(Modifier ... modifiers) {
        ConstructorDeclaration constructorDeclaration = new ConstructorDeclaration();
        constructorDeclaration.setModifiers(Arrays.stream(modifiers).collect(Collectors.toCollection(() -> EnumSet.noneOf(Modifier.class))));
        constructorDeclaration.setName(this.getName());
        this.getMembers().add(constructorDeclaration);
        return constructorDeclaration;
    }

    default public List<ConstructorDeclaration> getConstructors() {
        return Collections.unmodifiableList(this.getMembers().stream().filter(m3 -> m3 instanceof ConstructorDeclaration).map(m3 -> (ConstructorDeclaration)m3).collect(Collectors.toList()));
    }

    default public Optional<ConstructorDeclaration> getConstructorByParameterTypes(String ... paramTypes) {
        return this.getConstructors().stream().filter(m3 -> m3.hasParametersOfType(paramTypes)).findFirst();
    }

    default public Optional<ConstructorDeclaration> getConstructorByParameterTypes(Class<?> ... paramTypes) {
        return this.getConstructors().stream().filter(m3 -> m3.hasParametersOfType(paramTypes)).findFirst();
    }
}

