/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.validator.chunks;

import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.body.AnnotationDeclaration;
import com.github.javaparser.ast.body.AnnotationMemberDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.modules.ModuleRequiresStmt;
import com.github.javaparser.ast.nodeTypes.NodeWithModifiers;
import com.github.javaparser.ast.nodeTypes.NodeWithTokenRange;
import com.github.javaparser.ast.stmt.CatchClause;
import com.github.javaparser.ast.validator.ProblemReporter;
import com.github.javaparser.ast.validator.VisitorValidator;
import com.github.javaparser.utils.SeparatedItemStringBuilder;
import java.util.ArrayList;
import java.util.Arrays;

public class ModifierValidator
extends VisitorValidator {
    private final Modifier[] interfaceWithNothingSpecial = new Modifier[]{Modifier.PUBLIC, Modifier.PROTECTED, Modifier.ABSTRACT, Modifier.FINAL, Modifier.SYNCHRONIZED, Modifier.NATIVE, Modifier.STRICTFP};
    private final Modifier[] interfaceWithStaticAndDefault = new Modifier[]{Modifier.PUBLIC, Modifier.PROTECTED, Modifier.ABSTRACT, Modifier.STATIC, Modifier.FINAL, Modifier.SYNCHRONIZED, Modifier.NATIVE, Modifier.STRICTFP, Modifier.DEFAULT};
    private final Modifier[] interfaceWithStaticAndDefaultAndPrivate = new Modifier[]{Modifier.PUBLIC, Modifier.PROTECTED, Modifier.PRIVATE, Modifier.ABSTRACT, Modifier.STATIC, Modifier.FINAL, Modifier.SYNCHRONIZED, Modifier.NATIVE, Modifier.STRICTFP, Modifier.DEFAULT};
    private final boolean hasStrictfp;
    private final boolean hasDefaultAndStaticInterfaceMethods;
    private final boolean hasPrivateInterfaceMethods;

    public ModifierValidator(boolean hasStrictfp, boolean hasDefaultAndStaticInterfaceMethods, boolean hasPrivateInterfaceMethods) {
        this.hasStrictfp = hasStrictfp;
        this.hasDefaultAndStaticInterfaceMethods = hasDefaultAndStaticInterfaceMethods;
        this.hasPrivateInterfaceMethods = hasPrivateInterfaceMethods;
    }

    @Override
    public void visit(ClassOrInterfaceDeclaration n2, ProblemReporter reporter) {
        if (n2.isInterface()) {
            this.validateInterfaceModifiers(n2, reporter);
        } else {
            this.validateClassModifiers(n2, reporter);
        }
        super.visit(n2, reporter);
    }

    private void validateClassModifiers(ClassOrInterfaceDeclaration n2, ProblemReporter reporter) {
        if (n2.isTopLevelType()) {
            this.validateModifiers((NodeWithModifiers<?> & NodeWithTokenRange<?>)n2, reporter, Modifier.PUBLIC, Modifier.ABSTRACT, Modifier.FINAL, Modifier.STRICTFP);
        } else if (n2.isNestedType()) {
            this.validateModifiers((NodeWithModifiers<?> & NodeWithTokenRange<?>)n2, reporter, Modifier.PUBLIC, Modifier.PROTECTED, Modifier.PRIVATE, Modifier.ABSTRACT, Modifier.STATIC, Modifier.FINAL, Modifier.STRICTFP);
        } else if (n2.isLocalClassDeclaration()) {
            this.validateModifiers((NodeWithModifiers<?> & NodeWithTokenRange<?>)n2, reporter, Modifier.ABSTRACT, Modifier.FINAL, Modifier.STRICTFP);
        }
    }

    private void validateInterfaceModifiers(TypeDeclaration<?> n2, ProblemReporter reporter) {
        if (n2.isTopLevelType()) {
            this.validateModifiers((NodeWithModifiers<?> & NodeWithTokenRange<?>)n2, reporter, Modifier.PUBLIC, Modifier.ABSTRACT, Modifier.STRICTFP);
        } else if (n2.isNestedType()) {
            this.validateModifiers((NodeWithModifiers<?> & NodeWithTokenRange<?>)n2, reporter, Modifier.PUBLIC, Modifier.PROTECTED, Modifier.PRIVATE, Modifier.ABSTRACT, Modifier.STATIC, Modifier.STRICTFP);
        }
    }

    @Override
    public void visit(EnumDeclaration n2, ProblemReporter reporter) {
        if (n2.isTopLevelType()) {
            this.validateModifiers((NodeWithModifiers<?> & NodeWithTokenRange<?>)n2, reporter, Modifier.PUBLIC, Modifier.STRICTFP);
        } else if (n2.isNestedType()) {
            this.validateModifiers((NodeWithModifiers<?> & NodeWithTokenRange<?>)n2, reporter, Modifier.PUBLIC, Modifier.PROTECTED, Modifier.PRIVATE, Modifier.STATIC, Modifier.STRICTFP);
        }
        super.visit(n2, reporter);
    }

    @Override
    public void visit(AnnotationDeclaration n2, ProblemReporter reporter) {
        this.validateInterfaceModifiers(n2, reporter);
        super.visit(n2, reporter);
    }

    @Override
    public void visit(AnnotationMemberDeclaration n2, ProblemReporter reporter) {
        this.validateModifiers((NodeWithModifiers<?> & NodeWithTokenRange<?>)n2, reporter, Modifier.PUBLIC, Modifier.ABSTRACT);
        super.visit(n2, reporter);
    }

    @Override
    public void visit(ConstructorDeclaration n2, ProblemReporter reporter) {
        this.validateModifiers((NodeWithModifiers<?> & NodeWithTokenRange<?>)n2, reporter, Modifier.PUBLIC, Modifier.PROTECTED, Modifier.PRIVATE);
        n2.getParameters().forEach(p2 -> this.validateModifiers(p2, reporter, Modifier.FINAL));
        super.visit(n2, reporter);
    }

    @Override
    public void visit(FieldDeclaration n2, ProblemReporter reporter) {
        this.validateModifiers((NodeWithModifiers<?> & NodeWithTokenRange<?>)n2, reporter, Modifier.PUBLIC, Modifier.PROTECTED, Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL, Modifier.TRANSIENT, Modifier.VOLATILE);
        super.visit(n2, reporter);
    }

    @Override
    public void visit(MethodDeclaration n2, ProblemReporter reporter) {
        if (n2.isAbstract()) {
            SeparatedItemStringBuilder builder = new SeparatedItemStringBuilder("Cannot be 'abstract' and also '", "', '", "'.");
            for (Modifier m3 : Arrays.asList(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL, Modifier.NATIVE, Modifier.STRICTFP, Modifier.SYNCHRONIZED)) {
                if (!n2.getModifiers().contains((Object)m3)) continue;
                builder.append(m3.asString(), new Object[0]);
            }
            if (builder.hasItems()) {
                reporter.report(n2, builder.toString(), new Object[0]);
            }
        }
        if (n2.getParentNode().isPresent() && n2.getParentNode().get() instanceof ClassOrInterfaceDeclaration) {
            if (((ClassOrInterfaceDeclaration)n2.getParentNode().get()).isInterface()) {
                if (this.hasDefaultAndStaticInterfaceMethods) {
                    if (this.hasPrivateInterfaceMethods) {
                        this.validateModifiers(n2, reporter, this.interfaceWithStaticAndDefaultAndPrivate);
                    } else {
                        this.validateModifiers(n2, reporter, this.interfaceWithStaticAndDefault);
                    }
                } else {
                    this.validateModifiers(n2, reporter, this.interfaceWithNothingSpecial);
                }
            } else {
                this.validateModifiers((NodeWithModifiers<?> & NodeWithTokenRange<?>)n2, reporter, Modifier.PUBLIC, Modifier.PROTECTED, Modifier.PRIVATE, Modifier.ABSTRACT, Modifier.STATIC, Modifier.FINAL, Modifier.SYNCHRONIZED, Modifier.NATIVE, Modifier.STRICTFP);
            }
        }
        n2.getParameters().forEach(p2 -> this.validateModifiers(p2, reporter, Modifier.FINAL));
        super.visit(n2, reporter);
    }

    @Override
    public void visit(LambdaExpr n2, ProblemReporter reporter) {
        n2.getParameters().forEach(p2 -> this.validateModifiers(p2, reporter, Modifier.FINAL));
        super.visit(n2, reporter);
    }

    @Override
    public void visit(CatchClause n2, ProblemReporter reporter) {
        this.validateModifiers(n2.getParameter(), reporter, Modifier.FINAL);
        super.visit(n2, reporter);
    }

    @Override
    public void visit(VariableDeclarationExpr n2, ProblemReporter reporter) {
        this.validateModifiers(n2, reporter, Modifier.FINAL);
        super.visit(n2, reporter);
    }

    @Override
    public void visit(ModuleRequiresStmt n2, ProblemReporter reporter) {
        this.validateModifiers((NodeWithModifiers<?> & NodeWithTokenRange<?>)n2, reporter, Modifier.TRANSITIVE, Modifier.STATIC);
        super.visit(n2, reporter);
    }

    private <T extends NodeWithModifiers<?> & NodeWithTokenRange<?>> void validateModifiers(T n2, ProblemReporter reporter, Modifier ... allowedModifiers) {
        this.validateAtMostOneOf(n2, reporter, new Modifier[]{Modifier.PUBLIC, Modifier.PROTECTED, Modifier.PRIVATE});
        this.validateAtMostOneOf(n2, reporter, new Modifier[]{Modifier.FINAL, Modifier.ABSTRACT});
        if (this.hasStrictfp) {
            this.validateAtMostOneOf(n2, reporter, new Modifier[]{Modifier.NATIVE, Modifier.STRICTFP});
        } else {
            allowedModifiers = this.removeModifierFromArray(Modifier.STRICTFP, allowedModifiers);
        }
        for (Modifier m3 : n2.getModifiers()) {
            if (this.arrayContains((Object[])allowedModifiers, (Object)m3)) continue;
            reporter.report(n2, "'%s' is not allowed here.", m3.asString());
        }
    }

    private Modifier[] removeModifierFromArray(Modifier m3, Modifier[] allowedModifiers) {
        ArrayList<Modifier> newModifiers = new ArrayList<Modifier>(Arrays.asList(allowedModifiers));
        newModifiers.remove((Object)m3);
        allowedModifiers = newModifiers.toArray(new Modifier[0]);
        return allowedModifiers;
    }

    private boolean arrayContains(Object[] items, Object searchItem) {
        for (Object o2 : items) {
            if (o2 != searchItem) continue;
            return true;
        }
        return false;
    }

    private <T extends NodeWithModifiers<?> & NodeWithTokenRange<?>> void validateAtMostOneOf(T t2, ProblemReporter reporter, Modifier ... modifiers) {
        ArrayList<Modifier> foundModifiers = new ArrayList<Modifier>();
        for (Modifier m3 : modifiers) {
            if (!t2.getModifiers().contains((Object)m3)) continue;
            foundModifiers.add(m3);
        }
        if (foundModifiers.size() > 1) {
            SeparatedItemStringBuilder builder = new SeparatedItemStringBuilder("Can have only one of '", "', '", "'.");
            for (Modifier m4 : foundModifiers) {
                builder.append(m4.asString(), new Object[0]);
            }
            reporter.report(t2, builder.toString(), new Object[0]);
        }
    }
}

