/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.printer;

import com.github.javaparser.Position;
import com.github.javaparser.ast.ArrayCreationLevel;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.PackageDeclaration;
import com.github.javaparser.ast.body.AnnotationDeclaration;
import com.github.javaparser.ast.body.AnnotationMemberDeclaration;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.EnumConstantDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.InitializerDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.ReceiverParameter;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.comments.BlockComment;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.ast.comments.LineComment;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.ArrayAccessExpr;
import com.github.javaparser.ast.expr.ArrayCreationExpr;
import com.github.javaparser.ast.expr.ArrayInitializerExpr;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.CastExpr;
import com.github.javaparser.ast.expr.CharLiteralExpr;
import com.github.javaparser.ast.expr.ClassExpr;
import com.github.javaparser.ast.expr.ConditionalExpr;
import com.github.javaparser.ast.expr.DoubleLiteralExpr;
import com.github.javaparser.ast.expr.EnclosedExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.InstanceOfExpr;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.LongLiteralExpr;
import com.github.javaparser.ast.expr.MarkerAnnotationExpr;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.MethodReferenceExpr;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.expr.NullLiteralExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.expr.SuperExpr;
import com.github.javaparser.ast.expr.ThisExpr;
import com.github.javaparser.ast.expr.TypeExpr;
import com.github.javaparser.ast.expr.UnaryExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.modules.ModuleDeclaration;
import com.github.javaparser.ast.modules.ModuleExportsStmt;
import com.github.javaparser.ast.modules.ModuleOpensStmt;
import com.github.javaparser.ast.modules.ModuleProvidesStmt;
import com.github.javaparser.ast.modules.ModuleRequiresStmt;
import com.github.javaparser.ast.modules.ModuleUsesStmt;
import com.github.javaparser.ast.nodeTypes.NodeWithTypeArguments;
import com.github.javaparser.ast.nodeTypes.NodeWithVariables;
import com.github.javaparser.ast.stmt.AssertStmt;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.BreakStmt;
import com.github.javaparser.ast.stmt.CatchClause;
import com.github.javaparser.ast.stmt.ContinueStmt;
import com.github.javaparser.ast.stmt.DoStmt;
import com.github.javaparser.ast.stmt.EmptyStmt;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ForStmt;
import com.github.javaparser.ast.stmt.ForeachStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.LabeledStmt;
import com.github.javaparser.ast.stmt.LocalClassDeclarationStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.stmt.SwitchEntryStmt;
import com.github.javaparser.ast.stmt.SwitchStmt;
import com.github.javaparser.ast.stmt.SynchronizedStmt;
import com.github.javaparser.ast.stmt.ThrowStmt;
import com.github.javaparser.ast.stmt.TryStmt;
import com.github.javaparser.ast.stmt.UnparsableStmt;
import com.github.javaparser.ast.stmt.WhileStmt;
import com.github.javaparser.ast.type.ArrayType;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.IntersectionType;
import com.github.javaparser.ast.type.PrimitiveType;
import com.github.javaparser.ast.type.ReferenceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.TypeParameter;
import com.github.javaparser.ast.type.UnionType;
import com.github.javaparser.ast.type.UnknownType;
import com.github.javaparser.ast.type.VarType;
import com.github.javaparser.ast.type.VoidType;
import com.github.javaparser.ast.type.WildcardType;
import com.github.javaparser.ast.visitor.Visitable;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.printer.PrettyPrinterConfiguration;
import com.github.javaparser.printer.SourcePrinter;
import com.github.javaparser.utils.PositionUtils;
import com.github.javaparser.utils.Utils;
import java.util.Deque;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Optional;
import java.util.stream.Collectors;

public class PrettyPrintVisitor
implements VoidVisitor<Void> {
    protected final PrettyPrinterConfiguration configuration;
    protected final SourcePrinter printer;
    private Deque<Position> methodChainPositions = new LinkedList<Position>();

    public PrettyPrintVisitor(PrettyPrinterConfiguration prettyPrinterConfiguration) {
        this.configuration = prettyPrinterConfiguration;
        this.printer = new SourcePrinter(this.configuration.getIndent(), this.configuration.getEndOfLineCharacter());
        this.pushMethodChainPosition(this.printer.getCursor());
    }

    public String getSource() {
        return this.printer.getSource();
    }

    public void resetMethodChainPosition(Position position) {
        this.methodChainPositions.pop();
        this.methodChainPositions.push(position);
    }

    public void pushMethodChainPosition(Position position) {
        this.methodChainPositions.push(position);
    }

    public Position peekMethodChainPosition() {
        return this.methodChainPositions.peek();
    }

    public Position popMethodChainPosition() {
        return this.methodChainPositions.pop();
    }

    private void printModifiers(EnumSet<Modifier> modifiers) {
        if (modifiers.size() > 0) {
            this.printer.print(modifiers.stream().map(Modifier::asString).collect(Collectors.joining(" ")) + " ");
        }
    }

    private void printMembers(NodeList<BodyDeclaration<?>> members, Void arg) {
        for (BodyDeclaration<?> member : members) {
            this.printer.println();
            member.accept(this, arg);
            this.printer.println();
        }
    }

    private void printMemberAnnotations(NodeList<AnnotationExpr> annotations, Void arg) {
        if (annotations.isEmpty()) {
            return;
        }
        for (AnnotationExpr a2 : annotations) {
            a2.accept(this, arg);
            this.printer.println();
        }
    }

    private void printAnnotations(NodeList<AnnotationExpr> annotations, boolean prefixWithASpace, Void arg) {
        if (annotations.isEmpty()) {
            return;
        }
        if (prefixWithASpace) {
            this.printer.print(" ");
        }
        for (AnnotationExpr annotation : annotations) {
            annotation.accept(this, arg);
            this.printer.print(" ");
        }
    }

    private void printTypeArgs(NodeWithTypeArguments<?> nodeWithTypeArguments, Void arg) {
        NodeList typeArguments = nodeWithTypeArguments.getTypeArguments().orElse(null);
        if (!Utils.isNullOrEmpty(typeArguments)) {
            this.printer.print("<");
            Iterator i2 = typeArguments.iterator();
            while (i2.hasNext()) {
                Type t2 = (Type)i2.next();
                t2.accept(this, arg);
                if (!i2.hasNext()) continue;
                this.printer.print(", ");
            }
            this.printer.print(">");
        }
    }

    private void printTypeParameters(NodeList<TypeParameter> args, Void arg) {
        if (!Utils.isNullOrEmpty(args)) {
            this.printer.print("<");
            Iterator<TypeParameter> i2 = args.iterator();
            while (i2.hasNext()) {
                TypeParameter t2 = i2.next();
                t2.accept(this, arg);
                if (!i2.hasNext()) continue;
                this.printer.print(", ");
            }
            this.printer.print(">");
        }
    }

    private void printArguments(NodeList<Expression> args, Void arg) {
        this.printer.print("(");
        Position cursorRef = this.printer.getCursor();
        if (!Utils.isNullOrEmpty(args)) {
            Iterator<Expression> i2 = args.iterator();
            while (i2.hasNext()) {
                Expression e2 = i2.next();
                e2.accept(this, arg);
                if (!i2.hasNext()) continue;
                this.printer.print(",");
                if (this.configuration.isColumnAlignParameters()) {
                    this.printer.wrapToColumn(cursorRef.column);
                    continue;
                }
                this.printer.print(" ");
            }
        }
        this.printer.print(")");
    }

    private void printPrePostFixOptionalList(NodeList<? extends Visitable> args, Void arg, String prefix, String separator, String postfix) {
        if (!args.isEmpty()) {
            this.printer.print(prefix);
            Iterator<? extends Visitable> i2 = args.iterator();
            while (i2.hasNext()) {
                Visitable v2 = i2.next();
                v2.accept(this, arg);
                if (!i2.hasNext()) continue;
                this.printer.print(separator);
            }
            this.printer.print(postfix);
        }
    }

    private void printPrePostFixRequiredList(NodeList<? extends Visitable> args, Void arg, String prefix, String separator, String postfix) {
        this.printer.print(prefix);
        if (!args.isEmpty()) {
            Iterator<? extends Visitable> i2 = args.iterator();
            while (i2.hasNext()) {
                Visitable v2 = i2.next();
                v2.accept(this, arg);
                if (!i2.hasNext()) continue;
                this.printer.print(separator);
            }
        }
        this.printer.print(postfix);
    }

    private void printComment(Optional<Comment> comment, Void arg) {
        comment.ifPresent(c2 -> c2.accept(this, arg));
    }

    @Override
    public void visit(CompilationUnit n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        if (n2.getParsed() == Node.Parsedness.UNPARSABLE) {
            this.printer.println("???");
            return;
        }
        if (n2.getPackageDeclaration().isPresent()) {
            n2.getPackageDeclaration().get().accept(this, arg);
        }
        n2.getImports().accept(this, arg);
        if (!n2.getImports().isEmpty()) {
            this.printer.println();
        }
        Iterator<TypeDeclaration<?>> i2 = n2.getTypes().iterator();
        while (i2.hasNext()) {
            i2.next().accept(this, arg);
            this.printer.println();
            if (!i2.hasNext()) continue;
            this.printer.println();
        }
        n2.getModule().ifPresent(m3 -> m3.accept(this, arg));
        this.printOrphanCommentsEnding(n2);
    }

    @Override
    public void visit(PackageDeclaration n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        this.printAnnotations(n2.getAnnotations(), false, arg);
        this.printer.print("package ");
        n2.getName().accept(this, arg);
        this.printer.println(";");
        this.printer.println();
        this.printOrphanCommentsEnding(n2);
    }

    @Override
    public void visit(NameExpr n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        n2.getName().accept(this, arg);
        this.printOrphanCommentsEnding(n2);
    }

    @Override
    public void visit(Name n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        if (n2.getQualifier().isPresent()) {
            n2.getQualifier().get().accept(this, arg);
            this.printer.print(".");
        }
        this.printAnnotations(n2.getAnnotations(), false, arg);
        this.printer.print(n2.getIdentifier());
        this.printOrphanCommentsEnding(n2);
    }

    @Override
    public void visit(SimpleName n2, Void arg) {
        this.printer.print(n2.getIdentifier());
    }

    @Override
    public void visit(ClassOrInterfaceDeclaration n2, Void arg) {
        ClassOrInterfaceType c2;
        Iterator<ClassOrInterfaceType> i2;
        this.printComment(n2.getComment(), arg);
        this.printMemberAnnotations(n2.getAnnotations(), arg);
        this.printModifiers(n2.getModifiers());
        if (n2.isInterface()) {
            this.printer.print("interface ");
        } else {
            this.printer.print("class ");
        }
        n2.getName().accept(this, arg);
        this.printTypeParameters(n2.getTypeParameters(), arg);
        if (!n2.getExtendedTypes().isEmpty()) {
            this.printer.print(" extends ");
            i2 = n2.getExtendedTypes().iterator();
            while (i2.hasNext()) {
                c2 = i2.next();
                c2.accept(this, arg);
                if (!i2.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        if (!n2.getImplementedTypes().isEmpty()) {
            this.printer.print(" implements ");
            i2 = n2.getImplementedTypes().iterator();
            while (i2.hasNext()) {
                c2 = i2.next();
                c2.accept(this, arg);
                if (!i2.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.println(" {");
        this.printer.indent();
        if (!Utils.isNullOrEmpty(n2.getMembers())) {
            this.printMembers(n2.getMembers(), arg);
        }
        this.printOrphanCommentsEnding(n2);
        this.printer.unindent();
        this.printer.print("}");
    }

    @Override
    public void visit(JavadocComment n2, Void arg) {
        if (this.configuration.isPrintComments() && this.configuration.isPrintJavadoc()) {
            this.printer.println("/**");
            String commentContent = Utils.normalizeEolInTextBlock(n2.getContent(), this.configuration.getEndOfLineCharacter());
            String[] lines = commentContent.split("\\R");
            boolean skippingLeadingEmptyLines = true;
            boolean prependEmptyLine = false;
            for (String line : lines) {
                String trimmedLine = line.trim();
                if (trimmedLine.startsWith("*")) {
                    line = trimmedLine.substring(1);
                }
                if ((line = Utils.trimTrailingSpaces(line)).isEmpty()) {
                    if (skippingLeadingEmptyLines) continue;
                    prependEmptyLine = true;
                    continue;
                }
                skippingLeadingEmptyLines = false;
                if (prependEmptyLine) {
                    this.printer.println(" *");
                    prependEmptyLine = false;
                }
                this.printer.println(" *" + line);
            }
            this.printer.println(" */");
        }
    }

    @Override
    public void visit(ClassOrInterfaceType n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        if (n2.getScope().isPresent()) {
            n2.getScope().get().accept(this, arg);
            this.printer.print(".");
        }
        for (AnnotationExpr ae2 : n2.getAnnotations()) {
            ae2.accept(this, arg);
            this.printer.print(" ");
        }
        n2.getName().accept(this, arg);
        if (n2.isUsingDiamondOperator()) {
            this.printer.print("<>");
        } else {
            this.printTypeArgs(n2, arg);
        }
    }

    @Override
    public void visit(TypeParameter n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        for (AnnotationExpr ann : n2.getAnnotations()) {
            ann.accept(this, arg);
            this.printer.print(" ");
        }
        n2.getName().accept(this, arg);
        if (!Utils.isNullOrEmpty(n2.getTypeBound())) {
            this.printer.print(" extends ");
            Iterator<ClassOrInterfaceType> i2 = n2.getTypeBound().iterator();
            while (i2.hasNext()) {
                ClassOrInterfaceType c2 = i2.next();
                c2.accept(this, arg);
                if (!i2.hasNext()) continue;
                this.printer.print(" & ");
            }
        }
    }

    @Override
    public void visit(PrimitiveType n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        this.printAnnotations(n2.getAnnotations(), true, arg);
        this.printer.print(n2.getType().asString());
    }

    @Override
    public void visit(ArrayType n2, Void arg) {
        LinkedList<ArrayType> arrayTypeBuffer = new LinkedList<ArrayType>();
        Type type = n2;
        while (type instanceof ArrayType) {
            ArrayType arrayType = type;
            arrayTypeBuffer.add(arrayType);
            type = arrayType.getComponentType();
        }
        type.accept(this, arg);
        for (ArrayType arrayType : arrayTypeBuffer) {
            this.printAnnotations(arrayType.getAnnotations(), true, arg);
            this.printer.print("[]");
        }
    }

    @Override
    public void visit(ArrayCreationLevel n2, Void arg) {
        this.printAnnotations(n2.getAnnotations(), true, arg);
        this.printer.print("[");
        if (n2.getDimension().isPresent()) {
            n2.getDimension().get().accept(this, arg);
        }
        this.printer.print("]");
    }

    @Override
    public void visit(IntersectionType n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        this.printAnnotations(n2.getAnnotations(), false, arg);
        boolean isFirst = true;
        for (ReferenceType element : n2.getElements()) {
            if (isFirst) {
                isFirst = false;
            } else {
                this.printer.print(" & ");
            }
            element.accept(this, arg);
        }
    }

    @Override
    public void visit(UnionType n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        this.printAnnotations(n2.getAnnotations(), true, arg);
        boolean isFirst = true;
        for (ReferenceType element : n2.getElements()) {
            if (isFirst) {
                isFirst = false;
            } else {
                this.printer.print(" | ");
            }
            element.accept(this, arg);
        }
    }

    @Override
    public void visit(WildcardType n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        this.printAnnotations(n2.getAnnotations(), false, arg);
        this.printer.print("?");
        if (n2.getExtendedType().isPresent()) {
            this.printer.print(" extends ");
            n2.getExtendedType().get().accept(this, arg);
        }
        if (n2.getSuperType().isPresent()) {
            this.printer.print(" super ");
            n2.getSuperType().get().accept(this, arg);
        }
    }

    @Override
    public void visit(UnknownType n2, Void arg) {
    }

    @Override
    public void visit(FieldDeclaration n2, Void arg) {
        this.printOrphanCommentsBeforeThisChildNode(n2);
        this.printComment(n2.getComment(), arg);
        this.printMemberAnnotations(n2.getAnnotations(), arg);
        this.printModifiers(n2.getModifiers());
        if (!n2.getVariables().isEmpty()) {
            Optional<Type> maximumCommonType = n2.getMaximumCommonType();
            maximumCommonType.ifPresent(t2 -> t2.accept(this, arg));
            if (!maximumCommonType.isPresent()) {
                this.printer.print("???");
            }
        }
        this.printer.print(" ");
        Iterator<VariableDeclarator> i2 = n2.getVariables().iterator();
        while (i2.hasNext()) {
            VariableDeclarator var = i2.next();
            var.accept(this, arg);
            if (!i2.hasNext()) continue;
            this.printer.print(", ");
        }
        this.printer.print(";");
    }

    @Override
    public void visit(VariableDeclarator n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        n2.getName().accept(this, arg);
        n2.getAncestorOfType(NodeWithVariables.class).ifPresent(ancestor -> ancestor.getMaximumCommonType().ifPresent(commonType -> {
            Type type = n2.getType();
            ArrayType arrayType = null;
            for (int i2 = commonType.getArrayLevel(); i2 < type.getArrayLevel(); ++i2) {
                arrayType = arrayType == null ? (ArrayType)type : (ArrayType)arrayType.getComponentType();
                this.printAnnotations(arrayType.getAnnotations(), true, arg);
                this.printer.print("[]");
            }
        }));
        if (n2.getInitializer().isPresent()) {
            this.printer.print(" = ");
            n2.getInitializer().get().accept(this, arg);
        }
    }

    @Override
    public void visit(ArrayInitializerExpr n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        this.printer.print("{");
        if (!Utils.isNullOrEmpty(n2.getValues())) {
            this.printer.print(" ");
            Iterator<Expression> i2 = n2.getValues().iterator();
            while (i2.hasNext()) {
                Expression expr = i2.next();
                expr.accept(this, arg);
                if (!i2.hasNext()) continue;
                this.printer.print(", ");
            }
            this.printer.print(" ");
        }
        this.printOrphanCommentsEnding(n2);
        this.printer.print("}");
    }

    @Override
    public void visit(VoidType n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        this.printAnnotations(n2.getAnnotations(), false, arg);
        this.printer.print("void");
    }

    @Override
    public void visit(VarType n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        this.printAnnotations(n2.getAnnotations(), false, arg);
        this.printer.print("var");
    }

    @Override
    public void visit(ArrayAccessExpr n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        n2.getName().accept(this, arg);
        this.printer.print("[");
        n2.getIndex().accept(this, arg);
        this.printer.print("]");
    }

    @Override
    public void visit(ArrayCreationExpr n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        this.printer.print("new ");
        n2.getElementType().accept(this, arg);
        for (ArrayCreationLevel level : n2.getLevels()) {
            level.accept(this, arg);
        }
        if (n2.getInitializer().isPresent()) {
            this.printer.print(" ");
            n2.getInitializer().get().accept(this, arg);
        }
    }

    @Override
    public void visit(AssignExpr n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        n2.getTarget().accept(this, arg);
        this.printer.print(" ");
        this.printer.print(n2.getOperator().asString());
        this.printer.print(" ");
        n2.getValue().accept(this, arg);
    }

    @Override
    public void visit(BinaryExpr n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        n2.getLeft().accept(this, arg);
        this.printer.print(" ");
        this.printer.print(n2.getOperator().asString());
        this.printer.print(" ");
        n2.getRight().accept(this, arg);
    }

    @Override
    public void visit(CastExpr n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        this.printer.print("(");
        n2.getType().accept(this, arg);
        this.printer.print(") ");
        n2.getExpression().accept(this, arg);
    }

    @Override
    public void visit(ClassExpr n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        n2.getType().accept(this, arg);
        this.printer.print(".class");
    }

    @Override
    public void visit(ConditionalExpr n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        n2.getCondition().accept(this, arg);
        this.printer.print(" ? ");
        n2.getThenExpr().accept(this, arg);
        this.printer.print(" : ");
        n2.getElseExpr().accept(this, arg);
    }

    @Override
    public void visit(EnclosedExpr n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        this.printer.print("(");
        n2.getInner().accept(this, arg);
        this.printer.print(")");
    }

    @Override
    public void visit(FieldAccessExpr n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        n2.getScope().accept(this, arg);
        this.printer.print(".");
        n2.getName().accept(this, arg);
    }

    @Override
    public void visit(InstanceOfExpr n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        n2.getExpression().accept(this, arg);
        this.printer.print(" instanceof ");
        n2.getType().accept(this, arg);
    }

    @Override
    public void visit(CharLiteralExpr n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        this.printer.print("'");
        this.printer.print(n2.getValue());
        this.printer.print("'");
    }

    @Override
    public void visit(DoubleLiteralExpr n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        this.printer.print(n2.getValue());
    }

    @Override
    public void visit(IntegerLiteralExpr n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        this.printer.print(n2.getValue());
    }

    @Override
    public void visit(LongLiteralExpr n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        this.printer.print(n2.getValue());
    }

    @Override
    public void visit(StringLiteralExpr n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        this.printer.print("\"");
        this.printer.print(n2.getValue());
        this.printer.print("\"");
    }

    @Override
    public void visit(BooleanLiteralExpr n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        this.printer.print(String.valueOf(n2.getValue()));
    }

    @Override
    public void visit(NullLiteralExpr n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        this.printer.print("null");
    }

    @Override
    public void visit(ThisExpr n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        if (n2.getClassExpr().isPresent()) {
            n2.getClassExpr().get().accept(this, arg);
            this.printer.print(".");
        }
        this.printer.print("this");
    }

    @Override
    public void visit(SuperExpr n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        if (n2.getClassExpr().isPresent()) {
            n2.getClassExpr().get().accept(this, arg);
            this.printer.print(".");
        }
        this.printer.print("super");
    }

    @Override
    public void visit(MethodCallExpr n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        if (n2.getScope().isPresent()) {
            n2.getScope().get().accept(this, arg);
            if (this.configuration.isColumnAlignFirstMethodChain()) {
                if (!(n2.getScope().get() instanceof MethodCallExpr) || !((MethodCallExpr)n2.getScope().get()).getScope().isPresent()) {
                    this.resetMethodChainPosition(this.printer.getCursor());
                } else {
                    this.printer.wrapToColumn(this.peekMethodChainPosition().column);
                }
            }
            this.printer.print(".");
        }
        this.printTypeArgs(n2, arg);
        n2.getName().accept(this, arg);
        this.pushMethodChainPosition(this.printer.getCursor());
        this.printArguments(n2.getArguments(), arg);
        this.popMethodChainPosition();
    }

    @Override
    public void visit(ObjectCreationExpr n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        if (n2.getScope().isPresent()) {
            n2.getScope().get().accept(this, arg);
            this.printer.print(".");
        }
        this.printer.print("new ");
        this.printTypeArgs(n2, arg);
        if (!Utils.isNullOrEmpty(n2.getTypeArguments().orElse(null))) {
            this.printer.print(" ");
        }
        n2.getType().accept(this, arg);
        this.printArguments(n2.getArguments(), arg);
        if (n2.getAnonymousClassBody().isPresent()) {
            this.printer.println(" {");
            this.printer.indent();
            this.printMembers(n2.getAnonymousClassBody().get(), arg);
            this.printer.unindent();
            this.printer.print("}");
        }
    }

    @Override
    public void visit(UnaryExpr n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        if (n2.getOperator().isPrefix()) {
            this.printer.print(n2.getOperator().asString());
        }
        n2.getExpression().accept(this, arg);
        if (n2.getOperator().isPostfix()) {
            this.printer.print(n2.getOperator().asString());
        }
    }

    @Override
    public void visit(ConstructorDeclaration n2, Void arg) {
        Iterator<Node> i2;
        this.printComment(n2.getComment(), arg);
        this.printMemberAnnotations(n2.getAnnotations(), arg);
        this.printModifiers(n2.getModifiers());
        this.printTypeParameters(n2.getTypeParameters(), arg);
        if (n2.isGeneric()) {
            this.printer.print(" ");
        }
        n2.getName().accept(this, arg);
        this.printer.print("(");
        if (!n2.getParameters().isEmpty()) {
            i2 = n2.getParameters().iterator();
            while (i2.hasNext()) {
                Parameter p2 = i2.next();
                p2.accept(this, arg);
                if (!i2.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print(")");
        if (!Utils.isNullOrEmpty(n2.getThrownExceptions())) {
            this.printer.print(" throws ");
            i2 = n2.getThrownExceptions().iterator();
            while (i2.hasNext()) {
                ReferenceType name = (ReferenceType)i2.next();
                name.accept(this, arg);
                if (!i2.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print(" ");
        n2.getBody().accept(this, arg);
    }

    @Override
    public void visit(MethodDeclaration n2, Void arg) {
        Iterator<Node> i2;
        this.printOrphanCommentsBeforeThisChildNode(n2);
        this.printComment(n2.getComment(), arg);
        this.printMemberAnnotations(n2.getAnnotations(), arg);
        this.printModifiers(n2.getModifiers());
        this.printTypeParameters(n2.getTypeParameters(), arg);
        if (!Utils.isNullOrEmpty(n2.getTypeParameters())) {
            this.printer.print(" ");
        }
        n2.getType().accept(this, arg);
        this.printer.print(" ");
        n2.getName().accept(this, arg);
        this.printer.print("(");
        n2.getReceiverParameter().ifPresent(rp -> {
            rp.accept(this, arg);
            this.printer.print(", ");
        });
        if (!Utils.isNullOrEmpty(n2.getParameters())) {
            i2 = n2.getParameters().iterator();
            while (i2.hasNext()) {
                Parameter p2 = i2.next();
                p2.accept(this, arg);
                if (!i2.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print(")");
        if (!Utils.isNullOrEmpty(n2.getThrownExceptions())) {
            this.printer.print(" throws ");
            i2 = n2.getThrownExceptions().iterator();
            while (i2.hasNext()) {
                ReferenceType name = (ReferenceType)i2.next();
                name.accept(this, arg);
                if (!i2.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        if (!n2.getBody().isPresent()) {
            this.printer.print(";");
        } else {
            this.printer.print(" ");
            n2.getBody().get().accept(this, arg);
        }
    }

    @Override
    public void visit(Parameter n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        this.printAnnotations(n2.getAnnotations(), false, arg);
        this.printModifiers(n2.getModifiers());
        n2.getType().accept(this, arg);
        if (n2.isVarArgs()) {
            this.printAnnotations(n2.getVarArgsAnnotations(), false, arg);
            this.printer.print("...");
        }
        if (!(n2.getType() instanceof UnknownType)) {
            this.printer.print(" ");
        }
        n2.getName().accept(this, arg);
    }

    @Override
    public void visit(ReceiverParameter n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        this.printAnnotations(n2.getAnnotations(), false, arg);
        n2.getType().accept(this, arg);
        this.printer.print(" ");
        n2.getName().accept(this, arg);
    }

    @Override
    public void visit(ExplicitConstructorInvocationStmt n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        if (n2.isThis()) {
            this.printTypeArgs(n2, arg);
            this.printer.print("this");
        } else {
            if (n2.getExpression().isPresent()) {
                n2.getExpression().get().accept(this, arg);
                this.printer.print(".");
            }
            this.printTypeArgs(n2, arg);
            this.printer.print("super");
        }
        this.printArguments(n2.getArguments(), arg);
        this.printer.print(";");
    }

    @Override
    public void visit(VariableDeclarationExpr n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        this.printAnnotations(n2.getAnnotations(), false, arg);
        this.printModifiers(n2.getModifiers());
        if (!n2.getVariables().isEmpty()) {
            n2.getMaximumCommonType().ifPresent(t2 -> t2.accept(this, arg));
        }
        this.printer.print(" ");
        Iterator<VariableDeclarator> i2 = n2.getVariables().iterator();
        while (i2.hasNext()) {
            VariableDeclarator v2 = i2.next();
            v2.accept(this, arg);
            if (!i2.hasNext()) continue;
            this.printer.print(", ");
        }
    }

    @Override
    public void visit(LocalClassDeclarationStmt n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        n2.getClassDeclaration().accept(this, arg);
    }

    @Override
    public void visit(AssertStmt n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        this.printer.print("assert ");
        n2.getCheck().accept(this, arg);
        if (n2.getMessage().isPresent()) {
            this.printer.print(" : ");
            n2.getMessage().get().accept(this, arg);
        }
        this.printer.print(";");
    }

    @Override
    public void visit(BlockStmt n2, Void arg) {
        this.printOrphanCommentsBeforeThisChildNode(n2);
        this.printComment(n2.getComment(), arg);
        this.printer.println("{");
        if (n2.getStatements() != null) {
            this.printer.indent();
            for (Statement s2 : n2.getStatements()) {
                s2.accept(this, arg);
                this.printer.println();
            }
            this.printer.unindent();
        }
        this.printOrphanCommentsEnding(n2);
        this.printer.print("}");
    }

    @Override
    public void visit(LabeledStmt n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        n2.getLabel().accept(this, arg);
        this.printer.print(": ");
        n2.getStatement().accept(this, arg);
    }

    @Override
    public void visit(EmptyStmt n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        this.printer.print(";");
    }

    @Override
    public void visit(ExpressionStmt n2, Void arg) {
        this.printOrphanCommentsBeforeThisChildNode(n2);
        this.printComment(n2.getComment(), arg);
        n2.getExpression().accept(this, arg);
        this.printer.print(";");
    }

    @Override
    public void visit(SwitchStmt n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        this.printer.print("switch(");
        n2.getSelector().accept(this, arg);
        this.printer.println(") {");
        if (n2.getEntries() != null) {
            this.printer.indent();
            for (SwitchEntryStmt e2 : n2.getEntries()) {
                e2.accept(this, arg);
            }
            this.printer.unindent();
        }
        this.printer.print("}");
    }

    @Override
    public void visit(SwitchEntryStmt n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        if (n2.getLabel().isPresent()) {
            this.printer.print("case ");
            n2.getLabel().get().accept(this, arg);
            this.printer.print(":");
        } else {
            this.printer.print("default:");
        }
        this.printer.println();
        this.printer.indent();
        if (n2.getStatements() != null) {
            for (Statement s2 : n2.getStatements()) {
                s2.accept(this, arg);
                this.printer.println();
            }
        }
        this.printer.unindent();
    }

    @Override
    public void visit(BreakStmt n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        this.printer.print("break");
        n2.getLabel().ifPresent(l2 -> this.printer.print(" ").print(l2.getIdentifier()));
        this.printer.print(";");
    }

    @Override
    public void visit(ReturnStmt n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        this.printer.print("return");
        if (n2.getExpression().isPresent()) {
            this.printer.print(" ");
            n2.getExpression().get().accept(this, arg);
        }
        this.printer.print(";");
    }

    @Override
    public void visit(EnumDeclaration n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        this.printMemberAnnotations(n2.getAnnotations(), arg);
        this.printModifiers(n2.getModifiers());
        this.printer.print("enum ");
        n2.getName().accept(this, arg);
        if (!n2.getImplementedTypes().isEmpty()) {
            this.printer.print(" implements ");
            Iterator<ClassOrInterfaceType> i2 = n2.getImplementedTypes().iterator();
            while (i2.hasNext()) {
                ClassOrInterfaceType c2 = i2.next();
                c2.accept(this, arg);
                if (!i2.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.println(" {");
        this.printer.indent();
        if (n2.getEntries().isNonEmpty()) {
            boolean alignVertically = n2.getEntries().size() > this.configuration.getMaxEnumConstantsToAlignHorizontally() || n2.getEntries().stream().anyMatch(e2 -> e2.getComment().isPresent());
            this.printer.println();
            Iterator<EnumConstantDeclaration> i3 = n2.getEntries().iterator();
            while (i3.hasNext()) {
                EnumConstantDeclaration e3 = i3.next();
                e3.accept(this, arg);
                if (!i3.hasNext()) continue;
                if (alignVertically) {
                    this.printer.println(",");
                    continue;
                }
                this.printer.print(", ");
            }
        }
        if (!n2.getMembers().isEmpty()) {
            this.printer.println(";");
            this.printMembers(n2.getMembers(), arg);
        } else if (!n2.getEntries().isEmpty()) {
            this.printer.println();
        }
        this.printer.unindent();
        this.printer.print("}");
    }

    @Override
    public void visit(EnumConstantDeclaration n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        this.printMemberAnnotations(n2.getAnnotations(), arg);
        n2.getName().accept(this, arg);
        if (!n2.getArguments().isEmpty()) {
            this.printArguments(n2.getArguments(), arg);
        }
        if (!n2.getClassBody().isEmpty()) {
            this.printer.println(" {");
            this.printer.indent();
            this.printMembers(n2.getClassBody(), arg);
            this.printer.unindent();
            this.printer.println("}");
        }
    }

    @Override
    public void visit(InitializerDeclaration n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        if (n2.isStatic()) {
            this.printer.print("static ");
        }
        n2.getBody().accept(this, arg);
    }

    @Override
    public void visit(IfStmt n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        this.printer.print("if (");
        n2.getCondition().accept(this, arg);
        boolean thenBlock = n2.getThenStmt() instanceof BlockStmt;
        if (thenBlock) {
            this.printer.print(") ");
        } else {
            this.printer.println(")");
            this.printer.indent();
        }
        n2.getThenStmt().accept(this, arg);
        if (!thenBlock) {
            this.printer.unindent();
        }
        if (n2.getElseStmt().isPresent()) {
            if (thenBlock) {
                this.printer.print(" ");
            } else {
                this.printer.println();
            }
            boolean elseIf = n2.getElseStmt().orElse(null) instanceof IfStmt;
            boolean elseBlock = n2.getElseStmt().orElse(null) instanceof BlockStmt;
            if (elseIf || elseBlock) {
                this.printer.print("else ");
            } else {
                this.printer.println("else");
                this.printer.indent();
            }
            if (n2.getElseStmt().isPresent()) {
                n2.getElseStmt().get().accept(this, arg);
            }
            if (!elseIf && !elseBlock) {
                this.printer.unindent();
            }
        }
    }

    @Override
    public void visit(WhileStmt n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        this.printer.print("while (");
        n2.getCondition().accept(this, arg);
        this.printer.print(") ");
        n2.getBody().accept(this, arg);
    }

    @Override
    public void visit(ContinueStmt n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        this.printer.print("continue");
        n2.getLabel().ifPresent(l2 -> this.printer.print(" ").print(l2.getIdentifier()));
        this.printer.print(";");
    }

    @Override
    public void visit(DoStmt n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        this.printer.print("do ");
        n2.getBody().accept(this, arg);
        this.printer.print(" while (");
        n2.getCondition().accept(this, arg);
        this.printer.print(");");
    }

    @Override
    public void visit(ForeachStmt n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        this.printer.print("for (");
        n2.getVariable().accept(this, arg);
        this.printer.print(" : ");
        n2.getIterable().accept(this, arg);
        this.printer.print(") ");
        n2.getBody().accept(this, arg);
    }

    @Override
    public void visit(ForStmt n2, Void arg) {
        Expression e2;
        Iterator<Expression> i2;
        this.printComment(n2.getComment(), arg);
        this.printer.print("for (");
        if (n2.getInitialization() != null) {
            i2 = n2.getInitialization().iterator();
            while (i2.hasNext()) {
                e2 = i2.next();
                e2.accept(this, arg);
                if (!i2.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print("; ");
        if (n2.getCompare().isPresent()) {
            n2.getCompare().get().accept(this, arg);
        }
        this.printer.print("; ");
        if (n2.getUpdate() != null) {
            i2 = n2.getUpdate().iterator();
            while (i2.hasNext()) {
                e2 = i2.next();
                e2.accept(this, arg);
                if (!i2.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print(") ");
        n2.getBody().accept(this, arg);
    }

    @Override
    public void visit(ThrowStmt n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        this.printer.print("throw ");
        n2.getExpression().accept(this, arg);
        this.printer.print(";");
    }

    @Override
    public void visit(SynchronizedStmt n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        this.printer.print("synchronized (");
        n2.getExpression().accept(this, arg);
        this.printer.print(") ");
        n2.getBody().accept(this, arg);
    }

    @Override
    public void visit(TryStmt n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        this.printer.print("try ");
        if (!n2.getResources().isEmpty()) {
            this.printer.print("(");
            Iterator<Expression> resources = n2.getResources().iterator();
            boolean first = true;
            while (resources.hasNext()) {
                resources.next().accept(this, arg);
                if (resources.hasNext()) {
                    this.printer.print(";");
                    this.printer.println();
                    if (first) {
                        this.printer.indent();
                    }
                }
                first = false;
            }
            if (n2.getResources().size() > 1) {
                this.printer.unindent();
            }
            this.printer.print(") ");
        }
        n2.getTryBlock().accept(this, arg);
        for (CatchClause c2 : n2.getCatchClauses()) {
            c2.accept(this, arg);
        }
        if (n2.getFinallyBlock().isPresent()) {
            this.printer.print(" finally ");
            n2.getFinallyBlock().get().accept(this, arg);
        }
    }

    @Override
    public void visit(CatchClause n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        this.printer.print(" catch (");
        n2.getParameter().accept(this, arg);
        this.printer.print(") ");
        n2.getBody().accept(this, arg);
    }

    @Override
    public void visit(AnnotationDeclaration n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        this.printMemberAnnotations(n2.getAnnotations(), arg);
        this.printModifiers(n2.getModifiers());
        this.printer.print("@interface ");
        n2.getName().accept(this, arg);
        this.printer.println(" {");
        this.printer.indent();
        if (n2.getMembers() != null) {
            this.printMembers(n2.getMembers(), arg);
        }
        this.printer.unindent();
        this.printer.print("}");
    }

    @Override
    public void visit(AnnotationMemberDeclaration n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        this.printMemberAnnotations(n2.getAnnotations(), arg);
        this.printModifiers(n2.getModifiers());
        n2.getType().accept(this, arg);
        this.printer.print(" ");
        n2.getName().accept(this, arg);
        this.printer.print("()");
        if (n2.getDefaultValue().isPresent()) {
            this.printer.print(" default ");
            n2.getDefaultValue().get().accept(this, arg);
        }
        this.printer.print(";");
    }

    @Override
    public void visit(MarkerAnnotationExpr n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        this.printer.print("@");
        n2.getName().accept(this, arg);
    }

    @Override
    public void visit(SingleMemberAnnotationExpr n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        this.printer.print("@");
        n2.getName().accept(this, arg);
        this.printer.print("(");
        n2.getMemberValue().accept(this, arg);
        this.printer.print(")");
    }

    @Override
    public void visit(NormalAnnotationExpr n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        this.printer.print("@");
        n2.getName().accept(this, arg);
        this.printer.print("(");
        if (n2.getPairs() != null) {
            Iterator<MemberValuePair> i2 = n2.getPairs().iterator();
            while (i2.hasNext()) {
                MemberValuePair m3 = i2.next();
                m3.accept(this, arg);
                if (!i2.hasNext()) continue;
                this.printer.print(", ");
            }
        }
        this.printer.print(")");
    }

    @Override
    public void visit(MemberValuePair n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        n2.getName().accept(this, arg);
        this.printer.print(" = ");
        n2.getValue().accept(this, arg);
    }

    @Override
    public void visit(LineComment n2, Void arg) {
        if (this.configuration.isIgnoreComments()) {
            return;
        }
        this.printer.print("// ").println(Utils.normalizeEolInTextBlock(n2.getContent(), "").trim());
    }

    @Override
    public void visit(BlockComment n2, Void arg) {
        if (this.configuration.isIgnoreComments()) {
            return;
        }
        String commentContent = Utils.normalizeEolInTextBlock(n2.getContent(), this.configuration.getEndOfLineCharacter());
        String[] lines = commentContent.split("\\R", -1);
        this.printer.print("/*");
        for (int i2 = 0; i2 < lines.length - 1; ++i2) {
            this.printer.print(lines[i2]);
            this.printer.print(this.configuration.getEndOfLineCharacter());
        }
        this.printer.print(lines[lines.length - 1]);
        this.printer.println("*/");
    }

    @Override
    public void visit(LambdaExpr n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        NodeList<Parameter> parameters = n2.getParameters();
        boolean printPar = n2.isEnclosingParameters();
        if (printPar) {
            this.printer.print("(");
        }
        Iterator<Parameter> i2 = parameters.iterator();
        while (i2.hasNext()) {
            Parameter p2 = i2.next();
            p2.accept(this, arg);
            if (!i2.hasNext()) continue;
            this.printer.print(", ");
        }
        if (printPar) {
            this.printer.print(")");
        }
        this.printer.print(" -> ");
        Statement body = n2.getBody();
        if (body instanceof ExpressionStmt) {
            ((ExpressionStmt)body).getExpression().accept(this, arg);
        } else {
            body.accept(this, arg);
        }
    }

    @Override
    public void visit(MethodReferenceExpr n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        Expression scope = n2.getScope();
        String identifier = n2.getIdentifier();
        if (scope != null) {
            n2.getScope().accept(this, arg);
        }
        this.printer.print("::");
        this.printTypeArgs(n2, arg);
        if (identifier != null) {
            this.printer.print(identifier);
        }
    }

    @Override
    public void visit(TypeExpr n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        if (n2.getType() != null) {
            n2.getType().accept(this, arg);
        }
    }

    @Override
    public void visit(NodeList n2, Void arg) {
        if (this.configuration.isOrderImports() && n2.size() > 0 && n2.get(0) instanceof ImportDeclaration) {
            NodeList modifiableList = new NodeList(n2);
            modifiableList.sort((left, right) -> {
                int sort = Integer.compare(left.isStatic() ? 0 : 1, right.isStatic() ? 0 : 1);
                if (sort == 0) {
                    sort = left.getNameAsString().compareTo(right.getNameAsString());
                }
                return sort;
            });
            for (Object node : modifiableList) {
                ((Node)node).accept(this, arg);
            }
        } else {
            for (Object node : n2) {
                ((Node)node).accept(this, arg);
            }
        }
    }

    @Override
    public void visit(ImportDeclaration n2, Void arg) {
        this.printComment(n2.getComment(), arg);
        this.printer.print("import ");
        if (n2.isStatic()) {
            this.printer.print("static ");
        }
        n2.getName().accept(this, arg);
        if (n2.isAsterisk()) {
            this.printer.print(".*");
        }
        this.printer.println(";");
        this.printOrphanCommentsEnding(n2);
    }

    @Override
    public void visit(ModuleDeclaration n2, Void arg) {
        this.printAnnotations(n2.getAnnotations(), false, arg);
        this.printer.println();
        if (n2.isOpen()) {
            this.printer.print("open ");
        }
        this.printer.print("module ");
        n2.getName().accept(this, arg);
        this.printer.println(" {").indent();
        n2.getModuleStmts().accept(this, arg);
        this.printer.unindent().println("}");
    }

    @Override
    public void visit(ModuleRequiresStmt n2, Void arg) {
        this.printer.print("requires ");
        this.printModifiers(n2.getModifiers());
        n2.getName().accept(this, arg);
        this.printer.println(";");
    }

    @Override
    public void visit(ModuleExportsStmt n2, Void arg) {
        this.printer.print("exports ");
        n2.getName().accept(this, arg);
        this.printPrePostFixOptionalList(n2.getModuleNames(), arg, " to ", ", ", "");
        this.printer.println(";");
    }

    @Override
    public void visit(ModuleProvidesStmt n2, Void arg) {
        this.printer.print("provides ");
        n2.getType().accept(this, arg);
        this.printPrePostFixRequiredList(n2.getWithTypes(), arg, " with ", ", ", "");
        this.printer.println(";");
    }

    @Override
    public void visit(ModuleUsesStmt n2, Void arg) {
        this.printer.print("uses ");
        n2.getType().accept(this, arg);
        this.printer.println(";");
    }

    @Override
    public void visit(ModuleOpensStmt n2, Void arg) {
        this.printer.print("opens ");
        n2.getName().accept(this, arg);
        this.printPrePostFixOptionalList(n2.getModuleNames(), arg, " to ", ", ", "");
        this.printer.println(";");
    }

    @Override
    public void visit(UnparsableStmt n2, Void arg) {
        this.printer.print("???;");
    }

    private void printOrphanCommentsBeforeThisChildNode(Node node) {
        int i2;
        if (this.configuration.isIgnoreComments()) {
            return;
        }
        if (node instanceof Comment) {
            return;
        }
        Node parent = node.getParentNode().orElse(null);
        if (parent == null) {
            return;
        }
        LinkedList<Node> everything = new LinkedList<Node>();
        everything.addAll(parent.getChildNodes());
        PositionUtils.sortByBeginPosition(everything);
        int positionOfTheChild = -1;
        for (int i3 = 0; i3 < everything.size(); ++i3) {
            if (everything.get(i3) != node) continue;
            positionOfTheChild = i3;
        }
        if (positionOfTheChild == -1) {
            throw new AssertionError((Object)"I am not a child of my parent.");
        }
        int positionOfPreviousChild = -1;
        for (i2 = positionOfTheChild - 1; i2 >= 0 && positionOfPreviousChild == -1; --i2) {
            if (everything.get(i2) instanceof Comment) continue;
            positionOfPreviousChild = i2;
        }
        for (i2 = positionOfPreviousChild + 1; i2 < positionOfTheChild; ++i2) {
            Node nodeToPrint = (Node)everything.get(i2);
            if (!(nodeToPrint instanceof Comment)) {
                throw new RuntimeException("Expected comment, instead " + nodeToPrint.getClass() + ". Position of previous child: " + positionOfPreviousChild + ", position of child " + positionOfTheChild);
            }
            nodeToPrint.accept(this, null);
        }
    }

    private void printOrphanCommentsEnding(Node node) {
        if (this.configuration.isIgnoreComments()) {
            return;
        }
        LinkedList<Node> everything = new LinkedList<Node>();
        everything.addAll(node.getChildNodes());
        PositionUtils.sortByBeginPosition(everything);
        if (everything.isEmpty()) {
            return;
        }
        int commentsAtEnd = 0;
        boolean findingComments = true;
        while (findingComments && commentsAtEnd < everything.size()) {
            Node last = (Node)everything.get(everything.size() - 1 - commentsAtEnd);
            findingComments = last instanceof Comment;
            if (!findingComments) continue;
            ++commentsAtEnd;
        }
        for (int i2 = 0; i2 < commentsAtEnd; ++i2) {
            ((Node)everything.get(everything.size() - commentsAtEnd + i2)).accept(this, null);
        }
    }
}

