/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.utils;

import com.github.javaparser.Position;
import com.github.javaparser.Range;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import com.github.javaparser.ast.nodeTypes.NodeWithType;
import java.util.List;

public final class PositionUtils {
    private PositionUtils() {
    }

    public static <T extends Node> void sortByBeginPosition(List<T> nodes) {
        PositionUtils.sortByBeginPosition(nodes, false);
    }

    public static <T extends Node> void sortByBeginPosition(NodeList<T> nodes) {
        PositionUtils.sortByBeginPosition(nodes, false);
    }

    public static <T extends Node> void sortByBeginPosition(List<T> nodes, boolean ignoringAnnotations) {
        nodes.sort((o1, o2) -> PositionUtils.compare(o1, o2, ignoringAnnotations));
    }

    public static boolean areInOrder(Node a2, Node b2) {
        return PositionUtils.areInOrder(a2, b2, false);
    }

    public static boolean areInOrder(Node a2, Node b2, boolean ignoringAnnotations) {
        return PositionUtils.compare(a2, b2, ignoringAnnotations) <= 0;
    }

    private static int compare(Node a2, Node b2, boolean ignoringAnnotations) {
        if (a2.getRange().isPresent() && !b2.getRange().isPresent()) {
            return -1;
        }
        if (!a2.getRange().isPresent() && b2.getRange().isPresent()) {
            return 1;
        }
        if (!a2.getRange().isPresent() && !b2.getRange().isPresent()) {
            return 0;
        }
        if (ignoringAnnotations) {
            int signLine = Integer.signum(PositionUtils.beginLineWithoutConsideringAnnotation(a2) - PositionUtils.beginLineWithoutConsideringAnnotation(b2));
            if (signLine == 0) {
                return Integer.signum(PositionUtils.beginColumnWithoutConsideringAnnotation(a2) - PositionUtils.beginColumnWithoutConsideringAnnotation(b2));
            }
            return signLine;
        }
        Position aBegin = a2.getBegin().get();
        Position bBegin = b2.getBegin().get();
        int signLine = Integer.signum(aBegin.line - bBegin.line);
        if (signLine == 0) {
            return Integer.signum(aBegin.column - bBegin.column);
        }
        return signLine;
    }

    public static AnnotationExpr getLastAnnotation(Node node) {
        if (node instanceof NodeWithAnnotations) {
            NodeList<AnnotationExpr> annotations = NodeList.nodeList(((NodeWithAnnotations)((Object)node)).getAnnotations());
            if (annotations.isEmpty()) {
                return null;
            }
            PositionUtils.sortByBeginPosition(annotations);
            return (AnnotationExpr)annotations.get(annotations.size() - 1);
        }
        return null;
    }

    private static int beginLineWithoutConsideringAnnotation(Node node) {
        return PositionUtils.beginNodeWithoutConsideringAnnotations((Node)node).getRange().get().begin.line;
    }

    private static int beginColumnWithoutConsideringAnnotation(Node node) {
        return PositionUtils.beginNodeWithoutConsideringAnnotations((Node)node).getRange().get().begin.column;
    }

    private static Node beginNodeWithoutConsideringAnnotations(Node node) {
        if (node instanceof MethodDeclaration || node instanceof FieldDeclaration) {
            NodeWithType casted = (NodeWithType)((Object)node);
            return casted.getType();
        }
        if (node instanceof ClassOrInterfaceDeclaration) {
            ClassOrInterfaceDeclaration casted = (ClassOrInterfaceDeclaration)node;
            return casted.getName();
        }
        return node;
    }

    public static boolean nodeContains(Node container, Node contained, boolean ignoringAnnotations) {
        Range containedRange = contained.getRange().get();
        Range containerRange = container.getRange().get();
        if (!ignoringAnnotations || PositionUtils.getLastAnnotation(container) == null) {
            return container.containsWithin(contained);
        }
        if (!container.containsWithin(contained)) {
            return false;
        }
        if (container instanceof NodeWithAnnotations) {
            int bl = PositionUtils.beginLineWithoutConsideringAnnotation(container);
            int bc2 = PositionUtils.beginColumnWithoutConsideringAnnotation(container);
            if (bl > containedRange.begin.line) {
                return false;
            }
            if (bl == containedRange.begin.line && bc2 > containedRange.begin.column) {
                return false;
            }
            if (containerRange.end.line < containedRange.end.line) {
                return false;
            }
            return containerRange.end.line != containedRange.end.line || containerRange.end.column >= containedRange.end.column;
        }
        return true;
    }
}

