/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.annotations.GwtCompatible;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible
@CanIgnoreReturnValue
final class MathPreconditions {
    static int checkPositive(@Nullable String role, int x2) {
        if (x2 <= 0) {
            throw new IllegalArgumentException(role + " (" + x2 + ") must be > 0");
        }
        return x2;
    }

    static long checkPositive(@Nullable String role, long x2) {
        if (x2 <= 0L) {
            throw new IllegalArgumentException(role + " (" + x2 + ") must be > 0");
        }
        return x2;
    }

    static BigInteger checkPositive(@Nullable String role, BigInteger x2) {
        if (x2.signum() <= 0) {
            throw new IllegalArgumentException(role + " (" + x2 + ") must be > 0");
        }
        return x2;
    }

    static int checkNonNegative(@Nullable String role, int x2) {
        if (x2 < 0) {
            throw new IllegalArgumentException(role + " (" + x2 + ") must be >= 0");
        }
        return x2;
    }

    static long checkNonNegative(@Nullable String role, long x2) {
        if (x2 < 0L) {
            throw new IllegalArgumentException(role + " (" + x2 + ") must be >= 0");
        }
        return x2;
    }

    static BigInteger checkNonNegative(@Nullable String role, BigInteger x2) {
        if (x2.signum() < 0) {
            throw new IllegalArgumentException(role + " (" + x2 + ") must be >= 0");
        }
        return x2;
    }

    static double checkNonNegative(@Nullable String role, double x2) {
        if (!(x2 >= 0.0)) {
            throw new IllegalArgumentException(role + " (" + x2 + ") must be >= 0");
        }
        return x2;
    }

    static void checkRoundingUnnecessary(boolean condition) {
        if (!condition) {
            throw new ArithmeticException("mode was UNNECESSARY, but rounding was necessary");
        }
    }

    static void checkInRangeForRoundingInputs(boolean condition, double input, RoundingMode mode) {
        if (!condition) {
            throw new ArithmeticException("rounded value is out of range for input " + input + " and rounding mode " + (Object)((Object)mode));
        }
    }

    static void checkNoOverflow(boolean condition, String methodName, int a2, int b2) {
        if (!condition) {
            throw new ArithmeticException("overflow: " + methodName + "(" + a2 + ", " + b2 + ")");
        }
    }

    static void checkNoOverflow(boolean condition, String methodName, long a2, long b2) {
        if (!condition) {
            throw new ArithmeticException("overflow: " + methodName + "(" + a2 + ", " + b2 + ")");
        }
    }

    private MathPreconditions() {
    }
}

