/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.win;

import com.sun.glass.ui.GestureSupport;
import com.sun.glass.ui.TouchInputSupport;
import com.sun.glass.ui.View;

final class WinGestureSupport {
    private static final double multiplier = 1.0;
    private static final GestureSupport gestures;
    private static final TouchInputSupport touches;
    private static int modifiers;
    private static boolean isDirect;

    WinGestureSupport() {
    }

    private static native void _initIDs();

    public static void notifyBeginTouchEvent(View view, int n2, boolean bl, int n3) {
        touches.notifyBeginTouchEvent(view, n2, bl, n3);
    }

    public static void notifyNextTouchEvent(View view, int n2, long l2, int n3, int n4, int n5, int n6) {
        touches.notifyNextTouchEvent(view, n2, l2, n3, n4, n5, n6);
    }

    public static void notifyEndTouchEvent(View view) {
        touches.notifyEndTouchEvent(view);
        WinGestureSupport.gestureFinished(view, touches.getTouchCount(), false);
    }

    private static void gestureFinished(View view, int n2, boolean bl) {
        if (gestures.isScrolling() && n2 == 0) {
            gestures.handleScrollingEnd(view, modifiers, n2, isDirect, bl, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
        if (gestures.isRotating() && n2 < 2) {
            gestures.handleRotationEnd(view, modifiers, isDirect, bl, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
        if (gestures.isZooming() && n2 < 2) {
            gestures.handleZoomingEnd(view, modifiers, isDirect, bl, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
    }

    public static void inertiaGestureFinished(View view) {
        WinGestureSupport.gestureFinished(view, 0, true);
    }

    public static void gesturePerformed(View view, int n2, boolean bl, boolean bl2, int n3, int n4, int n5, int n6, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        modifiers = n2;
        isDirect = bl;
        int n7 = touches.getTouchCount();
        if (n7 >= 2) {
            gestures.handleTotalZooming(view, n2, bl, bl2, n3, n4, n5, n6, f6, f7);
            gestures.handleTotalRotation(view, n2, bl, bl2, n3, n4, n5, n6, Math.toDegrees(f8));
        }
        gestures.handleTotalScrolling(view, n2, bl, bl2, n7, n3, n4, n5, n6, f4, f5, 1.0, 1.0);
    }

    static {
        WinGestureSupport._initIDs();
        gestures = new GestureSupport(true);
        touches = new TouchInputSupport(gestures.createTouchCountListener(), true);
    }
}

