/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.image.impl;

import com.sun.javafx.image.AlphaType;
import com.sun.javafx.image.BytePixelAccessor;
import com.sun.javafx.image.BytePixelGetter;
import com.sun.javafx.image.BytePixelSetter;
import com.sun.javafx.image.ByteToBytePixelConverter;
import com.sun.javafx.image.ByteToIntPixelConverter;
import com.sun.javafx.image.PixelUtils;
import com.sun.javafx.image.impl.BaseByteToByteConverter;
import com.sun.javafx.image.impl.BaseByteToIntConverter;
import com.sun.javafx.image.impl.ByteBgra;
import com.sun.javafx.image.impl.IntArgb;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public class ByteBgraPre {
    public static final BytePixelGetter getter = Accessor.instance;
    public static final BytePixelSetter setter = Accessor.instance;
    public static final BytePixelAccessor accessor = Accessor.instance;
    private static ByteToBytePixelConverter ToByteBgraPreObj;

    public static ByteToBytePixelConverter ToByteBgraConverter() {
        return ToByteBgraConv.instance;
    }

    public static ByteToBytePixelConverter ToByteBgraPreConverter() {
        if (ToByteBgraPreObj == null) {
            ToByteBgraPreObj = BaseByteToByteConverter.create(accessor);
        }
        return ToByteBgraPreObj;
    }

    public static ByteToIntPixelConverter ToIntArgbConverter() {
        return ToIntArgbConv.instance;
    }

    public static ByteToIntPixelConverter ToIntArgbPreConverter() {
        return ByteBgra.ToIntArgbSameConv.premul;
    }

    public static class ToIntArgbConv
    extends BaseByteToIntConverter {
        public static final ByteToIntPixelConverter instance = new ToIntArgbConv();

        private ToIntArgbConv() {
            super(getter, IntArgb.setter);
        }

        @Override
        void doConvert(byte[] byArray, int n2, int n3, int[] nArray, int n4, int n5, int n6, int n7) {
            n3 -= n6 * 4;
            n5 -= n6;
            while (--n7 >= 0) {
                for (int i2 = 0; i2 < n6; ++i2) {
                    int n8;
                    int n9 = byArray[n2++] & 0xFF;
                    int n10 = byArray[n2++] & 0xFF;
                    int n11 = byArray[n2++] & 0xFF;
                    if ((n8 = byArray[n2++] & 0xFF) > 0 && n8 < 255) {
                        int n12 = n8 >> 1;
                        n11 = (n11 * 255 + n12) / n8;
                        n10 = (n10 * 255 + n12) / n8;
                        n9 = (n9 * 255 + n12) / n8;
                    }
                    nArray[n4++] = n8 << 24 | n11 << 16 | n10 << 8 | n9;
                }
                n4 += n5;
                n2 += n3;
            }
        }

        @Override
        void doConvert(ByteBuffer byteBuffer, int n2, int n3, IntBuffer intBuffer, int n4, int n5, int n6, int n7) {
            n3 -= n6 * 4;
            while (--n7 >= 0) {
                for (int i2 = 0; i2 < n6; ++i2) {
                    int n8 = byteBuffer.get(n2) & 0xFF;
                    int n9 = byteBuffer.get(n2 + 1) & 0xFF;
                    int n10 = byteBuffer.get(n2 + 2) & 0xFF;
                    int n11 = byteBuffer.get(n2 + 3) & 0xFF;
                    n2 += 4;
                    if (n11 > 0 && n11 < 255) {
                        int n12 = n11 >> 1;
                        n10 = (n10 * 255 + n12) / n11;
                        n9 = (n9 * 255 + n12) / n11;
                        n8 = (n8 * 255 + n12) / n11;
                    }
                    intBuffer.put(n4 + i2, n11 << 24 | n10 << 16 | n9 << 8 | n8);
                }
                n4 += n5;
                n2 += n3;
            }
        }
    }

    public static class ToByteBgraConv
    extends BaseByteToByteConverter {
        public static final ByteToBytePixelConverter instance = new ToByteBgraConv();

        private ToByteBgraConv() {
            super(getter, ByteBgra.setter);
        }

        @Override
        void doConvert(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5, int n6, int n7) {
            n3 -= n6 * 4;
            n5 -= n6 * 4;
            while (--n7 >= 0) {
                for (int i2 = 0; i2 < n6; ++i2) {
                    int n8;
                    byte by = byArray[n2++];
                    byte by2 = byArray[n2++];
                    byte by3 = byArray[n2++];
                    if ((n8 = byArray[n2++] & 0xFF) > 0 && n8 < 255) {
                        int n9 = n8 >> 1;
                        by = (byte)(((by & 0xFF) * 255 + n9) / n8);
                        by2 = (byte)(((by2 & 0xFF) * 255 + n9) / n8);
                        by3 = (byte)(((by3 & 0xFF) * 255 + n9) / n8);
                    }
                    byArray2[n4++] = by;
                    byArray2[n4++] = by2;
                    byArray2[n4++] = by3;
                    byArray2[n4++] = (byte)n8;
                }
                n2 += n3;
                n4 += n5;
            }
        }

        @Override
        void doConvert(ByteBuffer byteBuffer, int n2, int n3, ByteBuffer byteBuffer2, int n4, int n5, int n6, int n7) {
            n3 -= n6 * 4;
            n5 -= n6 * 4;
            while (--n7 >= 0) {
                for (int i2 = 0; i2 < n6; ++i2) {
                    byte by = byteBuffer.get(n2);
                    byte by2 = byteBuffer.get(n2 + 1);
                    byte by3 = byteBuffer.get(n2 + 2);
                    int n8 = byteBuffer.get(n2 + 3) & 0xFF;
                    n2 += 4;
                    if (n8 > 0 && n8 < 255) {
                        int n9 = n8 >> 1;
                        by = (byte)(((by & 0xFF) * 255 + n9) / n8);
                        by2 = (byte)(((by2 & 0xFF) * 255 + n9) / n8);
                        by3 = (byte)(((by3 & 0xFF) * 255 + n9) / n8);
                    }
                    byteBuffer2.put(n4, by);
                    byteBuffer2.put(n4 + 1, by2);
                    byteBuffer2.put(n4 + 2, by3);
                    byteBuffer2.put(n4 + 3, (byte)n8);
                    n4 += 4;
                }
                n2 += n3;
                n4 += n5;
            }
        }
    }

    static class Accessor
    implements BytePixelAccessor {
        static final BytePixelAccessor instance = new Accessor();

        private Accessor() {
        }

        @Override
        public AlphaType getAlphaType() {
            return AlphaType.PREMULTIPLIED;
        }

        @Override
        public int getNumElements() {
            return 4;
        }

        @Override
        public int getArgb(byte[] byArray, int n2) {
            return PixelUtils.PretoNonPre(this.getArgbPre(byArray, n2));
        }

        @Override
        public int getArgbPre(byte[] byArray, int n2) {
            return byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) << 16 | byArray[n2 + 3] << 24;
        }

        @Override
        public int getArgb(ByteBuffer byteBuffer, int n2) {
            return PixelUtils.PretoNonPre(this.getArgbPre(byteBuffer, n2));
        }

        @Override
        public int getArgbPre(ByteBuffer byteBuffer, int n2) {
            return byteBuffer.get(n2) & 0xFF | (byteBuffer.get(n2 + 1) & 0xFF) << 8 | (byteBuffer.get(n2 + 2) & 0xFF) << 16 | byteBuffer.get(n2 + 3) << 24;
        }

        @Override
        public void setArgb(byte[] byArray, int n2, int n3) {
            this.setArgbPre(byArray, n2, PixelUtils.NonPretoPre(n3));
        }

        @Override
        public void setArgbPre(byte[] byArray, int n2, int n3) {
            byArray[n2] = (byte)n3;
            byArray[n2 + 1] = (byte)(n3 >> 8);
            byArray[n2 + 2] = (byte)(n3 >> 16);
            byArray[n2 + 3] = (byte)(n3 >> 24);
        }

        @Override
        public void setArgb(ByteBuffer byteBuffer, int n2, int n3) {
            this.setArgbPre(byteBuffer, n2, PixelUtils.NonPretoPre(n3));
        }

        @Override
        public void setArgbPre(ByteBuffer byteBuffer, int n2, int n3) {
            byteBuffer.put(n2, (byte)n3);
            byteBuffer.put(n2 + 1, (byte)(n3 >> 8));
            byteBuffer.put(n2 + 2, (byte)(n3 >> 16));
            byteBuffer.put(n2 + 3, (byte)(n3 >> 24));
        }
    }
}

