/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit.theme;

import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.webkit.Accessor;
import com.sun.javafx.webkit.theme.RenderThemeImpl;
import com.sun.javafx.webkit.theme.Renderer;
import com.sun.javafx.webkit.theme.ScrollBarWidget;
import com.sun.webkit.graphics.Ref;
import com.sun.webkit.graphics.ScrollBarTheme;
import com.sun.webkit.graphics.WCGraphicsContext;
import com.sun.webkit.graphics.WCSize;
import java.lang.ref.WeakReference;
import javafx.beans.Observable;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollBar;

public final class ScrollBarThemeImpl
extends ScrollBarTheme {
    private static final PlatformLogger log = PlatformLogger.getLogger(ScrollBarThemeImpl.class.getName());
    private WeakReference<ScrollBar> testSBRef = new WeakReference<Object>(null);
    private final Accessor accessor;
    private final RenderThemeImpl.Pool<ScrollBarWidget> pool;

    public ScrollBarThemeImpl(final Accessor accessor) {
        this.accessor = accessor;
        this.pool = new RenderThemeImpl.Pool<ScrollBarWidget>(scrollBarWidget -> accessor.removeChild((Node)scrollBarWidget), ScrollBarWidget.class);
        accessor.addViewListener(new RenderThemeImpl.ViewListener(this.pool, accessor){

            @Override
            public void invalidated(Observable observable) {
                super.invalidated(observable);
                ScrollBarWidget scrollBarWidget = new ScrollBarWidget(ScrollBarThemeImpl.this);
                accessor.addChild(scrollBarWidget);
                ScrollBarThemeImpl.this.testSBRef = new WeakReference<ScrollBarWidget>(scrollBarWidget);
            }
        });
    }

    ScrollBar getTestSBRef() {
        return (ScrollBar)this.testSBRef.get();
    }

    private static Orientation convertOrientation(int n2) {
        return n2 == 1 ? Orientation.VERTICAL : Orientation.HORIZONTAL;
    }

    private void adjustScrollBar(ScrollBar scrollBar, int n2, int n3, int n4) {
        Orientation orientation = ScrollBarThemeImpl.convertOrientation(n4);
        if (orientation != scrollBar.getOrientation()) {
            scrollBar.setOrientation(orientation);
        }
        if (orientation == Orientation.VERTICAL) {
            n2 = ScrollBarTheme.getThickness();
        } else {
            n3 = ScrollBarTheme.getThickness();
        }
        if ((double)n2 != scrollBar.getWidth() || (double)n3 != scrollBar.getHeight()) {
            scrollBar.resize(n2, n3);
        }
    }

    private void adjustScrollBar(ScrollBar scrollBar, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.adjustScrollBar(scrollBar, n2, n3, n4);
        boolean bl = n7 <= n6;
        scrollBar.setDisable(bl);
        if (bl) {
            return;
        }
        if (n5 < 0) {
            n5 = 0;
        } else if (n5 > n7 - n6) {
            n5 = n7 - n6;
        }
        if (scrollBar.getMax() != (double)n7 || scrollBar.getVisibleAmount() != (double)n6) {
            scrollBar.setValue(0.0);
            scrollBar.setMax(n7);
            scrollBar.setVisibleAmount(n6);
        }
        if (n7 > n6) {
            float f2 = (float)n7 / (float)(n7 - n6);
            if (scrollBar.getValue() != (double)((float)n5 * f2)) {
                scrollBar.setValue((float)n5 * f2);
            }
        }
    }

    @Override
    protected Ref createWidget(long l2, int n2, int n3, int n4, int n5, int n6, int n7) {
        ScrollBarWidget scrollBarWidget = this.pool.get(l2);
        if (scrollBarWidget == null) {
            scrollBarWidget = new ScrollBarWidget(this);
            this.pool.put(l2, scrollBarWidget, this.accessor.getPage().getUpdateContentCycleID());
            this.accessor.addChild(scrollBarWidget);
        }
        this.adjustScrollBar(scrollBarWidget, n2, n3, n4, n5, n6, n7);
        return new ScrollBarRef(scrollBarWidget);
    }

    @Override
    public void paint(WCGraphicsContext wCGraphicsContext, Ref ref, int n2, int n3, int n4, int n5) {
        ScrollBar scrollBar = (ScrollBar)((ScrollBarRef)ref).asControl();
        if (scrollBar == null) {
            return;
        }
        if (log.isLoggable(PlatformLogger.Level.FINEST)) {
            log.finest("[{0}, {1} {2}x{3}], {4}", n2, n3, scrollBar.getWidth(), scrollBar.getHeight(), scrollBar.getOrientation() == Orientation.VERTICAL ? "VERTICAL" : "HORIZONTAL");
        }
        wCGraphicsContext.saveState();
        wCGraphicsContext.translate(n2, n3);
        Renderer.getRenderer().render(scrollBar, wCGraphicsContext);
        wCGraphicsContext.restoreState();
    }

    @Override
    public WCSize getWidgetSize(Ref ref) {
        ScrollBar scrollBar = (ScrollBar)((ScrollBarRef)ref).asControl();
        if (scrollBar != null) {
            return new WCSize((float)scrollBar.getWidth(), (float)scrollBar.getHeight());
        }
        return new WCSize(0.0f, 0.0f);
    }

    @Override
    protected void getScrollBarPartRect(long l2, int n2, int[] nArray) {
        ScrollBar scrollBar = this.pool.get(l2);
        if (scrollBar == null) {
            return;
        }
        Node node = null;
        if (n2 == 2) {
            node = ScrollBarThemeImpl.getIncButton(scrollBar);
        } else if (n2 == 1) {
            node = ScrollBarThemeImpl.getDecButton(scrollBar);
        } else if (n2 == 256) {
            node = ScrollBarThemeImpl.getTrack(scrollBar);
        }
        assert (nArray.length >= 4);
        if (node != null) {
            Bounds bounds = node.getBoundsInParent();
            nArray[0] = (int)bounds.getMinX();
            nArray[1] = (int)bounds.getMinY();
            nArray[2] = (int)bounds.getWidth();
            nArray[3] = (int)bounds.getHeight();
        } else {
            nArray[3] = 0;
            nArray[2] = 0;
            nArray[1] = 0;
            nArray[0] = 0;
        }
        log.finest("id {0} part {1} bounds {2},{3} {4}x{5}", String.valueOf(l2), String.valueOf(n2), nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    private static Node getTrack(ScrollBar scrollBar) {
        return ScrollBarThemeImpl.findNode(scrollBar, "track");
    }

    private static Node getIncButton(ScrollBar scrollBar) {
        return ScrollBarThemeImpl.findNode(scrollBar, "increment-button");
    }

    private static Node getDecButton(ScrollBar scrollBar) {
        return ScrollBarThemeImpl.findNode(scrollBar, "decrement-button");
    }

    private static Node findNode(ScrollBar scrollBar, String string) {
        for (Node node : scrollBar.getChildrenUnmodifiable()) {
            if (!node.getStyleClass().contains(string)) continue;
            return node;
        }
        return null;
    }

    private static final class ScrollBarRef
    extends Ref {
        private final WeakReference<ScrollBarWidget> sbRef;

        private ScrollBarRef(ScrollBarWidget scrollBarWidget) {
            this.sbRef = new WeakReference<ScrollBarWidget>(scrollBarWidget);
        }

        private Control asControl() {
            return (Control)this.sbRef.get();
        }
    }
}

