/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.javafx.geom.PathConsumer2D;
import com.sun.marlin.ByteArrayCache;
import com.sun.marlin.Curve;
import com.sun.marlin.FloatArrayCache;
import com.sun.marlin.IntArrayCache;
import com.sun.marlin.MarlinConst;
import com.sun.marlin.RendererContext;
import com.sun.marlin.stats.Histogram;
import com.sun.marlin.stats.StatLong;
import java.util.Arrays;

final class Helpers
implements MarlinConst {
    private Helpers() {
        throw new Error("This is a non instantiable class");
    }

    static boolean within(float f2, float f3, float f4) {
        float f5 = f3 - f2;
        return f5 <= f4 && f5 >= -f4;
    }

    static boolean within(double d2, double d3, double d4) {
        double d5 = d3 - d2;
        return d5 <= d4 && d5 >= -d4;
    }

    static float evalCubic(float f2, float f3, float f4, float f5, float f6) {
        return f6 * (f6 * (f6 * f2 + f3) + f4) + f5;
    }

    static float evalQuad(float f2, float f3, float f4, float f5) {
        return f5 * (f5 * f2 + f3) + f4;
    }

    static int quadraticRoots(float f2, float f3, float f4, float[] fArray, int n2) {
        int n3 = n2;
        if (f2 != 0.0f) {
            float f5 = f3 * f3 - 4.0f * f2 * f4;
            if (f5 > 0.0f) {
                float f6 = (float)Math.sqrt(f5);
                if (f3 >= 0.0f) {
                    fArray[n3++] = 2.0f * f4 / (-f3 - f6);
                    fArray[n3++] = (-f3 - f6) / (2.0f * f2);
                } else {
                    fArray[n3++] = (-f3 + f6) / (2.0f * f2);
                    fArray[n3++] = 2.0f * f4 / (-f3 + f6);
                }
            } else if (f5 == 0.0f) {
                fArray[n3++] = -f3 / (2.0f * f2);
            }
        } else if (f3 != 0.0f) {
            fArray[n3++] = -f4 / f3;
        }
        return n3 - n2;
    }

    static int cubicRootsInAB(float f2, float f3, float f4, float f5, float[] fArray, int n2, float f6, float f7) {
        int n3;
        if (f2 == 0.0f) {
            int n4 = Helpers.quadraticRoots(f3, f4, f5, fArray, n2);
            return Helpers.filterOutNotInAB(fArray, n2, n4, f6, f7) - n2;
        }
        double d2 = (double)f3 / (double)f2;
        double d3 = d2 * d2;
        double d4 = 0.3333333333333333 * d2;
        double d5 = (double)f4 / (double)f2;
        double d6 = (double)f5 / (double)f2;
        double d7 = 0.5 * (0.07407407407407407 * d2 * d3 - d4 * d5 + d6);
        double d8 = 0.3333333333333333 * (-0.3333333333333333 * d3 + d5);
        double d9 = d8 * d8 * d8;
        double d10 = d7 * d7 + d9;
        if (d10 < 0.0) {
            double d11 = 0.3333333333333333 * Math.acos(-d7 / Math.sqrt(-d9));
            double d12 = 2.0 * Math.sqrt(-d8);
            fArray[n2] = (float)(d12 * Math.cos(d11) - d4);
            fArray[n2 + 1] = (float)(-d12 * Math.cos(d11 + 1.0471975511965976) - d4);
            fArray[n2 + 2] = (float)(-d12 * Math.cos(d11 - 1.0471975511965976) - d4);
            n3 = 3;
        } else {
            double d13 = Math.sqrt(d10);
            double d14 = Math.cbrt(d13 - d7);
            double d15 = -Math.cbrt(d13 + d7);
            fArray[n2] = (float)(d14 + d15 - d4);
            n3 = 1;
            if (Helpers.within(d10, 0.0, 1.0E-8)) {
                fArray[n2 + 1] = (float)(-0.5 * (d14 + d15) - d4);
                n3 = 2;
            }
        }
        return Helpers.filterOutNotInAB(fArray, n2, n3, f6, f7) - n2;
    }

    static int filterOutNotInAB(float[] fArray, int n2, int n3, float f2, float f3) {
        int n4 = n2;
        int n5 = n2 + n3;
        for (int i2 = n2; i2 < n5; ++i2) {
            if (!(fArray[i2] >= f2) || !(fArray[i2] < f3)) continue;
            fArray[n4++] = fArray[i2];
        }
        return n4;
    }

    static float fastLineLen(float f2, float f3, float f4, float f5) {
        float f6 = f4 - f2;
        float f7 = f5 - f3;
        return Math.abs(f6) + Math.abs(f7);
    }

    static float linelen(float f2, float f3, float f4, float f5) {
        float f6 = f4 - f2;
        float f7 = f5 - f3;
        return (float)Math.sqrt(f6 * f6 + f7 * f7);
    }

    static float fastQuadLen(float f2, float f3, float f4, float f5, float f6, float f7) {
        float f8 = f4 - f2;
        float f9 = f6 - f4;
        float f10 = f5 - f3;
        float f11 = f7 - f5;
        return Math.abs(f8) + Math.abs(f9) + Math.abs(f10) + Math.abs(f11);
    }

    static float quadlen(float f2, float f3, float f4, float f5, float f6, float f7) {
        return (Helpers.linelen(f2, f3, f4, f5) + Helpers.linelen(f4, f5, f6, f7) + Helpers.linelen(f2, f3, f6, f7)) / 2.0f;
    }

    static float fastCurvelen(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        float f10 = f4 - f2;
        float f11 = f6 - f4;
        float f12 = f8 - f6;
        float f13 = f5 - f3;
        float f14 = f7 - f5;
        float f15 = f9 - f7;
        return Math.abs(f10) + Math.abs(f11) + Math.abs(f12) + Math.abs(f13) + Math.abs(f14) + Math.abs(f15);
    }

    static float curvelen(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        return (Helpers.linelen(f2, f3, f4, f5) + Helpers.linelen(f4, f5, f6, f7) + Helpers.linelen(f6, f7, f8, f9) + Helpers.linelen(f2, f3, f8, f9)) / 2.0f;
    }

    static int findSubdivPoints(Curve curve, float[] fArray, float[] fArray2, int n2, float f2) {
        float f3 = fArray[2] - fArray[0];
        float f4 = fArray[3] - fArray[1];
        if (f4 != 0.0f && f3 != 0.0f) {
            float f5 = (float)Math.sqrt(f3 * f3 + f4 * f4);
            float f6 = f3 / f5;
            float f7 = f4 / f5;
            float f8 = f6 * fArray[0] + f7 * fArray[1];
            float f9 = f6 * fArray[1] - f7 * fArray[0];
            float f10 = f6 * fArray[2] + f7 * fArray[3];
            float f11 = f6 * fArray[3] - f7 * fArray[2];
            float f12 = f6 * fArray[4] + f7 * fArray[5];
            float f13 = f6 * fArray[5] - f7 * fArray[4];
            switch (n2) {
                case 8: {
                    float f14 = f6 * fArray[6] + f7 * fArray[7];
                    float f15 = f6 * fArray[7] - f7 * fArray[6];
                    curve.set(f8, f9, f10, f11, f12, f13, f14, f15);
                    break;
                }
                case 6: {
                    curve.set(f8, f9, f10, f11, f12, f13);
                    break;
                }
            }
        } else {
            curve.set(fArray, n2);
        }
        int n3 = 0;
        n3 += curve.dxRoots(fArray2, n3);
        n3 += curve.dyRoots(fArray2, n3);
        if (n2 == 8) {
            n3 += curve.infPoints(fArray2, n3);
        }
        n3 += curve.rootsOfROCMinusW(fArray2, n3, f2, 1.0E-4f);
        n3 = Helpers.filterOutNotInAB(fArray2, 0, n3, 1.0E-4f, 0.9999f);
        Helpers.isort(fArray2, n3);
        return n3;
    }

    static int findClipPoints(Curve curve, float[] fArray, float[] fArray2, int n2, int n3, float[] fArray3) {
        curve.set(fArray, n2);
        int n4 = 0;
        if ((n3 & 4) != 0) {
            n4 += curve.xPoints(fArray2, n4, fArray3[2]);
        }
        if ((n3 & 8) != 0) {
            n4 += curve.xPoints(fArray2, n4, fArray3[3]);
        }
        if ((n3 & 1) != 0) {
            n4 += curve.yPoints(fArray2, n4, fArray3[0]);
        }
        if ((n3 & 2) != 0) {
            n4 += curve.yPoints(fArray2, n4, fArray3[1]);
        }
        Helpers.isort(fArray2, n4);
        return n4;
    }

    static void subdivide(float[] fArray, float[] fArray2, float[] fArray3, int n2) {
        switch (n2) {
            case 8: {
                Helpers.subdivideCubic(fArray, fArray2, fArray3);
                return;
            }
            case 6: {
                Helpers.subdivideQuad(fArray, fArray2, fArray3);
                return;
            }
        }
        throw new InternalError("Unsupported curve type");
    }

    static void isort(float[] fArray, int n2) {
        for (int i2 = 1; i2 < n2; ++i2) {
            float f2 = fArray[i2];
            for (int i3 = i2 - 1; i3 >= 0 && fArray[i3] > f2; --i3) {
                fArray[i3 + 1] = fArray[i3];
            }
            fArray[i3 + 1] = f2;
        }
    }

    static void subdivideCubic(float[] fArray, float[] fArray2, float[] fArray3) {
        float f2 = fArray[0];
        float f3 = fArray[1];
        float f4 = fArray[2];
        float f5 = fArray[3];
        float f6 = fArray[4];
        float f7 = fArray[5];
        float f8 = fArray[6];
        float f9 = fArray[7];
        fArray2[0] = f2;
        fArray2[1] = f3;
        fArray3[6] = f8;
        fArray3[7] = f9;
        f2 = (f2 + f4) / 2.0f;
        f3 = (f3 + f5) / 2.0f;
        f8 = (f8 + f6) / 2.0f;
        f9 = (f9 + f7) / 2.0f;
        float f10 = (f4 + f6) / 2.0f;
        float f11 = (f5 + f7) / 2.0f;
        f4 = (f2 + f10) / 2.0f;
        f5 = (f3 + f11) / 2.0f;
        f6 = (f8 + f10) / 2.0f;
        f7 = (f9 + f11) / 2.0f;
        f10 = (f4 + f6) / 2.0f;
        f11 = (f5 + f7) / 2.0f;
        fArray2[2] = f2;
        fArray2[3] = f3;
        fArray2[4] = f4;
        fArray2[5] = f5;
        fArray2[6] = f10;
        fArray2[7] = f11;
        fArray3[0] = f10;
        fArray3[1] = f11;
        fArray3[2] = f6;
        fArray3[3] = f7;
        fArray3[4] = f8;
        fArray3[5] = f9;
    }

    static void subdivideCubicAt(float f2, float[] fArray, int n2, float[] fArray2, int n3, int n4) {
        float f3 = fArray[n2];
        float f4 = fArray[n2 + 1];
        float f5 = fArray[n2 + 2];
        float f6 = fArray[n2 + 3];
        float f7 = fArray[n2 + 4];
        float f8 = fArray[n2 + 5];
        float f9 = fArray[n2 + 6];
        float f10 = fArray[n2 + 7];
        fArray2[n3] = f3;
        fArray2[n3 + 1] = f4;
        fArray2[n4 + 6] = f9;
        fArray2[n4 + 7] = f10;
        f3 += f2 * (f5 - f3);
        f4 += f2 * (f6 - f4);
        f9 = f7 + f2 * (f9 - f7);
        f10 = f8 + f2 * (f10 - f8);
        float f11 = f5 + f2 * (f7 - f5);
        float f12 = f6 + f2 * (f8 - f6);
        f5 = f3 + f2 * (f11 - f3);
        f6 = f4 + f2 * (f12 - f4);
        f7 = f11 + f2 * (f9 - f11);
        f8 = f12 + f2 * (f10 - f12);
        f11 = f5 + f2 * (f7 - f5);
        f12 = f6 + f2 * (f8 - f6);
        fArray2[n3 + 2] = f3;
        fArray2[n3 + 3] = f4;
        fArray2[n3 + 4] = f5;
        fArray2[n3 + 5] = f6;
        fArray2[n3 + 6] = f11;
        fArray2[n3 + 7] = f12;
        fArray2[n4] = f11;
        fArray2[n4 + 1] = f12;
        fArray2[n4 + 2] = f7;
        fArray2[n4 + 3] = f8;
        fArray2[n4 + 4] = f9;
        fArray2[n4 + 5] = f10;
    }

    static void subdivideQuad(float[] fArray, float[] fArray2, float[] fArray3) {
        float f2 = fArray[0];
        float f3 = fArray[1];
        float f4 = fArray[2];
        float f5 = fArray[3];
        float f6 = fArray[4];
        float f7 = fArray[5];
        fArray2[0] = f2;
        fArray2[1] = f3;
        fArray3[4] = f6;
        fArray3[5] = f7;
        f2 = (f2 + f4) / 2.0f;
        f3 = (f3 + f5) / 2.0f;
        f6 = (f6 + f4) / 2.0f;
        f7 = (f7 + f5) / 2.0f;
        f4 = (f2 + f6) / 2.0f;
        f5 = (f3 + f7) / 2.0f;
        fArray2[2] = f2;
        fArray2[3] = f3;
        fArray2[4] = f4;
        fArray2[5] = f5;
        fArray3[0] = f4;
        fArray3[1] = f5;
        fArray3[2] = f6;
        fArray3[3] = f7;
    }

    static void subdivideQuadAt(float f2, float[] fArray, int n2, float[] fArray2, int n3, int n4) {
        float f3 = fArray[n2];
        float f4 = fArray[n2 + 1];
        float f5 = fArray[n2 + 2];
        float f6 = fArray[n2 + 3];
        float f7 = fArray[n2 + 4];
        float f8 = fArray[n2 + 5];
        fArray2[n3] = f3;
        fArray2[n3 + 1] = f4;
        fArray2[n4 + 4] = f7;
        fArray2[n4 + 5] = f8;
        f3 += f2 * (f5 - f3);
        f4 += f2 * (f6 - f4);
        f7 = f5 + f2 * (f7 - f5);
        f8 = f6 + f2 * (f8 - f6);
        f5 = f3 + f2 * (f7 - f3);
        f6 = f4 + f2 * (f8 - f4);
        fArray2[n3 + 2] = f3;
        fArray2[n3 + 3] = f4;
        fArray2[n3 + 4] = f5;
        fArray2[n3 + 5] = f6;
        fArray2[n4] = f5;
        fArray2[n4 + 1] = f6;
        fArray2[n4 + 2] = f7;
        fArray2[n4 + 3] = f8;
    }

    static void subdivideLineAt(float f2, float[] fArray, int n2, float[] fArray2, int n3, int n4) {
        float f3 = fArray[n2];
        float f4 = fArray[n2 + 1];
        float f5 = fArray[n2 + 2];
        float f6 = fArray[n2 + 3];
        fArray2[n3] = f3;
        fArray2[n3 + 1] = f4;
        fArray2[n4 + 2] = f5;
        fArray2[n4 + 3] = f6;
        f3 += f2 * (f5 - f3);
        f4 += f2 * (f6 - f4);
        fArray2[n3 + 2] = f3;
        fArray2[n3 + 3] = f4;
        fArray2[n4] = f3;
        fArray2[n4 + 1] = f4;
    }

    static void subdivideAt(float f2, float[] fArray, int n2, float[] fArray2, int n3, int n4) {
        if (n4 == 8) {
            Helpers.subdivideCubicAt(f2, fArray, n2, fArray2, n3, n3 + n4);
        } else if (n4 == 4) {
            Helpers.subdivideLineAt(f2, fArray, n2, fArray2, n3, n3 + n4);
        } else {
            Helpers.subdivideQuadAt(f2, fArray, n2, fArray2, n3, n3 + n4);
        }
    }

    static int outcode(float f2, float f3, float[] fArray) {
        int n2 = f3 < fArray[0] ? 1 : (f3 >= fArray[1] ? 2 : 0);
        if (f2 < fArray[2]) {
            n2 |= 4;
        } else if (f2 >= fArray[3]) {
            n2 |= 8;
        }
        return n2;
    }

    static final class IndexStack {
        private static final int INITIAL_COUNT = MarlinConst.INITIAL_EDGES_COUNT >> 2;
        private int end;
        private int[] indices;
        private final IntArrayCache.Reference indices_ref;
        private int indicesUseMark;
        private final StatLong stat_idxstack_indices;
        private final Histogram hist_idxstack_indices;
        private final StatLong stat_array_idxstack_indices;

        IndexStack(RendererContext rendererContext) {
            this(rendererContext, null, null, null);
        }

        IndexStack(RendererContext rendererContext, StatLong statLong, Histogram histogram, StatLong statLong2) {
            this.indices_ref = rendererContext.newDirtyIntArrayRef(INITIAL_COUNT);
            this.indices = this.indices_ref.initial;
            this.end = 0;
            if (MarlinConst.DO_STATS) {
                this.indicesUseMark = 0;
            }
            this.stat_idxstack_indices = statLong;
            this.hist_idxstack_indices = histogram;
            this.stat_array_idxstack_indices = statLong2;
        }

        void dispose() {
            this.end = 0;
            if (MarlinConst.DO_STATS) {
                this.stat_idxstack_indices.add(this.indicesUseMark);
                this.hist_idxstack_indices.add(this.indicesUseMark);
                this.indicesUseMark = 0;
            }
            this.indices = this.indices_ref.putArray(this.indices);
        }

        boolean isEmpty() {
            return this.end == 0;
        }

        void reset() {
            this.end = 0;
        }

        void push(int n2) {
            int n3;
            int[] nArray = this.indices;
            if ((n3 = this.end--) != 0 && nArray[n3 - 1] == n2) {
                return;
            }
            if (nArray.length <= n3) {
                if (MarlinConst.DO_STATS) {
                    this.stat_array_idxstack_indices.add(n3 + 1);
                }
                this.indices = nArray = this.indices_ref.widenArray(nArray, n3, n3 + 1);
            }
            nArray[this.end++] = n2;
            if (MarlinConst.DO_STATS && this.end > this.indicesUseMark) {
                this.indicesUseMark = this.end;
            }
        }

        void pullAll(float[] fArray, PathConsumer2D pathConsumer2D) {
            int n2 = this.end;
            if (n2 == 0) {
                return;
            }
            int[] nArray = this.indices;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = nArray[i2] << 1;
                pathConsumer2D.lineTo(fArray[n3], fArray[n3 + 1]);
            }
            this.end = 0;
        }
    }

    static final class PolyStack {
        private static final byte TYPE_LINETO = 0;
        private static final byte TYPE_QUADTO = 1;
        private static final byte TYPE_CUBICTO = 2;
        private static final int INITIAL_CURVES_COUNT = MarlinConst.INITIAL_EDGES_COUNT << 1;
        private static final int INITIAL_TYPES_COUNT = MarlinConst.INITIAL_EDGES_COUNT;
        float[] curves;
        int end;
        byte[] curveTypes;
        int numCurves;
        final FloatArrayCache.Reference curves_ref;
        final ByteArrayCache.Reference curveTypes_ref;
        int curveTypesUseMark;
        int curvesUseMark;
        private final StatLong stat_polystack_types;
        private final StatLong stat_polystack_curves;
        private final Histogram hist_polystack_curves;
        private final StatLong stat_array_polystack_curves;
        private final StatLong stat_array_polystack_curveTypes;

        PolyStack(RendererContext rendererContext) {
            this(rendererContext, null, null, null, null, null);
        }

        PolyStack(RendererContext rendererContext, StatLong statLong, StatLong statLong2, Histogram histogram, StatLong statLong3, StatLong statLong4) {
            this.curves_ref = rendererContext.newDirtyFloatArrayRef(INITIAL_CURVES_COUNT);
            this.curves = this.curves_ref.initial;
            this.curveTypes_ref = rendererContext.newDirtyByteArrayRef(INITIAL_TYPES_COUNT);
            this.curveTypes = this.curveTypes_ref.initial;
            this.numCurves = 0;
            this.end = 0;
            if (MarlinConst.DO_STATS) {
                this.curveTypesUseMark = 0;
                this.curvesUseMark = 0;
            }
            this.stat_polystack_types = statLong;
            this.stat_polystack_curves = statLong2;
            this.hist_polystack_curves = histogram;
            this.stat_array_polystack_curves = statLong3;
            this.stat_array_polystack_curveTypes = statLong4;
        }

        void dispose() {
            this.end = 0;
            this.numCurves = 0;
            if (MarlinConst.DO_STATS) {
                this.stat_polystack_types.add(this.curveTypesUseMark);
                this.stat_polystack_curves.add(this.curvesUseMark);
                this.hist_polystack_curves.add(this.curvesUseMark);
                this.curveTypesUseMark = 0;
                this.curvesUseMark = 0;
            }
            this.curves = this.curves_ref.putArray(this.curves);
            this.curveTypes = this.curveTypes_ref.putArray(this.curveTypes);
        }

        private void ensureSpace(int n2) {
            if (this.curves.length - this.end < n2) {
                if (MarlinConst.DO_STATS) {
                    this.stat_array_polystack_curves.add(this.end + n2);
                }
                this.curves = this.curves_ref.widenArray(this.curves, this.end, this.end + n2);
            }
            if (this.curveTypes.length <= this.numCurves) {
                if (MarlinConst.DO_STATS) {
                    this.stat_array_polystack_curveTypes.add(this.numCurves + 1);
                }
                this.curveTypes = this.curveTypes_ref.widenArray(this.curveTypes, this.numCurves, this.numCurves + 1);
            }
        }

        void pushCubic(float f2, float f3, float f4, float f5, float f6, float f7) {
            this.ensureSpace(6);
            this.curveTypes[this.numCurves++] = 2;
            float[] fArray = this.curves;
            int n2 = this.end;
            fArray[n2++] = f6;
            fArray[n2++] = f7;
            fArray[n2++] = f4;
            fArray[n2++] = f5;
            fArray[n2++] = f2;
            fArray[n2++] = f3;
            this.end = n2;
        }

        void pushQuad(float f2, float f3, float f4, float f5) {
            this.ensureSpace(4);
            this.curveTypes[this.numCurves++] = 1;
            float[] fArray = this.curves;
            int n2 = this.end;
            fArray[n2++] = f4;
            fArray[n2++] = f5;
            fArray[n2++] = f2;
            fArray[n2++] = f3;
            this.end = n2;
        }

        void pushLine(float f2, float f3) {
            this.ensureSpace(2);
            this.curveTypes[this.numCurves++] = 0;
            this.curves[this.end++] = f2;
            this.curves[this.end++] = f3;
        }

        void pullAll(PathConsumer2D pathConsumer2D) {
            int n2 = this.numCurves;
            if (n2 == 0) {
                return;
            }
            if (MarlinConst.DO_STATS) {
                if (this.numCurves > this.curveTypesUseMark) {
                    this.curveTypesUseMark = this.numCurves;
                }
                if (this.end > this.curvesUseMark) {
                    this.curvesUseMark = this.end;
                }
            }
            byte[] byArray = this.curveTypes;
            float[] fArray = this.curves;
            int n3 = 0;
            block5: for (int i2 = 0; i2 < n2; ++i2) {
                switch (byArray[i2]) {
                    case 0: {
                        pathConsumer2D.lineTo(fArray[n3], fArray[n3 + 1]);
                        n3 += 2;
                        continue block5;
                    }
                    case 2: {
                        pathConsumer2D.curveTo(fArray[n3], fArray[n3 + 1], fArray[n3 + 2], fArray[n3 + 3], fArray[n3 + 4], fArray[n3 + 5]);
                        n3 += 6;
                        continue block5;
                    }
                    case 1: {
                        pathConsumer2D.quadTo(fArray[n3], fArray[n3 + 1], fArray[n3 + 2], fArray[n3 + 3]);
                        n3 += 4;
                        continue block5;
                    }
                }
            }
            this.numCurves = 0;
            this.end = 0;
        }

        void popAll(PathConsumer2D pathConsumer2D) {
            int n2 = this.numCurves;
            if (n2 == 0) {
                return;
            }
            if (MarlinConst.DO_STATS) {
                if (this.numCurves > this.curveTypesUseMark) {
                    this.curveTypesUseMark = this.numCurves;
                }
                if (this.end > this.curvesUseMark) {
                    this.curvesUseMark = this.end;
                }
            }
            byte[] byArray = this.curveTypes;
            float[] fArray = this.curves;
            int n3 = this.end;
            block5: while (n2 != 0) {
                switch (byArray[--n2]) {
                    case 0: {
                        pathConsumer2D.lineTo(fArray[n3 -= 2], fArray[n3 + 1]);
                        continue block5;
                    }
                    case 2: {
                        pathConsumer2D.curveTo(fArray[n3 -= 6], fArray[n3 + 1], fArray[n3 + 2], fArray[n3 + 3], fArray[n3 + 4], fArray[n3 + 5]);
                        continue block5;
                    }
                    case 1: {
                        pathConsumer2D.quadTo(fArray[n3 -= 4], fArray[n3 + 1], fArray[n3 + 2], fArray[n3 + 3]);
                        continue block5;
                    }
                }
            }
            this.numCurves = 0;
            this.end = 0;
        }

        public String toString() {
            Object object = "";
            int n2 = this.numCurves;
            int n3 = this.end;
            while (n2 != 0) {
                int n4;
                switch (this.curveTypes[--n2]) {
                    case 0: {
                        n4 = 2;
                        object = (String)object + "line: ";
                        break;
                    }
                    case 1: {
                        n4 = 4;
                        object = (String)object + "quad: ";
                        break;
                    }
                    case 2: {
                        n4 = 6;
                        object = (String)object + "cubic: ";
                        break;
                    }
                    default: {
                        n4 = 0;
                    }
                }
                object = (String)object + Arrays.toString(Arrays.copyOfRange(this.curves, n3 -= n4, n3 + n4)) + "\n";
            }
            return object;
        }
    }
}

