/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.javafx.geom.PathConsumer2D;
import com.sun.marlin.MarlinProperties;

public final class PathSimplifier
implements PathConsumer2D {
    private static final float PIX_THRESHOLD = MarlinProperties.getPathSimplifierPixelTolerance();
    private static final float SQUARE_TOLERANCE = PIX_THRESHOLD * PIX_THRESHOLD;
    private PathConsumer2D delegate;
    private float cx;
    private float cy;
    private boolean skipped;
    private float sx;
    private float sy;

    PathSimplifier() {
    }

    public PathSimplifier init(PathConsumer2D pathConsumer2D) {
        this.delegate = pathConsumer2D;
        this.skipped = false;
        return this;
    }

    private void finishPath() {
        if (this.skipped) {
            this._lineTo(this.sx, this.sy);
        }
    }

    @Override
    public void pathDone() {
        this.finishPath();
        this.delegate.pathDone();
    }

    @Override
    public void closePath() {
        this.finishPath();
        this.delegate.closePath();
    }

    @Override
    public void moveTo(float f2, float f3) {
        this.finishPath();
        this.delegate.moveTo(f2, f3);
        this.cx = f2;
        this.cy = f3;
    }

    @Override
    public void lineTo(float f2, float f3) {
        float f4 = f2 - this.cx;
        float f5 = f3 - this.cy;
        if (f4 * f4 + f5 * f5 <= SQUARE_TOLERANCE) {
            this.skipped = true;
            this.sx = f2;
            this.sy = f3;
            return;
        }
        this._lineTo(f2, f3);
    }

    private void _lineTo(float f2, float f3) {
        this.delegate.lineTo(f2, f3);
        this.cx = f2;
        this.cy = f3;
        this.skipped = false;
    }

    @Override
    public void quadTo(float f2, float f3, float f4, float f5) {
        float f6 = f4 - this.cx;
        float f7 = f5 - this.cy;
        if (f6 * f6 + f7 * f7 <= SQUARE_TOLERANCE && (f6 = f2 - this.cx) * f6 + (f7 = f3 - this.cy) * f7 <= SQUARE_TOLERANCE) {
            this.skipped = true;
            this.sx = f4;
            this.sy = f5;
            return;
        }
        this.delegate.quadTo(f2, f3, f4, f5);
        this.cx = f4;
        this.cy = f5;
        this.skipped = false;
    }

    @Override
    public void curveTo(float f2, float f3, float f4, float f5, float f6, float f7) {
        float f8 = f6 - this.cx;
        float f9 = f7 - this.cy;
        if (f8 * f8 + f9 * f9 <= SQUARE_TOLERANCE && (f8 = f2 - this.cx) * f8 + (f9 = f3 - this.cy) * f9 <= SQUARE_TOLERANCE && (f8 = f4 - this.cx) * f8 + (f9 = f5 - this.cy) * f9 <= SQUARE_TOLERANCE) {
            this.skipped = true;
            this.sx = f6;
            this.sy = f7;
            return;
        }
        this.delegate.curveTo(f2, f3, f4, f5, f6, f7);
        this.cx = f6;
        this.cy = f7;
        this.skipped = false;
    }
}

