/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.javafx.geom.PathConsumer2D;
import com.sun.marlin.Curve;
import com.sun.marlin.Helpers;
import com.sun.marlin.MarlinConst;
import com.sun.marlin.MarlinUtils;
import com.sun.marlin.RendererContext;
import com.sun.marlin.TransformingPathConsumer2D;
import java.util.Arrays;

public final class Stroker
implements PathConsumer2D,
MarlinConst {
    private static final int MOVE_TO = 0;
    private static final int DRAWING_OP_TO = 1;
    private static final int CLOSE = 2;
    private static final float ERR_JOIN = 1.0f / MIN_SUBPIXELS;
    private static final float ROUND_JOIN_THRESHOLD = ERR_JOIN * ERR_JOIN;
    private static final float C = (float)(4.0 * (Math.sqrt(2.0) - 1.0) / 3.0);
    private static final float SQRT_2 = (float)Math.sqrt(2.0);
    private PathConsumer2D out;
    private int capStyle;
    private int joinStyle;
    private float lineWidth2;
    private float invHalfLineWidth2Sq;
    private final float[] offset0 = new float[2];
    private final float[] offset1 = new float[2];
    private final float[] offset2 = new float[2];
    private final float[] miter = new float[2];
    private float miterLimitSq;
    private int prev;
    private float sx0;
    private float sy0;
    private float sdx;
    private float sdy;
    private float cx0;
    private float cy0;
    private float cdx;
    private float cdy;
    private float smx;
    private float smy;
    private float cmx;
    private float cmy;
    private final Helpers.PolyStack reverse;
    private final float[] lp = new float[8];
    private final float[] rp = new float[8];
    final RendererContext rdrCtx;
    final Curve curve;
    private float[] clipRect;
    private int cOutCode = 0;
    private int sOutCode = 0;
    private boolean opened = false;
    private boolean capStart = false;
    private boolean monotonize;
    private boolean subdivide = DO_CLIP_SUBDIVIDER;
    private final TransformingPathConsumer2D.CurveClipSplitter curveSplitter;

    Stroker(RendererContext rendererContext) {
        this.rdrCtx = rendererContext;
        this.reverse = rendererContext.stats != null ? new Helpers.PolyStack(rendererContext, rendererContext.stats.stat_str_polystack_types, rendererContext.stats.stat_str_polystack_curves, rendererContext.stats.hist_str_polystack_curves, rendererContext.stats.stat_array_str_polystack_curves, rendererContext.stats.stat_array_str_polystack_types) : new Helpers.PolyStack(rendererContext);
        this.curve = rendererContext.curve;
        this.curveSplitter = rendererContext.curveClipSplitter;
    }

    public Stroker init(PathConsumer2D pathConsumer2D, float f2, int n2, int n3, float f3, boolean bl) {
        this.out = pathConsumer2D;
        this.lineWidth2 = f2 / 2.0f;
        this.invHalfLineWidth2Sq = 1.0f / (2.0f * this.lineWidth2 * this.lineWidth2);
        this.monotonize = bl;
        this.capStyle = n2;
        this.joinStyle = n3;
        float f4 = f3 * this.lineWidth2;
        this.miterLimitSq = f4 * f4;
        this.prev = 2;
        this.rdrCtx.stroking = 1;
        if (this.rdrCtx.doClip) {
            float f5 = this.lineWidth2;
            if (n2 == 2) {
                f5 *= SQRT_2;
            }
            if (n3 == 0 && f5 < f4) {
                f5 = f4;
            }
            float[] fArray = this.rdrCtx.clipRect;
            fArray[0] = fArray[0] - f5;
            fArray[1] = fArray[1] + f5;
            fArray[2] = fArray[2] - f5;
            fArray[3] = fArray[3] + f5;
            this.clipRect = fArray;
            if (MarlinConst.DO_LOG_CLIP) {
                MarlinUtils.logInfo("clipRect (stroker): " + Arrays.toString(this.rdrCtx.clipRect));
            }
            if (DO_CLIP_SUBDIVIDER) {
                this.subdivide = bl;
                this.curveSplitter.init();
            } else {
                this.subdivide = false;
            }
        } else {
            this.clipRect = null;
            this.cOutCode = 0;
            this.sOutCode = 0;
        }
        return this;
    }

    public void disableClipping() {
        this.clipRect = null;
        this.cOutCode = 0;
        this.sOutCode = 0;
    }

    void dispose() {
        this.reverse.dispose();
        this.opened = false;
        this.capStart = false;
    }

    private static void computeOffset(float f2, float f3, float f4, float[] fArray) {
        float f5 = f2 * f2 + f3 * f3;
        if (f5 == 0.0f) {
            fArray[0] = 0.0f;
            fArray[1] = 0.0f;
        } else {
            f5 = (float)Math.sqrt(f5);
            fArray[0] = f3 * f4 / f5;
            fArray[1] = -(f2 * f4) / f5;
        }
    }

    private static boolean isCW(float f2, float f3, float f4, float f5) {
        return f2 * f5 <= f3 * f4;
    }

    private void mayDrawRoundJoin(float f2, float f3, float f4, float f5, float f6, float f7, boolean bl) {
        if (f4 == 0.0f && f5 == 0.0f || f6 == 0.0f && f7 == 0.0f) {
            return;
        }
        float f8 = f4 - f6;
        float f9 = f5 - f7;
        float f10 = f8 * f8 + f9 * f9;
        if (f10 < ROUND_JOIN_THRESHOLD) {
            return;
        }
        if (bl) {
            f4 = -f4;
            f5 = -f5;
            f6 = -f6;
            f7 = -f7;
        }
        this.drawRoundJoin(f2, f3, f4, f5, f6, f7, bl);
    }

    private void drawRoundJoin(float f2, float f3, float f4, float f5, float f6, float f7, boolean bl) {
        float f8 = f4 * f6 + f5 * f7;
        if (f8 >= 0.0f) {
            this.drawBezApproxForArc(f2, f3, f4, f5, f6, f7, bl);
        } else {
            float f9 = f7 - f5;
            float f10 = f4 - f6;
            float f11 = (float)Math.sqrt(f9 * f9 + f10 * f10);
            float f12 = this.lineWidth2 / f11;
            float f13 = f9 * f12;
            float f14 = f10 * f12;
            if (bl) {
                f13 = -f13;
                f14 = -f14;
            }
            this.drawBezApproxForArc(f2, f3, f4, f5, f13, f14, bl);
            this.drawBezApproxForArc(f2, f3, f13, f14, f6, f7, bl);
        }
    }

    private void drawBezApproxForArc(float f2, float f3, float f4, float f5, float f6, float f7, boolean bl) {
        float f8 = (f4 * f6 + f5 * f7) * this.invHalfLineWidth2Sq;
        if (f8 >= 0.5f) {
            return;
        }
        float f9 = (float)(1.3333333333333333 * Math.sqrt(0.5 - (double)f8) / (1.0 + Math.sqrt((double)f8 + 0.5)));
        if (bl) {
            f9 = -f9;
        }
        float f10 = f2 + f4;
        float f11 = f3 + f5;
        float f12 = f10 - f9 * f5;
        float f13 = f11 + f9 * f4;
        float f14 = f2 + f6;
        float f15 = f3 + f7;
        float f16 = f14 + f9 * f7;
        float f17 = f15 - f9 * f6;
        this.emitCurveTo(f10, f11, f12, f13, f16, f17, f14, f15, bl);
    }

    private void drawRoundCap(float f2, float f3, float f4, float f5) {
        float f6 = C * f4;
        float f7 = C * f5;
        this.emitCurveTo(f2 + f4 - f7, f3 + f5 + f6, f2 - f5 + f6, f3 + f4 + f7, f2 - f5, f3 + f4);
        this.emitCurveTo(f2 - f5 - f6, f3 + f4 - f7, f2 - f4 - f7, f3 - f5 + f6, f2 - f4, f3 - f5);
    }

    private static void computeMiter(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float[] fArray) {
        float f10 = f4 - f2;
        float f11 = f5 - f3;
        float f12 = f8 - f6;
        float f13 = f9 - f7;
        float f14 = f10 * f13 - f12 * f11;
        float f15 = f12 * (f3 - f7) - f13 * (f2 - f6);
        fArray[0] = f2 + (f15 /= f14) * f10;
        fArray[1] = f3 + f15 * f11;
    }

    private static void safeComputeMiter(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float[] fArray) {
        float f10 = f4 - f2;
        float f11 = f9 - f7;
        float f12 = f8 - f6;
        float f13 = f5 - f3;
        float f14 = f10 * f11 - f12 * f13;
        if (f14 == 0.0f) {
            fArray[2] = (f2 + f6) / 2.0f;
            fArray[3] = (f3 + f7) / 2.0f;
        } else {
            float f15 = f12 * (f3 - f7) - f11 * (f2 - f6);
            fArray[2] = f2 + (f15 /= f14) * f10;
            fArray[3] = f3 + f15 * f13;
        }
    }

    private void drawMiter(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, boolean bl) {
        if (f10 == f8 && f11 == f9 || f2 == 0.0f && f3 == 0.0f || f6 == 0.0f && f7 == 0.0f) {
            return;
        }
        if (bl) {
            f8 = -f8;
            f9 = -f9;
            f10 = -f10;
            f11 = -f11;
        }
        Stroker.computeMiter(f4 - f2 + f8, f5 - f3 + f9, f4 + f8, f5 + f9, f6 + f4 + f10, f7 + f5 + f11, f4 + f10, f5 + f11, this.miter);
        float f12 = this.miter[0];
        float f13 = this.miter[1];
        float f14 = (f12 - f4) * (f12 - f4) + (f13 - f5) * (f13 - f5);
        if (f14 < this.miterLimitSq) {
            this.emitLineTo(f12, f13, bl);
        }
    }

    @Override
    public void moveTo(float f2, float f3) {
        this._moveTo(f2, f3, this.cOutCode);
        this.sx0 = f2;
        this.sy0 = f3;
        this.sdx = 1.0f;
        this.sdy = 0.0f;
        this.opened = false;
        this.capStart = false;
        if (this.clipRect != null) {
            int n2;
            this.cOutCode = n2 = Helpers.outcode(f2, f3, this.clipRect);
            this.sOutCode = n2;
        }
    }

    private void _moveTo(float f2, float f3, int n2) {
        if (this.prev == 0) {
            this.cx0 = f2;
            this.cy0 = f3;
        } else {
            if (this.prev == 1) {
                this.finish(n2);
            }
            this.prev = 0;
            this.cx0 = f2;
            this.cy0 = f3;
            this.cdx = 1.0f;
            this.cdy = 0.0f;
        }
    }

    @Override
    public void lineTo(float f2, float f3) {
        this.lineTo(f2, f3, false);
    }

    private void lineTo(float f2, float f3, boolean bl) {
        int n2 = this.cOutCode;
        if (!bl && this.clipRect != null) {
            int n3 = Helpers.outcode(f2, f3, this.clipRect);
            int n4 = n2 | n3;
            if (n4 != 0) {
                int n5 = n2 & n3;
                if (n5 == 0) {
                    if (this.subdivide) {
                        this.subdivide = false;
                        boolean bl2 = this.curveSplitter.splitLine(this.cx0, this.cy0, f2, f3, n4, this);
                        this.subdivide = true;
                        if (bl2) {
                            return;
                        }
                    }
                } else {
                    this.cOutCode = n3;
                    this._moveTo(f2, f3, n2);
                    this.opened = true;
                    return;
                }
            }
            this.cOutCode = n3;
        }
        float f4 = f2 - this.cx0;
        float f5 = f3 - this.cy0;
        if (f4 == 0.0f && f5 == 0.0f) {
            f4 = 1.0f;
        }
        Stroker.computeOffset(f4, f5, this.lineWidth2, this.offset0);
        float f6 = this.offset0[0];
        float f7 = this.offset0[1];
        this.drawJoin(this.cdx, this.cdy, this.cx0, this.cy0, f4, f5, this.cmx, this.cmy, f6, f7, n2);
        this.emitLineTo(this.cx0 + f6, this.cy0 + f7);
        this.emitLineTo(f2 + f6, f3 + f7);
        this.emitLineToRev(this.cx0 - f6, this.cy0 - f7);
        this.emitLineToRev(f2 - f6, f3 - f7);
        this.prev = 1;
        this.cx0 = f2;
        this.cy0 = f3;
        this.cdx = f4;
        this.cdy = f5;
        this.cmx = f6;
        this.cmy = f7;
    }

    @Override
    public void closePath() {
        if (this.prev != 1 && !this.opened) {
            if (this.prev == 2) {
                return;
            }
            this.emitMoveTo(this.cx0, this.cy0 - this.lineWidth2);
            this.sdx = 1.0f;
            this.sdy = 0.0f;
            this.cdx = 1.0f;
            this.cdy = 0.0f;
            this.smx = 0.0f;
            this.smy = -this.lineWidth2;
            this.cmx = 0.0f;
            this.cmy = -this.lineWidth2;
            this.finish(this.cOutCode);
            return;
        }
        if ((this.sOutCode & this.cOutCode) == 0) {
            if (this.cx0 != this.sx0 || this.cy0 != this.sy0) {
                this.lineTo(this.sx0, this.sy0, true);
            }
            this.drawJoin(this.cdx, this.cdy, this.cx0, this.cy0, this.sdx, this.sdy, this.cmx, this.cmy, this.smx, this.smy, this.sOutCode);
            this.emitLineTo(this.sx0 + this.smx, this.sy0 + this.smy);
            if (this.opened) {
                this.emitLineTo(this.sx0 - this.smx, this.sy0 - this.smy);
            } else {
                this.emitMoveTo(this.sx0 - this.smx, this.sy0 - this.smy);
            }
        }
        this.emitReverse();
        this.prev = 2;
        this.cx0 = this.sx0;
        this.cy0 = this.sy0;
        this.cOutCode = this.sOutCode;
        if (this.opened) {
            this.opened = false;
        } else {
            this.emitClose();
        }
    }

    private void emitReverse() {
        this.reverse.popAll(this.out);
    }

    @Override
    public void pathDone() {
        if (this.prev == 1) {
            this.finish(this.cOutCode);
        }
        this.out.pathDone();
        this.prev = 2;
        this.dispose();
    }

    private void finish(int n2) {
        if (this.rdrCtx.closedPath) {
            this.emitReverse();
        } else {
            if (n2 == 0) {
                if (this.capStyle == 1) {
                    this.drawRoundCap(this.cx0, this.cy0, this.cmx, this.cmy);
                } else if (this.capStyle == 2) {
                    this.emitLineTo(this.cx0 - this.cmy + this.cmx, this.cy0 + this.cmx + this.cmy);
                    this.emitLineTo(this.cx0 - this.cmy - this.cmx, this.cy0 + this.cmx - this.cmy);
                }
            }
            this.emitReverse();
            if (!this.capStart) {
                this.capStart = true;
                if (this.sOutCode == 0) {
                    if (this.capStyle == 1) {
                        this.drawRoundCap(this.sx0, this.sy0, -this.smx, -this.smy);
                    } else if (this.capStyle == 2) {
                        this.emitLineTo(this.sx0 + this.smy - this.smx, this.sy0 - this.smx - this.smy);
                        this.emitLineTo(this.sx0 + this.smy + this.smx, this.sy0 - this.smx + this.smy);
                    }
                }
            }
        }
        this.emitClose();
    }

    private void emitMoveTo(float f2, float f3) {
        this.out.moveTo(f2, f3);
    }

    private void emitLineTo(float f2, float f3) {
        this.out.lineTo(f2, f3);
    }

    private void emitLineToRev(float f2, float f3) {
        this.reverse.pushLine(f2, f3);
    }

    private void emitLineTo(float f2, float f3, boolean bl) {
        if (bl) {
            this.emitLineToRev(f2, f3);
        } else {
            this.emitLineTo(f2, f3);
        }
    }

    private void emitQuadTo(float f2, float f3, float f4, float f5) {
        this.out.quadTo(f2, f3, f4, f5);
    }

    private void emitQuadToRev(float f2, float f3, float f4, float f5) {
        this.reverse.pushQuad(f2, f3, f4, f5);
    }

    private void emitCurveTo(float f2, float f3, float f4, float f5, float f6, float f7) {
        this.out.curveTo(f2, f3, f4, f5, f6, f7);
    }

    private void emitCurveToRev(float f2, float f3, float f4, float f5, float f6, float f7) {
        this.reverse.pushCubic(f2, f3, f4, f5, f6, f7);
    }

    private void emitCurveTo(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, boolean bl) {
        if (bl) {
            this.reverse.pushCubic(f2, f3, f4, f5, f6, f7);
        } else {
            this.out.curveTo(f4, f5, f6, f7, f8, f9);
        }
    }

    private void emitClose() {
        this.out.closePath();
    }

    private void drawJoin(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, int n2) {
        if (this.prev != 1) {
            this.emitMoveTo(f4 + f10, f5 + f11);
            if (!this.opened) {
                this.sdx = f6;
                this.sdy = f7;
                this.smx = f10;
                this.smy = f11;
            }
        } else {
            boolean bl = Stroker.isCW(f2, f3, f6, f7);
            if (n2 == 0) {
                if (this.joinStyle == 0) {
                    this.drawMiter(f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, bl);
                } else if (this.joinStyle == 1) {
                    this.mayDrawRoundJoin(f4, f5, f8, f9, f10, f11, bl);
                }
            }
            this.emitLineTo(f4, f5, !bl);
        }
        this.prev = 1;
    }

    private static boolean within(float f2, float f3, float f4, float f5, float f6) {
        assert (f6 > 0.0f) : "";
        return Helpers.within(f2, f4, f6) && Helpers.within(f3, f5, f6);
    }

    private void getLineOffsets(float f2, float f3, float f4, float f5, float[] fArray, float[] fArray2) {
        Stroker.computeOffset(f4 - f2, f5 - f3, this.lineWidth2, this.offset0);
        float f6 = this.offset0[0];
        float f7 = this.offset0[1];
        fArray[0] = f2 + f6;
        fArray[1] = f3 + f7;
        fArray[2] = f4 + f6;
        fArray[3] = f5 + f7;
        fArray2[0] = f2 - f6;
        fArray2[1] = f3 - f7;
        fArray2[2] = f4 - f6;
        fArray2[3] = f5 - f7;
    }

    private int computeOffsetCubic(float[] fArray, int n2, float[] fArray2, float[] fArray3) {
        float f2 = fArray[n2];
        float f3 = fArray[n2 + 1];
        float f4 = fArray[n2 + 2];
        float f5 = fArray[n2 + 3];
        float f6 = fArray[n2 + 4];
        float f7 = fArray[n2 + 5];
        float f8 = fArray[n2 + 6];
        float f9 = fArray[n2 + 7];
        float f10 = f8 - f6;
        float f11 = f9 - f7;
        float f12 = f4 - f2;
        float f13 = f5 - f3;
        boolean bl = Stroker.within(f2, f3, f4, f5, 6.0f * Math.ulp(f5));
        boolean bl2 = Stroker.within(f6, f7, f8, f9, 6.0f * Math.ulp(f9));
        if (bl && bl2) {
            this.getLineOffsets(f2, f3, f8, f9, fArray2, fArray3);
            return 4;
        }
        if (bl) {
            f12 = f6 - f2;
            f13 = f7 - f3;
        } else if (bl2) {
            f10 = f8 - f4;
            f11 = f9 - f5;
        }
        float f14 = f12 * f10 + f13 * f11;
        f14 *= f14;
        float f15 = f12 * f12 + f13 * f13;
        float f16 = f10 * f10 + f11 * f11;
        if (Helpers.within(f14, f15 * f16, 4.0f * Math.ulp(f14))) {
            this.getLineOffsets(f2, f3, f8, f9, fArray2, fArray3);
            return 4;
        }
        float f17 = (f2 + 3.0f * (f4 + f6) + f8) / 8.0f;
        float f18 = (f3 + 3.0f * (f5 + f7) + f9) / 8.0f;
        float f19 = f6 + f8 - f2 - f4;
        float f20 = f7 + f9 - f3 - f5;
        Stroker.computeOffset(f12, f13, this.lineWidth2, this.offset0);
        Stroker.computeOffset(f19, f20, this.lineWidth2, this.offset1);
        Stroker.computeOffset(f10, f11, this.lineWidth2, this.offset2);
        float f21 = f2 + this.offset0[0];
        float f22 = f3 + this.offset0[1];
        float f23 = f17 + this.offset1[0];
        float f24 = f18 + this.offset1[1];
        float f25 = f8 + this.offset2[0];
        float f26 = f9 + this.offset2[1];
        float f27 = 4.0f / (3.0f * (f12 * f11 - f13 * f10));
        float f28 = 2.0f * f23 - f21 - f25;
        float f29 = 2.0f * f24 - f22 - f26;
        float f30 = f27 * (f11 * f28 - f10 * f29);
        float f31 = f27 * (f12 * f29 - f13 * f28);
        float f32 = f21 + f30 * f12;
        float f33 = f22 + f30 * f13;
        float f34 = f25 + f31 * f10;
        float f35 = f26 + f31 * f11;
        fArray2[0] = f21;
        fArray2[1] = f22;
        fArray2[2] = f32;
        fArray2[3] = f33;
        fArray2[4] = f34;
        fArray2[5] = f35;
        fArray2[6] = f25;
        fArray2[7] = f26;
        f21 = f2 - this.offset0[0];
        f22 = f3 - this.offset0[1];
        f25 = f8 - this.offset2[0];
        f26 = f9 - this.offset2[1];
        f28 = 2.0f * (f23 -= 2.0f * this.offset1[0]) - f21 - f25;
        f29 = 2.0f * (f24 -= 2.0f * this.offset1[1]) - f22 - f26;
        f30 = f27 * (f11 * f28 - f10 * f29);
        f31 = f27 * (f12 * f29 - f13 * f28);
        f32 = f21 + f30 * f12;
        f33 = f22 + f30 * f13;
        f34 = f25 + f31 * f10;
        f35 = f26 + f31 * f11;
        fArray3[0] = f21;
        fArray3[1] = f22;
        fArray3[2] = f32;
        fArray3[3] = f33;
        fArray3[4] = f34;
        fArray3[5] = f35;
        fArray3[6] = f25;
        fArray3[7] = f26;
        return 8;
    }

    private int computeOffsetQuad(float[] fArray, int n2, float[] fArray2, float[] fArray3) {
        float f2 = fArray[n2];
        float f3 = fArray[n2 + 1];
        float f4 = fArray[n2 + 2];
        float f5 = fArray[n2 + 3];
        float f6 = fArray[n2 + 4];
        float f7 = fArray[n2 + 5];
        float f8 = f6 - f4;
        float f9 = f7 - f5;
        float f10 = f4 - f2;
        float f11 = f5 - f3;
        boolean bl = Stroker.within(f2, f3, f4, f5, 6.0f * Math.ulp(f5));
        boolean bl2 = Stroker.within(f4, f5, f6, f7, 6.0f * Math.ulp(f7));
        if (bl || bl2) {
            this.getLineOffsets(f2, f3, f6, f7, fArray2, fArray3);
            return 4;
        }
        float f12 = f10 * f8 + f11 * f9;
        float f13 = f10 * f10 + f11 * f11;
        float f14 = f8 * f8 + f9 * f9;
        if (Helpers.within(f12 *= f12, f13 * f14, 4.0f * Math.ulp(f12))) {
            this.getLineOffsets(f2, f3, f6, f7, fArray2, fArray3);
            return 4;
        }
        Stroker.computeOffset(f10, f11, this.lineWidth2, this.offset0);
        Stroker.computeOffset(f8, f9, this.lineWidth2, this.offset1);
        float f15 = f2 + this.offset0[0];
        float f16 = f3 + this.offset0[1];
        float f17 = f6 + this.offset1[0];
        float f18 = f7 + this.offset1[1];
        Stroker.safeComputeMiter(f15, f16, f15 + f10, f16 + f11, f17, f18, f17 - f8, f18 - f9, fArray2);
        fArray2[0] = f15;
        fArray2[1] = f16;
        fArray2[4] = f17;
        fArray2[5] = f18;
        f15 = f2 - this.offset0[0];
        f16 = f3 - this.offset0[1];
        f17 = f6 - this.offset1[0];
        f18 = f7 - this.offset1[1];
        Stroker.safeComputeMiter(f15, f16, f15 + f10, f16 + f11, f17, f18, f17 - f8, f18 - f9, fArray3);
        fArray3[0] = f15;
        fArray3[1] = f16;
        fArray3[4] = f17;
        fArray3[5] = f18;
        return 6;
    }

    @Override
    public void curveTo(float f2, float f3, float f4, float f5, float f6, float f7) {
        int n2 = this.cOutCode;
        if (this.clipRect != null) {
            int n3;
            int n4;
            int n5 = Helpers.outcode(f2, f3, this.clipRect);
            int n6 = n2 | n5 | (n4 = Helpers.outcode(f4, f5, this.clipRect)) | (n3 = Helpers.outcode(f6, f7, this.clipRect));
            if (n6 != 0) {
                int n7 = n2 & n5 & n4 & n3;
                if (n7 == 0) {
                    if (this.subdivide) {
                        this.subdivide = false;
                        boolean bl = this.curveSplitter.splitCurve(this.cx0, this.cy0, f2, f3, f4, f5, f6, f7, n6, this);
                        this.subdivide = true;
                        if (bl) {
                            return;
                        }
                    }
                } else {
                    this.cOutCode = n3;
                    this._moveTo(f6, f7, n2);
                    this.opened = true;
                    return;
                }
            }
            this.cOutCode = n3;
        }
        this._curveTo(f2, f3, f4, f5, f6, f7, n2);
    }

    private void _curveTo(float f2, float f3, float f4, float f5, float f6, float f7, int n2) {
        float[] fArray;
        Object object;
        float f8;
        float f9 = f2 - this.cx0;
        float f10 = f3 - this.cy0;
        float f11 = f6 - f4;
        float f12 = f7 - f5;
        if (f9 == 0.0f && f10 == 0.0f) {
            f9 = f4 - this.cx0;
            f10 = f5 - this.cy0;
            if (f9 == 0.0f && f10 == 0.0f) {
                f9 = f6 - this.cx0;
                f10 = f7 - this.cy0;
            }
        }
        if (f11 == 0.0f && f12 == 0.0f) {
            f11 = f6 - f2;
            f12 = f7 - f3;
            if (f11 == 0.0f && f12 == 0.0f) {
                f11 = f6 - this.cx0;
                f12 = f7 - this.cy0;
            }
        }
        if (f9 == 0.0f && f10 == 0.0f) {
            if (this.clipRect != null) {
                this.cOutCode = n2;
            }
            this.lineTo(this.cx0, this.cy0);
            return;
        }
        if (Math.abs(f9) < 0.1f && Math.abs(f10) < 0.1f) {
            f8 = (float)Math.sqrt(f9 * f9 + f10 * f10);
            f9 /= f8;
            f10 /= f8;
        }
        if (Math.abs(f11) < 0.1f && Math.abs(f12) < 0.1f) {
            f8 = (float)Math.sqrt(f11 * f11 + f12 * f12);
            f11 /= f8;
            f12 /= f8;
        }
        Stroker.computeOffset(f9, f10, this.lineWidth2, this.offset0);
        this.drawJoin(this.cdx, this.cdy, this.cx0, this.cy0, f9, f10, this.cmx, this.cmy, this.offset0[0], this.offset0[1], n2);
        int n3 = 0;
        float[] fArray2 = this.lp;
        if (this.monotonize) {
            object = this.rdrCtx.monotonizer.curve(this.cx0, this.cy0, f2, f3, f4, f5, f6, f7);
            n3 = ((TransformingPathConsumer2D.CurveBasicMonotonizer)object).nbSplits;
            fArray = ((TransformingPathConsumer2D.CurveBasicMonotonizer)object).middle;
        } else {
            fArray = fArray2;
            fArray[0] = this.cx0;
            fArray[1] = this.cy0;
            fArray[2] = f2;
            fArray[3] = f3;
            fArray[4] = f4;
            fArray[5] = f5;
            fArray[6] = f6;
            fArray[7] = f7;
        }
        object = this.rp;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n5 <= n3) {
            n4 = this.computeOffsetCubic(fArray, n6, fArray2, (float[])object);
            this.emitLineTo(fArray2[0], fArray2[1]);
            switch (n4) {
                case 8: {
                    this.emitCurveTo(fArray2[2], fArray2[3], fArray2[4], fArray2[5], fArray2[6], fArray2[7]);
                    this.emitCurveToRev((float)object[0], (float)object[1], (float)object[2], (float)object[3], (float)object[4], (float)object[5]);
                    break;
                }
                case 4: {
                    this.emitLineTo(fArray2[2], fArray2[3]);
                    this.emitLineToRev((float)object[0], (float)object[1]);
                    break;
                }
            }
            this.emitLineToRev((float)object[n4 - 2], (float)object[n4 - 1]);
            ++n5;
            n6 += 6;
        }
        this.prev = 1;
        this.cx0 = f6;
        this.cy0 = f7;
        this.cdx = f11;
        this.cdy = f12;
        this.cmx = (fArray2[n4 - 2] - object[n4 - 2]) / 2.0f;
        this.cmy = (fArray2[n4 - 1] - object[n4 - 1]) / 2.0f;
    }

    @Override
    public void quadTo(float f2, float f3, float f4, float f5) {
        int n2 = this.cOutCode;
        if (this.clipRect != null) {
            int n3;
            int n4 = Helpers.outcode(f2, f3, this.clipRect);
            int n5 = n2 | n4 | (n3 = Helpers.outcode(f4, f5, this.clipRect));
            if (n5 != 0) {
                int n6 = n2 & n4 & n3;
                if (n6 == 0) {
                    if (this.subdivide) {
                        this.subdivide = false;
                        boolean bl = this.curveSplitter.splitQuad(this.cx0, this.cy0, f2, f3, f4, f5, n5, this);
                        this.subdivide = true;
                        if (bl) {
                            return;
                        }
                    }
                } else {
                    this.cOutCode = n3;
                    this._moveTo(f4, f5, n2);
                    this.opened = true;
                    return;
                }
            }
            this.cOutCode = n3;
        }
        this._quadTo(f2, f3, f4, f5, n2);
    }

    private void _quadTo(float f2, float f3, float f4, float f5, int n2) {
        float[] fArray;
        Object object;
        float f6;
        float f7 = f2 - this.cx0;
        float f8 = f3 - this.cy0;
        float f9 = f4 - f2;
        float f10 = f5 - f3;
        if (f7 == 0.0f && f8 == 0.0f || f9 == 0.0f && f10 == 0.0f) {
            f7 = f9 = f4 - this.cx0;
            f8 = f10 = f5 - this.cy0;
        }
        if (f7 == 0.0f && f8 == 0.0f) {
            if (this.clipRect != null) {
                this.cOutCode = n2;
            }
            this.lineTo(this.cx0, this.cy0);
            return;
        }
        if (Math.abs(f7) < 0.1f && Math.abs(f8) < 0.1f) {
            f6 = (float)Math.sqrt(f7 * f7 + f8 * f8);
            f7 /= f6;
            f8 /= f6;
        }
        if (Math.abs(f9) < 0.1f && Math.abs(f10) < 0.1f) {
            f6 = (float)Math.sqrt(f9 * f9 + f10 * f10);
            f9 /= f6;
            f10 /= f6;
        }
        Stroker.computeOffset(f7, f8, this.lineWidth2, this.offset0);
        this.drawJoin(this.cdx, this.cdy, this.cx0, this.cy0, f7, f8, this.cmx, this.cmy, this.offset0[0], this.offset0[1], n2);
        int n3 = 0;
        float[] fArray2 = this.lp;
        if (this.monotonize) {
            object = this.rdrCtx.monotonizer.quad(this.cx0, this.cy0, f2, f3, f4, f5);
            n3 = ((TransformingPathConsumer2D.CurveBasicMonotonizer)object).nbSplits;
            fArray = ((TransformingPathConsumer2D.CurveBasicMonotonizer)object).middle;
        } else {
            fArray = fArray2;
            fArray[0] = this.cx0;
            fArray[1] = this.cy0;
            fArray[2] = f2;
            fArray[3] = f3;
            fArray[4] = f4;
            fArray[5] = f5;
        }
        object = this.rp;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n5 <= n3) {
            n4 = this.computeOffsetQuad(fArray, n6, fArray2, (float[])object);
            this.emitLineTo(fArray2[0], fArray2[1]);
            switch (n4) {
                case 6: {
                    this.emitQuadTo(fArray2[2], fArray2[3], fArray2[4], fArray2[5]);
                    this.emitQuadToRev((float)object[0], (float)object[1], (float)object[2], (float)object[3]);
                    break;
                }
                case 4: {
                    this.emitLineTo(fArray2[2], fArray2[3]);
                    this.emitLineToRev((float)object[0], (float)object[1]);
                    break;
                }
            }
            this.emitLineToRev((float)object[n4 - 2], (float)object[n4 - 1]);
            ++n5;
            n6 += 4;
        }
        this.prev = 1;
        this.cx0 = f4;
        this.cy0 = f5;
        this.cdx = f9;
        this.cdy = f10;
        this.cmx = (fArray2[n4 - 2] - object[n4 - 2]) / 2.0f;
        this.cmy = (fArray2[n4 - 1] - object[n4 - 1]) / 2.0f;
    }
}

