/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.d3d;

import com.sun.glass.ui.Screen;
import com.sun.prism.Image;
import com.sun.prism.MediaFrame;
import com.sun.prism.Mesh;
import com.sun.prism.MeshView;
import com.sun.prism.MultiTexture;
import com.sun.prism.PhongMaterial;
import com.sun.prism.PixelFormat;
import com.sun.prism.Presentable;
import com.sun.prism.PresentableState;
import com.sun.prism.Texture;
import com.sun.prism.d3d.D3DContext;
import com.sun.prism.d3d.D3DFrameStats;
import com.sun.prism.d3d.D3DMesh;
import com.sun.prism.d3d.D3DMeshView;
import com.sun.prism.d3d.D3DPhongMaterial;
import com.sun.prism.d3d.D3DPipeline;
import com.sun.prism.d3d.D3DRTTexture;
import com.sun.prism.d3d.D3DResource;
import com.sun.prism.d3d.D3DShader;
import com.sun.prism.d3d.D3DSwapChain;
import com.sun.prism.d3d.D3DTexture;
import com.sun.prism.d3d.D3DVramPool;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.TextureResourcePool;
import com.sun.prism.impl.ps.BaseShaderFactory;
import com.sun.prism.ps.Shader;
import com.sun.prism.ps.ShaderFactory;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.WeakHashMap;

class D3DResourceFactory
extends BaseShaderFactory {
    private static final Map<Image, Texture> clampTexCache = new WeakHashMap<Image, Texture>();
    private static final Map<Image, Texture> repeatTexCache = new WeakHashMap<Image, Texture>();
    private static final Map<Image, Texture> mipmapTexCache = new WeakHashMap<Image, Texture>();
    private final D3DContext context;
    private final int maxTextureSize;
    private final LinkedList<D3DResource.D3DRecord> records = new LinkedList();
    static final int STATS_FREQUENCY = PrismSettings.prismStatFrequency;
    private int nFrame = -1;
    private D3DFrameStats frameStats;

    D3DResourceFactory(long l2, Screen screen) {
        super(clampTexCache, repeatTexCache, mipmapTexCache);
        this.context = new D3DContext(l2, screen, this);
        this.context.initState();
        this.maxTextureSize = this.computeMaxTextureSize();
        if (PrismSettings.noClampToZero && PrismSettings.verbose) {
            System.out.println("prism.noclamptozero not supported by D3D");
        }
    }

    D3DContext getContext() {
        return this.context;
    }

    @Override
    public TextureResourcePool getTextureResourcePool() {
        return D3DVramPool.instance;
    }

    private void displayPrismStatistics() {
        if (STATS_FREQUENCY > 0 && ++this.nFrame == STATS_FREQUENCY) {
            this.nFrame = 0;
            this.frameStats = this.context.getFrameStats(true, this.frameStats);
            if (this.frameStats != null) {
                System.err.println(this.frameStats.toDebugString(STATS_FREQUENCY));
            }
        }
    }

    @Override
    public boolean isDeviceReady() {
        this.displayPrismStatistics();
        return this.context.testLostStateAndReset();
    }

    static int nextPowerOfTwo(int n2, int n3) {
        int n4;
        if (n2 > n3) {
            return 0;
        }
        for (n4 = 1; n4 < n2; n4 *= 2) {
        }
        return n4;
    }

    @Override
    public boolean isCompatibleTexture(Texture texture) {
        return texture instanceof D3DTexture;
    }

    @Override
    public D3DTexture createTexture(PixelFormat pixelFormat, Texture.Usage usage, Texture.WrapMode wrapMode, int n2, int n3) {
        return this.createTexture(pixelFormat, usage, wrapMode, n2, n3, false);
    }

    @Override
    public D3DTexture createTexture(PixelFormat pixelFormat, Texture.Usage usage, Texture.WrapMode wrapMode, int n2, int n3, boolean bl) {
        int n4;
        int n5;
        if (!this.isFormatSupported(pixelFormat)) {
            throw new UnsupportedOperationException("Pixel format " + pixelFormat + " not supported on this device");
        }
        if (pixelFormat == PixelFormat.MULTI_YCbCr_420) {
            throw new UnsupportedOperationException("MULTI_YCbCr_420 textures require a MediaFrame");
        }
        if (PrismSettings.forcePow2) {
            n5 = D3DResourceFactory.nextPowerOfTwo(n2, Integer.MAX_VALUE);
            n4 = D3DResourceFactory.nextPowerOfTwo(n3, Integer.MAX_VALUE);
        } else {
            n5 = n2;
            n4 = n3;
        }
        D3DVramPool d3DVramPool = D3DVramPool.instance;
        long l2 = d3DVramPool.estimateTextureSize(n5, n4, pixelFormat);
        if (!d3DVramPool.prepareForAllocation(l2)) {
            return null;
        }
        long l3 = D3DResourceFactory.nCreateTexture(this.context.getContextHandle(), pixelFormat.ordinal(), usage.ordinal(), false, n5, n4, 0, bl);
        if (l3 == 0L) {
            return null;
        }
        int n6 = D3DResourceFactory.nGetTextureWidth(l3);
        int n7 = D3DResourceFactory.nGetTextureHeight(l3);
        if (wrapMode != Texture.WrapMode.CLAMP_NOT_NEEDED && (n2 < n6 || n3 < n7)) {
            wrapMode = wrapMode.simulatedVersion();
        }
        return new D3DTexture(this.context, pixelFormat, wrapMode, l3, n6, n7, n2, n3, bl);
    }

    @Override
    public Texture createTexture(MediaFrame mediaFrame) {
        mediaFrame.holdFrame();
        int n2 = mediaFrame.getWidth();
        int n3 = mediaFrame.getHeight();
        int n4 = mediaFrame.getEncodedWidth();
        int n5 = mediaFrame.getEncodedHeight();
        PixelFormat pixelFormat = mediaFrame.getPixelFormat();
        if (pixelFormat == PixelFormat.MULTI_YCbCr_420) {
            MultiTexture multiTexture = new MultiTexture(pixelFormat, Texture.WrapMode.CLAMP_TO_EDGE, n2, n3);
            for (int i2 = 0; i2 < mediaFrame.planeCount(); ++i2) {
                D3DTexture d3DTexture;
                int n6 = n4;
                int n7 = n5;
                if (i2 == 2 || i2 == 1) {
                    n6 /= 2;
                    n7 /= 2;
                }
                if ((d3DTexture = this.createTexture(PixelFormat.BYTE_ALPHA, Texture.Usage.DYNAMIC, Texture.WrapMode.CLAMP_TO_EDGE, n6, n7)) == null) {
                    multiTexture.dispose();
                    return null;
                }
                multiTexture.setTexture(d3DTexture, i2);
            }
            mediaFrame.releaseFrame();
            return multiTexture;
        }
        D3DVramPool d3DVramPool = D3DVramPool.instance;
        long l2 = d3DVramPool.estimateTextureSize(n4, n5, pixelFormat);
        if (!d3DVramPool.prepareForAllocation(l2)) {
            return null;
        }
        long l3 = D3DResourceFactory.nCreateTexture(this.context.getContextHandle(), pixelFormat.ordinal(), Texture.Usage.DYNAMIC.ordinal(), false, n4, n5, 0, false);
        if (0L == l3) {
            return null;
        }
        int n8 = D3DResourceFactory.nGetTextureWidth(l3);
        int n9 = D3DResourceFactory.nGetTextureHeight(l3);
        Texture.WrapMode wrapMode = n4 < n8 || n5 < n9 ? Texture.WrapMode.CLAMP_TO_EDGE_SIMULATED : Texture.WrapMode.CLAMP_TO_EDGE;
        D3DTexture d3DTexture = new D3DTexture(this.context, pixelFormat, wrapMode, l3, n8, n9, n2, n3, false);
        mediaFrame.releaseFrame();
        return d3DTexture;
    }

    @Override
    public int getRTTWidth(int n2, Texture.WrapMode wrapMode) {
        return n2;
    }

    @Override
    public int getRTTHeight(int n2, Texture.WrapMode wrapMode) {
        return n2;
    }

    @Override
    public D3DRTTexture createRTTexture(int n2, int n3, Texture.WrapMode wrapMode) {
        return this.createRTTexture(n2, n3, wrapMode, false);
    }

    @Override
    public D3DRTTexture createRTTexture(int n2, int n3, Texture.WrapMode wrapMode, boolean bl) {
        int n4;
        if (PrismSettings.verbose && this.context.isLost()) {
            System.err.println("RT Texture allocation while the device is lost");
        }
        int n5 = n2;
        int n6 = n3;
        int n7 = 0;
        int n8 = 0;
        if (PrismSettings.forcePow2) {
            n5 = D3DResourceFactory.nextPowerOfTwo(n5, Integer.MAX_VALUE);
            n6 = D3DResourceFactory.nextPowerOfTwo(n6, Integer.MAX_VALUE);
        }
        D3DVramPool d3DVramPool = D3DVramPool.instance;
        int n9 = bl ? ((n4 = D3DPipeline.getInstance().getMaxSamples()) < 2 ? 0 : (n4 < 4 ? 2 : 4)) : 0;
        long l2 = d3DVramPool.estimateRTTextureSize(n2, n3, false);
        if (!d3DVramPool.prepareForAllocation(l2)) {
            return null;
        }
        long l3 = D3DResourceFactory.nCreateTexture(this.context.getContextHandle(), PixelFormat.INT_ARGB_PRE.ordinal(), Texture.Usage.DEFAULT.ordinal(), true, n5, n6, n9, false);
        if (l3 == 0L) {
            return null;
        }
        int n10 = D3DResourceFactory.nGetTextureWidth(l3);
        int n11 = D3DResourceFactory.nGetTextureHeight(l3);
        D3DRTTexture d3DRTTexture = new D3DRTTexture(this.context, wrapMode, l3, n10, n11, n7, n8, n2, n3, n9);
        d3DRTTexture.createGraphics().clear();
        return d3DRTTexture;
    }

    @Override
    public Presentable createPresentable(PresentableState presentableState) {
        long l2;
        if (PrismSettings.verbose && this.context.isLost()) {
            System.err.println("SwapChain allocation while the device is lost");
        }
        if ((l2 = D3DResourceFactory.nCreateSwapChain(this.context.getContextHandle(), presentableState.getNativeView(), PrismSettings.isVsyncEnabled)) != 0L) {
            int n2 = presentableState.getRenderWidth();
            int n3 = presentableState.getRenderHeight();
            D3DRTTexture d3DRTTexture = this.createRTTexture(n2, n3, Texture.WrapMode.CLAMP_NOT_NEEDED, presentableState.isMSAA());
            if (PrismSettings.dirtyOptsEnabled) {
                d3DRTTexture.contentsUseful();
            }
            if (d3DRTTexture != null) {
                return new D3DSwapChain(this.context, l2, d3DRTTexture, presentableState.getRenderScaleX(), presentableState.getRenderScaleY());
            }
            D3DResourceFactory.nReleaseResource(this.context.getContextHandle(), l2);
        }
        return null;
    }

    private static ByteBuffer getBuffer(InputStream inputStream) {
        if (inputStream == null) {
            throw new RuntimeException("InputStream must be non-null");
        }
        try {
            Object object;
            int n2 = 4096;
            Object object2 = new byte[n2];
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, n2);
            int n3 = 0;
            int n4 = -1;
            while ((n4 = bufferedInputStream.read((byte[])object2, n3, n2 - n3)) != -1) {
                if (n2 - (n3 += n4) != 0) continue;
                object = new byte[n2 *= 2];
                System.arraycopy(object2, 0, object, 0, ((byte[])object2).length);
                object2 = object;
            }
            bufferedInputStream.close();
            object = ByteBuffer.allocateDirect(n3);
            ((ByteBuffer)object).put((byte[])object2, 0, n3);
            return object;
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error loading D3D shader object", iOException);
        }
    }

    @Override
    public Shader createShader(InputStream inputStream, Map<String, Integer> map, Map<String, Integer> map2, int n2, boolean bl, boolean bl2) {
        long l2 = D3DShader.init(this.context.getContextHandle(), D3DResourceFactory.getBuffer(inputStream), n2, bl, bl2);
        return new D3DShader(this.context, l2, map2);
    }

    @Override
    public Shader createStockShader(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Shader name must be non-null");
        }
        try {
            InputStream inputStream = AccessController.doPrivileged(() -> D3DResourceFactory.class.getResourceAsStream("hlsl/" + string + ".obj"));
            Class<?> clazz = Class.forName("com.sun.prism.shader." + string + "_Loader");
            Method method = clazz.getMethod("loadShader", ShaderFactory.class, InputStream.class);
            return (Shader)method.invoke(null, this, inputStream);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new InternalError("Error loading stock shader " + string);
        }
    }

    @Override
    public void dispose() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isFormatSupported(PixelFormat pixelFormat) {
        return true;
    }

    private int computeMaxTextureSize() {
        int n2 = D3DResourceFactory.nGetMaximumTextureSize(this.context.getContextHandle());
        if (PrismSettings.verbose) {
            System.err.println("Maximum supported texture size: " + n2);
        }
        if (n2 > PrismSettings.maxTextureSize) {
            n2 = PrismSettings.maxTextureSize;
            if (PrismSettings.verbose) {
                System.err.println("Maximum texture size clamped to " + n2);
            }
        }
        return n2;
    }

    @Override
    public int getMaximumTextureSize() {
        return this.maxTextureSize;
    }

    @Override
    protected void notifyReset() {
        ListIterator listIterator = this.records.listIterator();
        while (listIterator.hasNext()) {
            D3DResource.D3DRecord d3DRecord = (D3DResource.D3DRecord)listIterator.next();
            if (!d3DRecord.isDefaultPool()) continue;
            d3DRecord.markDisposed();
            listIterator.remove();
        }
        super.notifyReset();
    }

    @Override
    protected void notifyReleased() {
        ListIterator listIterator = this.records.listIterator();
        while (listIterator.hasNext()) {
            D3DResource.D3DRecord d3DRecord = (D3DResource.D3DRecord)listIterator.next();
            d3DRecord.markDisposed();
        }
        this.records.clear();
        super.notifyReleased();
    }

    void addRecord(D3DResource.D3DRecord d3DRecord) {
        this.records.add(d3DRecord);
    }

    void removeRecord(D3DResource.D3DRecord d3DRecord) {
        this.records.remove(d3DRecord);
    }

    @Override
    public PhongMaterial createPhongMaterial() {
        return D3DPhongMaterial.create(this.context);
    }

    @Override
    public MeshView createMeshView(Mesh mesh) {
        return D3DMeshView.create(this.context, (D3DMesh)mesh);
    }

    @Override
    public Mesh createMesh() {
        return D3DMesh.create(this.context);
    }

    static native long nGetContext(int var0);

    static native boolean nIsDefaultPool(long var0);

    static native int nTestCooperativeLevel(long var0);

    static native int nResetDevice(long var0);

    static native long nCreateTexture(long var0, int var2, int var3, boolean var4, int var5, int var6, int var7, boolean var8);

    static native long nCreateSwapChain(long var0, long var2, boolean var4);

    static native int nReleaseResource(long var0, long var2);

    static native int nGetMaximumTextureSize(long var0);

    static native int nGetTextureWidth(long var0);

    static native int nGetTextureHeight(long var0);

    static native int nReadPixelsI(long var0, long var2, long var4, Buffer var6, int[] var7, int var8, int var9);

    static native int nReadPixelsB(long var0, long var2, long var4, Buffer var6, byte[] var7, int var8, int var9);

    static native int nUpdateTextureI(long var0, long var2, IntBuffer var4, int[] var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12);

    static native int nUpdateTextureF(long var0, long var2, FloatBuffer var4, float[] var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12);

    static native int nUpdateTextureB(long var0, long var2, ByteBuffer var4, byte[] var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13);

    static native long nGetDevice(long var0);

    static native long nGetNativeTextureObject(long var0);
}

