/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.SentryClient;
import io.sentry.SentryClientFactory;
import io.sentry.context.Context;
import io.sentry.event.Breadcrumb;
import io.sentry.event.Event;
import io.sentry.event.EventBuilder;
import io.sentry.event.User;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Sentry {
    private static final Logger logger = LoggerFactory.getLogger(Sentry.class);
    private static volatile SentryClient storedClient = null;
    private static AtomicBoolean autoInitAttempted = new AtomicBoolean(false);

    private Sentry() {
    }

    public static SentryClient init() {
        return Sentry.init(null, null);
    }

    public static SentryClient init(SentryClientFactory sentryClientFactory) {
        return Sentry.init(null, sentryClientFactory);
    }

    public static SentryClient init(String dsn) {
        return Sentry.init(dsn, null);
    }

    public static SentryClient init(String dsn, SentryClientFactory sentryClientFactory) {
        SentryClient sentryClient = SentryClientFactory.sentryClient(dsn, sentryClientFactory);
        Sentry.setStoredClient(sentryClient);
        return sentryClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SentryClient getStoredClient() {
        if (storedClient != null) {
            return storedClient;
        }
        Class<Sentry> clazz = Sentry.class;
        synchronized (Sentry.class) {
            if (storedClient == null && !autoInitAttempted.get()) {
                autoInitAttempted.set(true);
                Sentry.init();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return storedClient;
        }
    }

    public static Context getContext() {
        return Sentry.getStoredClient().getContext();
    }

    public static void clearContext() {
        Sentry.getStoredClient().clearContext();
    }

    public static void setStoredClient(SentryClient client) {
        if (storedClient != null) {
            logger.warn("Overwriting statically stored SentryClient instance {} with {}.", (Object)storedClient, (Object)client);
        }
        storedClient = client;
    }

    public static void capture(Event event) {
        Sentry.getStoredClient().sendEvent(event);
    }

    public static void capture(Throwable throwable) {
        Sentry.getStoredClient().sendException(throwable);
    }

    public static void capture(String message) {
        Sentry.getStoredClient().sendMessage(message);
    }

    public static void capture(EventBuilder eventBuilder) {
        Sentry.getStoredClient().sendEvent(eventBuilder);
    }

    @Deprecated
    public static void record(Breadcrumb breadcrumb) {
        Sentry.getStoredClient().getContext().recordBreadcrumb(breadcrumb);
    }

    @Deprecated
    public static void setUser(User user) {
        Sentry.getStoredClient().getContext().setUser(user);
    }

    public static void close() {
        if (storedClient == null) {
            return;
        }
        storedClient.closeConnection();
        storedClient = null;
        autoInitAttempted.set(false);
    }
}

