/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.marshaller.json;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import io.sentry.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryJsonGenerator
extends JsonGenerator {
    private static final Logger logger = LoggerFactory.getLogger(Util.class);
    private static final String RECURSION_LIMIT_HIT = "<recursion limit hit>";
    private static final int MAX_LENGTH_LIST = 10;
    private static final int MAX_SIZE_MAP = 50;
    private static final int MAX_LENGTH_STRING = 400;
    private static final int MAX_NESTING = 3;
    private static final String ELIDED = "...";
    private int maxLengthList;
    private int maxLengthString;
    private int maxSizeMap;
    private int maxNesting;
    private JsonGenerator generator;

    public SentryJsonGenerator(JsonGenerator generator) {
        this.generator = generator;
        this.maxLengthList = 10;
        this.maxLengthString = 400;
        this.maxSizeMap = 50;
        this.maxNesting = 3;
    }

    @Override
    public void writeObject(Object value) throws IOException {
        this.writeObject(value, 0);
    }

    private void writeObject(Object value, int recursionLevel) throws IOException {
        if (recursionLevel >= this.maxNesting) {
            this.generator.writeString(RECURSION_LIMIT_HIT);
            return;
        }
        if (value == null) {
            this.generator.writeNull();
        } else if (value.getClass().isArray()) {
            this.generator.writeStartArray();
            this.writeArray(value, recursionLevel);
            this.generator.writeEndArray();
        } else if (value instanceof Map) {
            this.generator.writeStartObject();
            int i2 = 0;
            for (Map.Entry entry : ((Map)value).entrySet()) {
                if (i2 >= this.maxSizeMap) break;
                if (entry.getKey() == null) {
                    this.generator.writeFieldName("null");
                } else {
                    this.generator.writeFieldName(Util.trimString(entry.getKey().toString(), this.maxLengthString));
                }
                this.writeObject(entry.getValue(), recursionLevel + 1);
                ++i2;
            }
            this.generator.writeEndObject();
        } else if (value instanceof Collection) {
            this.generator.writeStartArray();
            int i3 = 0;
            for (Object subValue : (Collection)value) {
                if (i3 >= this.maxLengthList) {
                    this.writeElided();
                    break;
                }
                this.writeObject(subValue, recursionLevel + 1);
                ++i3;
            }
            this.generator.writeEndArray();
        } else if (value instanceof String) {
            this.generator.writeString(Util.trimString((String)value, this.maxLengthString));
        } else {
            try {
                this.generator.writeObject(value);
            }
            catch (IllegalStateException e2) {
                logger.debug("Couldn't marshal '{}' of type '{}', had to be converted into a String", value, (Object)value.getClass());
                try {
                    this.generator.writeString(Util.trimString(value.toString(), this.maxLengthString));
                }
                catch (Exception innerE) {
                    this.generator.writeString("<exception calling toString on object>");
                }
            }
        }
    }

    private void writeArray(Object value, int recursionLevel) throws IOException {
        if (value instanceof byte[]) {
            byte[] byteArray = (byte[])value;
            for (int i2 = 0; i2 < byteArray.length && i2 < this.maxLengthList; ++i2) {
                this.generator.writeNumber((int)byteArray[i2]);
            }
            if (byteArray.length > this.maxLengthList) {
                this.writeElided();
            }
        } else if (value instanceof short[]) {
            short[] shortArray = (short[])value;
            for (int i3 = 0; i3 < shortArray.length && i3 < this.maxLengthList; ++i3) {
                this.generator.writeNumber((int)shortArray[i3]);
            }
            if (shortArray.length > this.maxLengthList) {
                this.writeElided();
            }
        } else if (value instanceof int[]) {
            int[] intArray = (int[])value;
            for (int i4 = 0; i4 < intArray.length && i4 < this.maxLengthList; ++i4) {
                this.generator.writeNumber(intArray[i4]);
            }
            if (intArray.length > this.maxLengthList) {
                this.writeElided();
            }
        } else if (value instanceof long[]) {
            long[] longArray = (long[])value;
            for (int i5 = 0; i5 < longArray.length && i5 < this.maxLengthList; ++i5) {
                this.generator.writeNumber(longArray[i5]);
            }
            if (longArray.length > this.maxLengthList) {
                this.writeElided();
            }
        } else if (value instanceof float[]) {
            float[] floatArray = (float[])value;
            for (int i6 = 0; i6 < floatArray.length && i6 < this.maxLengthList; ++i6) {
                this.generator.writeNumber(floatArray[i6]);
            }
            if (floatArray.length > this.maxLengthList) {
                this.writeElided();
            }
        } else if (value instanceof double[]) {
            double[] doubleArray = (double[])value;
            for (int i7 = 0; i7 < doubleArray.length && i7 < this.maxLengthList; ++i7) {
                this.generator.writeNumber(doubleArray[i7]);
            }
            if (doubleArray.length > this.maxLengthList) {
                this.writeElided();
            }
        } else if (value instanceof char[]) {
            char[] charArray = (char[])value;
            for (int i8 = 0; i8 < charArray.length && i8 < this.maxLengthList; ++i8) {
                this.generator.writeString(String.valueOf(charArray[i8]));
            }
            if (charArray.length > this.maxLengthList) {
                this.writeElided();
            }
        } else if (value instanceof boolean[]) {
            boolean[] boolArray = (boolean[])value;
            for (int i9 = 0; i9 < boolArray.length && i9 < this.maxLengthList; ++i9) {
                this.generator.writeBoolean(boolArray[i9]);
            }
            if (boolArray.length > this.maxLengthList) {
                this.writeElided();
            }
        } else {
            Object[] objArray = (Object[])value;
            for (int i10 = 0; i10 < objArray.length && i10 < this.maxLengthList; ++i10) {
                this.writeObject(objArray[i10], recursionLevel + 1);
            }
            if (objArray.length > this.maxLengthList) {
                this.writeElided();
            }
        }
    }

    private void writeElided() throws IOException {
        this.generator.writeString(ELIDED);
    }

    public void setMaxLengthList(int maxLengthList) {
        this.maxLengthList = maxLengthList;
    }

    public void setMaxLengthString(int maxLengthString) {
        this.maxLengthString = maxLengthString;
    }

    public void setMaxSizeMap(int maxSizeMap) {
        this.maxSizeMap = maxSizeMap;
    }

    public void setMaxNesting(int maxNesting) {
        this.maxNesting = maxNesting;
    }

    @Override
    public JsonGenerator setCodec(ObjectCodec oc) {
        return this.generator.setCodec(oc);
    }

    @Override
    public ObjectCodec getCodec() {
        return this.generator.getCodec();
    }

    @Override
    public Version version() {
        return this.generator.version();
    }

    @Override
    public JsonGenerator enable(JsonGenerator.Feature f2) {
        return this.generator.enable(f2);
    }

    @Override
    public JsonGenerator disable(JsonGenerator.Feature f2) {
        return this.generator.disable(f2);
    }

    @Override
    public boolean isEnabled(JsonGenerator.Feature f2) {
        return this.generator.isEnabled(f2);
    }

    @Override
    public int getFeatureMask() {
        return this.generator.getFeatureMask();
    }

    @Override
    public JsonGenerator setFeatureMask(int values) {
        return this.generator.setFeatureMask(values);
    }

    @Override
    public JsonGenerator useDefaultPrettyPrinter() {
        return this.generator.useDefaultPrettyPrinter();
    }

    @Override
    public void writeStartArray() throws IOException {
        this.generator.writeStartArray();
    }

    @Override
    public void writeEndArray() throws IOException {
        this.generator.writeEndArray();
    }

    @Override
    public void writeStartObject() throws IOException {
        this.generator.writeStartObject();
    }

    @Override
    public void writeEndObject() throws IOException {
        this.generator.writeEndObject();
    }

    @Override
    public void writeFieldName(String name) throws IOException {
        this.generator.writeFieldName(name);
    }

    @Override
    public void writeFieldName(SerializableString name) throws IOException {
        this.generator.writeFieldName(name);
    }

    @Override
    public void writeString(String text) throws IOException {
        this.generator.writeString(text);
    }

    @Override
    public void writeString(char[] text, int offset, int len) throws IOException {
        this.generator.writeString(text, offset, len);
    }

    @Override
    public void writeString(SerializableString text) throws IOException {
        this.generator.writeString(text);
    }

    @Override
    public void writeRawUTF8String(byte[] text, int offset, int length) throws IOException {
        this.generator.writeRawUTF8String(text, offset, length);
    }

    @Override
    public void writeUTF8String(byte[] text, int offset, int length) throws IOException {
        this.generator.writeUTF8String(text, offset, length);
    }

    @Override
    public void writeRaw(String text) throws IOException {
        this.generator.writeRaw(text);
    }

    @Override
    public void writeRaw(String text, int offset, int len) throws IOException {
        this.generator.writeRaw(text, offset, len);
    }

    @Override
    public void writeRaw(char[] text, int offset, int len) throws IOException {
        this.generator.writeRaw(text, offset, len);
    }

    @Override
    public void writeRaw(char c2) throws IOException {
        this.generator.writeRaw(c2);
    }

    @Override
    public void writeRawValue(String text) throws IOException {
        this.generator.writeRawValue(text);
    }

    @Override
    public void writeRawValue(String text, int offset, int len) throws IOException {
        this.generator.writeRawValue(text, offset, len);
    }

    @Override
    public void writeRawValue(char[] text, int offset, int len) throws IOException {
        this.generator.writeRawValue(text, offset, len);
    }

    @Override
    public void writeBinary(Base64Variant bv, byte[] data, int offset, int len) throws IOException {
        this.generator.writeBinary(bv, data, offset, len);
    }

    @Override
    public int writeBinary(Base64Variant bv, InputStream data, int dataLength) throws IOException {
        return this.generator.writeBinary(bv, data, dataLength);
    }

    @Override
    public void writeNumber(int v2) throws IOException {
        this.generator.writeNumber(v2);
    }

    @Override
    public void writeNumber(long v2) throws IOException {
        this.generator.writeNumber(v2);
    }

    @Override
    public void writeNumber(BigInteger v2) throws IOException {
        this.generator.writeNumber(v2);
    }

    @Override
    public void writeNumber(double v2) throws IOException {
        this.generator.writeNumber(v2);
    }

    @Override
    public void writeNumber(float v2) throws IOException {
        this.generator.writeNumber(v2);
    }

    @Override
    public void writeNumber(BigDecimal v2) throws IOException {
        this.generator.writeNumber(v2);
    }

    @Override
    public void writeNumber(String encodedValue) throws IOException {
        this.generator.writeNumber(encodedValue);
    }

    @Override
    public void writeBoolean(boolean state) throws IOException {
        this.generator.writeBoolean(state);
    }

    @Override
    public void writeNull() throws IOException {
        this.generator.writeNull();
    }

    @Override
    public void writeTree(TreeNode rootNode) throws IOException {
        this.generator.writeTree(rootNode);
    }

    @Override
    public JsonStreamContext getOutputContext() {
        return this.generator.getOutputContext();
    }

    @Override
    public void flush() throws IOException {
        this.generator.flush();
    }

    @Override
    public boolean isClosed() {
        return this.generator.isClosed();
    }

    @Override
    public void close() throws IOException {
        this.generator.close();
    }
}

