/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.collections.NonIterableChange;
import com.sun.javafx.scene.control.MultipleAdditionAndRemovedChange;
import com.sun.javafx.scene.control.ReadOnlyUnbackedObservableList;
import com.sun.javafx.scene.control.SelectedItemsReadOnlyObservableList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableListBase;
import javafx.scene.control.ControlUtils;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionMode;
import javafx.util.Callback;
import javafx.util.Pair;

abstract class MultipleSelectionModelBase<T>
extends MultipleSelectionModel<T> {
    final SelectedIndicesList selectedIndices;
    private final ObservableListBase<T> selectedItems;
    ListChangeListener.Change selectedItemChange;

    public MultipleSelectionModelBase() {
        this.selectedIndexProperty().addListener(observable -> this.setSelectedItem(this.getModelItem(this.getSelectedIndex())));
        this.selectedIndices = new SelectedIndicesList();
        this.selectedItems = new SelectedItemsReadOnlyObservableList<T>(this.selectedIndices, () -> this.getItemCount()){

            @Override
            protected T getModelItem(int n2) {
                return MultipleSelectionModelBase.this.getModelItem(n2);
            }
        };
    }

    @Override
    public ObservableList<Integer> getSelectedIndices() {
        return this.selectedIndices;
    }

    @Override
    public ObservableList<T> getSelectedItems() {
        return this.selectedItems;
    }

    protected abstract int getItemCount();

    protected abstract T getModelItem(int var1);

    protected abstract void focus(int var1);

    protected abstract int getFocusedIndex();

    void shiftSelection(int n2, int n3, Callback<ShiftParams, Void> callback) {
        this.shiftSelection(Arrays.asList(new Pair<Integer, Integer>(n2, n3)), callback);
    }

    void shiftSelection(List<Pair<Integer, Integer>> list, Callback<ShiftParams, Void> callback) {
        int n3 = this.selectedIndices.size();
        if (n3 == 0) {
            return;
        }
        int n4 = this.selectedIndices.bitsetSize();
        int[] nArray = new int[n4];
        Arrays.fill(nArray, -1);
        Collections.sort(list, (pair, pair2) -> Integer.compare((Integer)pair2.getKey(), (Integer)pair.getKey()));
        int n5 = list.get(list.size() - 1).getKey();
        BitSet bitSet = (BitSet)this.selectedIndices.bitset.clone();
        this.startAtomic();
        for (Pair<Integer, Integer> pair3 : list) {
            this.doShift(pair3, callback, nArray);
        }
        this.stopAtomic();
        Object object = Arrays.stream(nArray).filter(n2 -> n2 > -1).toArray();
        boolean bl = ((Object)object).length > 0;
        int n6 = this.getSelectedIndex();
        if (n6 >= n5 && n6 > -1) {
            int n7 = list.stream().filter(pair -> (Integer)pair.getKey() <= n6).mapToInt(pair -> (Integer)pair.getValue()).sum();
            int n8 = Math.max(0, n6 + n7);
            this.setSelectedIndex(n8);
            if (bl) {
                this.selectedIndices.set(n8, true);
            } else {
                this.select(n8);
            }
        }
        if (bl) {
            BitSet bitSet2 = (BitSet)bitSet.clone();
            bitSet2.andNot(this.selectedIndices.bitset);
            BitSet bitSet3 = (BitSet)this.selectedIndices.bitset.clone();
            bitSet3.andNot(bitSet);
            this.selectedIndices.reset();
            this.selectedIndices.callObservers(new MultipleAdditionAndRemovedChange<Integer>(bitSet3.stream().boxed().collect(Collectors.toList()), bitSet2.stream().boxed().collect(Collectors.toList()), this.selectedIndices));
        }
    }

    private void doShift(Pair<Integer, Integer> pair, Callback<ShiftParams, Void> callback, int[] nArray) {
        int n3 = pair.getKey();
        int n4 = pair.getValue();
        if (n3 < 0) {
            return;
        }
        if (n4 == 0) {
            return;
        }
        int n5 = (int)Arrays.stream(nArray).filter(n2 -> n2 > -1).count();
        int n6 = this.selectedIndices.bitsetSize() - n5;
        if (n4 > 0) {
            for (int i2 = n6 - 1; i2 >= n3 && i2 >= 0; --i2) {
                boolean bl = this.selectedIndices.isSelected(i2);
                if (callback == null) {
                    this.selectedIndices.clear(i2);
                    this.selectedIndices.set(i2 + n4, bl);
                } else {
                    callback.call(new ShiftParams(i2, i2 + n4, bl));
                }
                if (!bl) continue;
                nArray[n5++] = i2 + 1;
            }
            this.selectedIndices.clear(n3);
        } else if (n4 < 0) {
            for (int i3 = n3; i3 < n6; ++i3) {
                if (i3 + n4 < 0 || i3 + 1 + n4 < n3) continue;
                boolean bl = this.selectedIndices.isSelected(i3 + 1);
                if (callback == null) {
                    this.selectedIndices.clear(i3 + 1);
                    this.selectedIndices.set(i3 + 1 + n4, bl);
                } else {
                    callback.call(new ShiftParams(i3 + 1, i3 + 1 + n4, bl));
                }
                if (!bl) continue;
                nArray[n5++] = i3;
            }
        }
    }

    void startAtomic() {
        this.selectedIndices.startAtomic();
    }

    void stopAtomic() {
        this.selectedIndices.stopAtomic();
    }

    boolean isAtomic() {
        return this.selectedIndices.isAtomic();
    }

    @Override
    public void clearAndSelect(int n2) {
        ListChangeListener.Change<Integer> change;
        if (n2 < 0 || n2 >= this.getItemCount()) {
            this.clearSelection();
            return;
        }
        boolean bl = this.isSelected(n2);
        if (bl && this.getSelectedIndices().size() == 1 && this.getSelectedItem() == this.getModelItem(n2)) {
            return;
        }
        BitSet bitSet = new BitSet();
        bitSet.or(this.selectedIndices.bitset);
        bitSet.clear(n2);
        SelectedIndicesList selectedIndicesList = new SelectedIndicesList(bitSet);
        this.startAtomic();
        this.clearSelection();
        this.select(n2);
        this.stopAtomic();
        if (bl) {
            change = ControlUtils.buildClearAndSelectChange(this.selectedIndices, selectedIndicesList, n2);
        } else {
            int n3 = Math.max(0, this.selectedIndices.indexOf(n2));
            change = new NonIterableChange.GenericAddRemoveChange<Integer>(n3, n3 + 1, selectedIndicesList, this.selectedIndices);
        }
        this.selectedIndices.callObservers(change);
    }

    @Override
    public void select(int n2) {
        if (n2 == -1) {
            this.clearSelection();
            return;
        }
        if (n2 < 0 || n2 >= this.getItemCount()) {
            return;
        }
        boolean bl = n2 == this.getSelectedIndex();
        Object t2 = this.getSelectedItem();
        T t3 = this.getModelItem(n2);
        boolean bl2 = t3 != null && t3.equals(t2);
        boolean bl3 = bl && !bl2;
        this.focus(n2);
        if (!this.selectedIndices.isSelected(n2)) {
            if (this.getSelectionMode() == SelectionMode.SINGLE) {
                this.startAtomic();
                this.quietClearSelection();
                this.stopAtomic();
            }
            this.selectedIndices.set(n2);
        }
        this.setSelectedIndex(n2);
        if (bl3) {
            this.setSelectedItem(t3);
        }
    }

    @Override
    public void select(T t2) {
        if (t2 == null && this.getSelectionMode() == SelectionMode.SINGLE) {
            this.clearSelection();
            return;
        }
        Object object = null;
        int n2 = this.getItemCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            object = this.getModelItem(i2);
            if (object == null || !object.equals(t2)) continue;
            if (this.isSelected(i2)) {
                return;
            }
            if (this.getSelectionMode() == SelectionMode.SINGLE) {
                this.quietClearSelection();
            }
            this.select(i2);
            return;
        }
        this.setSelectedIndex(-1);
        this.setSelectedItem(t2);
    }

    @Override
    public void selectIndices(int n4, int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            this.select(n4);
            return;
        }
        int n5 = this.getItemCount();
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            this.quietClearSelection();
            for (int i2 = nArray.length - 1; i2 >= 0; --i2) {
                int n6 = nArray[i2];
                if (n6 < 0 || n6 >= n5) continue;
                this.selectedIndices.set(n6);
                this.select(n6);
                break;
            }
            if (this.selectedIndices.isEmpty() && n4 > 0 && n4 < n5) {
                this.selectedIndices.set(n4);
                this.select(n4);
            }
        } else {
            this.selectedIndices.set(n4, nArray);
            IntStream.concat(IntStream.of(n4), IntStream.of(nArray)).filter(n3 -> n3 >= 0 && n3 < n5).reduce((n2, n3) -> n3).ifPresent(n2 -> {
                this.setSelectedIndex(n2);
                this.focus(n2);
                this.setSelectedItem(this.getModelItem(n2));
            });
        }
    }

    @Override
    public void selectAll() {
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            return;
        }
        if (this.getItemCount() <= 0) {
            return;
        }
        int n2 = this.getItemCount();
        int n3 = this.getFocusedIndex();
        this.clearSelection();
        this.selectedIndices.set(0, n2, true);
        if (n3 == -1) {
            this.setSelectedIndex(n2 - 1);
            this.focus(n2 - 1);
        } else {
            this.setSelectedIndex(n3);
            this.focus(n3);
        }
    }

    @Override
    public void selectFirst() {
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            this.quietClearSelection();
        }
        if (this.getItemCount() > 0) {
            this.select(0);
        }
    }

    @Override
    public void selectLast() {
        int n2;
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            this.quietClearSelection();
        }
        if ((n2 = this.getItemCount()) > 0 && this.getSelectedIndex() < n2 - 1) {
            this.select(n2 - 1);
        }
    }

    @Override
    public void clearSelection(int n2) {
        if (n2 < 0) {
            return;
        }
        boolean bl = this.selectedIndices.isEmpty();
        this.selectedIndices.clear(n2);
        if (!bl && this.selectedIndices.isEmpty()) {
            this.clearSelection();
        }
    }

    @Override
    public void clearSelection() {
        this.quietClearSelection();
        if (!this.isAtomic()) {
            this.setSelectedIndex(-1);
            this.focus(-1);
        }
    }

    private void quietClearSelection() {
        this.selectedIndices.clear();
    }

    @Override
    public boolean isSelected(int n2) {
        if (n2 >= 0 && n2 < this.selectedIndices.bitsetSize()) {
            return this.selectedIndices.isSelected(n2);
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.selectedIndices.isEmpty();
    }

    @Override
    public void selectPrevious() {
        int n2 = this.getFocusedIndex();
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            this.quietClearSelection();
        }
        if (n2 == -1) {
            this.select(this.getItemCount() - 1);
        } else if (n2 > 0) {
            this.select(n2 - 1);
        }
    }

    @Override
    public void selectNext() {
        int n2 = this.getFocusedIndex();
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            this.quietClearSelection();
        }
        if (n2 == -1) {
            this.select(0);
        } else if (n2 != this.getItemCount() - 1) {
            this.select(n2 + 1);
        }
    }

    class SelectedIndicesList
    extends ReadOnlyUnbackedObservableList<Integer> {
        private final BitSet bitset;
        private int lastGetIndex = -1;
        private int lastGetValue = -1;
        private int atomicityCount = 0;

        public SelectedIndicesList() {
            this(new BitSet());
        }

        public SelectedIndicesList(BitSet bitSet) {
            this.bitset = bitSet;
        }

        boolean isAtomic() {
            return this.atomicityCount > 0;
        }

        void startAtomic() {
            ++this.atomicityCount;
        }

        void stopAtomic() {
            this.atomicityCount = Math.max(0, this.atomicityCount - 1);
        }

        @Override
        public Integer get(int n2) {
            int n3 = this.size();
            if (n2 < 0 || n2 >= n3) {
                throw new IndexOutOfBoundsException(n2 + " >= " + n3);
            }
            if (n2 == this.lastGetIndex + 1 && this.lastGetValue < n3) {
                ++this.lastGetIndex;
                this.lastGetValue = this.bitset.nextSetBit(this.lastGetValue + 1);
                return this.lastGetValue;
            }
            if (n2 == this.lastGetIndex - 1 && this.lastGetValue > 0) {
                --this.lastGetIndex;
                this.lastGetValue = this.bitset.previousSetBit(this.lastGetValue - 1);
                return this.lastGetValue;
            }
            this.lastGetIndex = 0;
            this.lastGetValue = this.bitset.nextSetBit(0);
            while (this.lastGetValue >= 0 || this.lastGetIndex == n2) {
                if (this.lastGetIndex == n2) {
                    return this.lastGetValue;
                }
                ++this.lastGetIndex;
                this.lastGetValue = this.bitset.nextSetBit(this.lastGetValue + 1);
            }
            return -1;
        }

        public void set(int n2) {
            if (!this.isValidIndex(n2) || this.isSelected(n2)) {
                return;
            }
            this._beginChange();
            this.bitset.set(n2);
            int n3 = this.indexOf(n2);
            this._nextAdd(n3, n3 + 1);
            this._endChange();
        }

        private boolean isValidIndex(int n2) {
            return n2 >= 0 && n2 < MultipleSelectionModelBase.this.getItemCount();
        }

        @Override
        public void set(int n2, boolean bl) {
            if (bl) {
                this.set(n2);
            } else {
                this.clear(n2);
            }
        }

        public void set(int n2, int n3, boolean bl) {
            this._beginChange();
            if (bl) {
                this.bitset.set(n2, n3, bl);
                int n4 = this.indexOf(n2);
                int n5 = n3 - n2;
                this._nextAdd(n4, n4 + n5);
            } else {
                this.bitset.set(n2, n3, bl);
            }
            this._endChange();
        }

        @Override
        public void set(int n2, int ... nArray) {
            if (nArray == null || nArray.length == 0) {
                this.set(n2);
            } else {
                this.startAtomic();
                List list = IntStream.concat(IntStream.of(n2), IntStream.of(nArray)).distinct().filter(this::isValidIndex).filter(this::isNotSelected).sorted().boxed().peek(this::set).collect(Collectors.toList());
                this.stopAtomic();
                int n3 = list.size();
                if (n3 != 0) {
                    if (n3 == 1) {
                        this._beginChange();
                        int n4 = (Integer)list.get(0);
                        int n5 = this.indexOf(n4);
                        this._nextAdd(n5, n5 + 1);
                        this._endChange();
                    } else {
                        this._beginChange();
                        int n6 = 0;
                        int n7 = 0;
                        int n8 = 0;
                        int n9 = (Integer)list.get(n6++);
                        n7 = this.indexOf(n9);
                        n8 = n7 + 1;
                        int n10 = n9;
                        while (n6 < n3) {
                            int n11 = n10;
                            n10 = (Integer)list.get(n6++);
                            ++n8;
                            if (n11 != n10 - 1) {
                                this._nextAdd(n7, n8);
                                n7 = n8;
                                continue;
                            }
                            if (n6 != n3) continue;
                            this._nextAdd(n7, n7 + n6);
                        }
                        this._endChange();
                    }
                }
            }
        }

        @Override
        public void clear() {
            this._beginChange();
            List list = this.bitset.stream().boxed().collect(Collectors.toList());
            this.bitset.clear();
            this._nextRemove(0, list);
            this._endChange();
        }

        public void clear(int n2) {
            if (!this.bitset.get(n2)) {
                return;
            }
            this._beginChange();
            this.bitset.clear(n2);
            this._nextRemove(n2, n2);
            this._endChange();
        }

        public boolean isSelected(int n2) {
            return this.bitset.get(n2);
        }

        public boolean isNotSelected(int n2) {
            return !this.isSelected(n2);
        }

        @Override
        public int size() {
            return this.bitset.cardinality();
        }

        public int bitsetSize() {
            return this.bitset.size();
        }

        @Override
        public int indexOf(Object object) {
            this.reset();
            return super.indexOf(object);
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof Number) {
                Number number = (Number)object;
                int n2 = number.intValue();
                return n2 >= 0 && n2 < this.bitset.length() && this.bitset.get(n2);
            }
            return false;
        }

        public void reset() {
            this.lastGetIndex = -1;
            this.lastGetValue = -1;
        }

        @Override
        public void _beginChange() {
            if (!this.isAtomic()) {
                super._beginChange();
            }
        }

        @Override
        public void _endChange() {
            if (!this.isAtomic()) {
                super._endChange();
            }
        }

        @Override
        public final void _nextUpdate(int n2) {
            if (!this.isAtomic()) {
                this.nextUpdate(n2);
            }
        }

        @Override
        public final void _nextSet(int n2, Integer n3) {
            if (!this.isAtomic()) {
                this.nextSet(n2, n3);
            }
        }

        @Override
        public final void _nextReplace(int n2, int n3, List<? extends Integer> list) {
            if (!this.isAtomic()) {
                this.nextReplace(n2, n3, list);
            }
        }

        @Override
        public final void _nextRemove(int n2, List<? extends Integer> list) {
            if (!this.isAtomic()) {
                this.nextRemove(n2, list);
            }
        }

        @Override
        public final void _nextRemove(int n2, Integer n3) {
            if (!this.isAtomic()) {
                this.nextRemove(n2, n3);
            }
        }

        @Override
        public final void _nextPermutation(int n2, int n3, int[] nArray) {
            if (!this.isAtomic()) {
                this.nextPermutation(n2, n3, nArray);
            }
        }

        @Override
        public final void _nextAdd(int n2, int n3) {
            if (!this.isAtomic()) {
                this.nextAdd(n2, n3);
            }
        }
    }

    static class ShiftParams {
        private final int clearIndex;
        private final int setIndex;
        private final boolean selected;

        ShiftParams(int n2, int n3, boolean bl) {
            this.clearIndex = n2;
            this.setIndex = n3;
            this.selected = bl;
        }

        public final int getClearIndex() {
            return this.clearIndex;
        }

        public final int getSetIndex() {
            return this.setIndex;
        }

        public final boolean isSelected() {
            return this.selected;
        }
    }
}

