/*
 * Decompiled with CFR 0.152.
 */
package org.abego.treelayout;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.PrintStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.abego.treelayout.Configuration;
import org.abego.treelayout.NodeExtentProvider;
import org.abego.treelayout.TreeForTreeLayout;
import org.abego.treelayout.internal.util.Contract;
import org.abego.treelayout.internal.util.java.lang.string.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeLayout<TreeNode> {
    private final TreeForTreeLayout<TreeNode> tree;
    private final NodeExtentProvider<TreeNode> nodeExtentProvider;
    private final Configuration<TreeNode> configuration;
    private double boundsLeft = Double.MAX_VALUE;
    private double boundsRight = Double.MIN_VALUE;
    private double boundsTop = Double.MAX_VALUE;
    private double boundsBottom = Double.MIN_VALUE;
    private final List<Double> sizeOfLevel = new ArrayList<Double>();
    private final boolean useIdentity;
    private final Map<TreeNode, Double> mod;
    private final Map<TreeNode, TreeNode> thread;
    private final Map<TreeNode, Double> prelim;
    private final Map<TreeNode, Double> change;
    private final Map<TreeNode, Double> shift;
    private final Map<TreeNode, TreeNode> ancestor;
    private final Map<TreeNode, Integer> number;
    private final Map<TreeNode, Point2D> positions;
    private Map<TreeNode, Rectangle2D.Double> nodeBounds;

    public TreeForTreeLayout<TreeNode> getTree() {
        return this.tree;
    }

    public NodeExtentProvider<TreeNode> getNodeExtentProvider() {
        return this.nodeExtentProvider;
    }

    private double getNodeHeight(TreeNode node) {
        return this.nodeExtentProvider.getHeight(node);
    }

    private double getNodeWidth(TreeNode node) {
        return this.nodeExtentProvider.getWidth(node);
    }

    private double getWidthOrHeightOfNode(TreeNode treeNode, boolean returnWidth) {
        return returnWidth ? this.getNodeWidth(treeNode) : this.getNodeHeight(treeNode);
    }

    private double getNodeThickness(TreeNode treeNode) {
        return this.getWidthOrHeightOfNode(treeNode, !this.isLevelChangeInYAxis());
    }

    private double getNodeSize(TreeNode treeNode) {
        return this.getWidthOrHeightOfNode(treeNode, this.isLevelChangeInYAxis());
    }

    public Configuration<TreeNode> getConfiguration() {
        return this.configuration;
    }

    private boolean isLevelChangeInYAxis() {
        Configuration.Location rootLocation = this.configuration.getRootLocation();
        return rootLocation == Configuration.Location.Top || rootLocation == Configuration.Location.Bottom;
    }

    private int getLevelChangeSign() {
        Configuration.Location rootLocation = this.configuration.getRootLocation();
        return rootLocation == Configuration.Location.Bottom || rootLocation == Configuration.Location.Right ? -1 : 1;
    }

    private void updateBounds(TreeNode node, double centerX, double centerY) {
        double width = this.getNodeWidth(node);
        double height = this.getNodeHeight(node);
        double left = centerX - width / 2.0;
        double right = centerX + width / 2.0;
        double top = centerY - height / 2.0;
        double bottom = centerY + height / 2.0;
        if (this.boundsLeft > left) {
            this.boundsLeft = left;
        }
        if (this.boundsRight < right) {
            this.boundsRight = right;
        }
        if (this.boundsTop > top) {
            this.boundsTop = top;
        }
        if (this.boundsBottom < bottom) {
            this.boundsBottom = bottom;
        }
    }

    public Rectangle2D getBounds() {
        return new Rectangle2D.Double(0.0, 0.0, this.boundsRight - this.boundsLeft, this.boundsBottom - this.boundsTop);
    }

    private void calcSizeOfLevels(TreeNode node, int level) {
        double oldSize;
        if (this.sizeOfLevel.size() <= level) {
            this.sizeOfLevel.add(0.0);
            oldSize = 0.0;
        } else {
            oldSize = this.sizeOfLevel.get(level);
        }
        double size = this.getNodeThickness(node);
        if (oldSize < size) {
            this.sizeOfLevel.set(level, size);
        }
        if (!this.tree.isLeaf(node)) {
            for (TreeNode child : this.tree.getChildren(node)) {
                this.calcSizeOfLevels(child, level + 1);
            }
        }
    }

    public int getLevelCount() {
        return this.sizeOfLevel.size();
    }

    public double getSizeOfLevel(int level) {
        Contract.checkArg(level >= 0, "level must be >= 0");
        Contract.checkArg(level < this.getLevelCount(), "level must be < levelCount");
        return this.sizeOfLevel.get(level);
    }

    private double getMod(TreeNode node) {
        Double d2 = this.mod.get(node);
        return d2 != null ? d2 : 0.0;
    }

    private void setMod(TreeNode node, double d2) {
        this.mod.put(node, d2);
    }

    private TreeNode getThread(TreeNode node) {
        TreeNode n2 = this.thread.get(node);
        return (TreeNode)(n2 != null ? n2 : null);
    }

    private void setThread(TreeNode node, TreeNode thread) {
        this.thread.put(node, thread);
    }

    private TreeNode getAncestor(TreeNode node) {
        TreeNode n2 = this.ancestor.get(node);
        return n2 != null ? n2 : node;
    }

    private void setAncestor(TreeNode node, TreeNode ancestor) {
        this.ancestor.put(node, ancestor);
    }

    private double getPrelim(TreeNode node) {
        Double d2 = this.prelim.get(node);
        return d2 != null ? d2 : 0.0;
    }

    private void setPrelim(TreeNode node, double d2) {
        this.prelim.put(node, d2);
    }

    private double getChange(TreeNode node) {
        Double d2 = this.change.get(node);
        return d2 != null ? d2 : 0.0;
    }

    private void setChange(TreeNode node, double d2) {
        this.change.put(node, d2);
    }

    private double getShift(TreeNode node) {
        Double d2 = this.shift.get(node);
        return d2 != null ? d2 : 0.0;
    }

    private void setShift(TreeNode node, double d2) {
        this.shift.put(node, d2);
    }

    private double getDistance(TreeNode v2, TreeNode w2) {
        double sizeOfNodes = this.getNodeSize(v2) + this.getNodeSize(w2);
        double distance = sizeOfNodes / 2.0 + this.configuration.getGapBetweenNodes(v2, w2);
        return distance;
    }

    private TreeNode nextLeft(TreeNode v2) {
        return this.tree.isLeaf(v2) ? this.getThread(v2) : this.tree.getFirstChild(v2);
    }

    private TreeNode nextRight(TreeNode v2) {
        return this.tree.isLeaf(v2) ? this.getThread(v2) : this.tree.getLastChild(v2);
    }

    private int getNumber(TreeNode node, TreeNode parentNode) {
        Integer n2 = this.number.get(node);
        if (n2 == null) {
            int i2 = 1;
            for (TreeNode child : this.tree.getChildren(parentNode)) {
                this.number.put(child, i2++);
            }
            n2 = this.number.get(node);
        }
        return n2;
    }

    private TreeNode ancestor(TreeNode vIMinus, TreeNode v2, TreeNode parentOfV, TreeNode defaultAncestor) {
        TreeNode ancestor = this.getAncestor(vIMinus);
        return this.tree.isChildOfParent(ancestor, parentOfV) ? ancestor : defaultAncestor;
    }

    private void moveSubtree(TreeNode wMinus, TreeNode wPlus, TreeNode parent, double shift) {
        int subtrees = this.getNumber(wPlus, parent) - this.getNumber(wMinus, parent);
        this.setChange(wPlus, this.getChange(wPlus) - shift / (double)subtrees);
        this.setShift(wPlus, this.getShift(wPlus) + shift);
        this.setChange(wMinus, this.getChange(wMinus) + shift / (double)subtrees);
        this.setPrelim(wPlus, this.getPrelim(wPlus) + shift);
        this.setMod(wPlus, this.getMod(wPlus) + shift);
    }

    private TreeNode apportion(TreeNode v2, TreeNode defaultAncestor, TreeNode leftSibling, TreeNode parentOfV) {
        TreeNode w2 = leftSibling;
        if (w2 == null) {
            return defaultAncestor;
        }
        TreeNode vOPlus = v2;
        TreeNode vIPlus = v2;
        TreeNode vIMinus = w2;
        TreeNode vOMinus = this.tree.getFirstChild(parentOfV);
        Double sIPlus = this.getMod(vIPlus);
        Double sOPlus = this.getMod(vOPlus);
        Double sIMinus = this.getMod(vIMinus);
        Double sOMinus = this.getMod(vOMinus);
        TreeNode nextRightVIMinus = this.nextRight(vIMinus);
        TreeNode nextLeftVIPlus = this.nextLeft(vIPlus);
        while (nextRightVIMinus != null && nextLeftVIPlus != null) {
            vIMinus = nextRightVIMinus;
            vIPlus = nextLeftVIPlus;
            vOMinus = this.nextLeft(vOMinus);
            vOPlus = this.nextRight(vOPlus);
            this.setAncestor(vOPlus, v2);
            double shift = this.getPrelim(vIMinus) + sIMinus - (this.getPrelim(vIPlus) + sIPlus) + this.getDistance(vIMinus, vIPlus);
            if (shift > 0.0) {
                this.moveSubtree(this.ancestor(vIMinus, v2, parentOfV, defaultAncestor), v2, parentOfV, shift);
                sIPlus = sIPlus + shift;
                sOPlus = sOPlus + shift;
            }
            sIMinus = sIMinus + this.getMod(vIMinus);
            sIPlus = sIPlus + this.getMod(vIPlus);
            sOMinus = sOMinus + this.getMod(vOMinus);
            sOPlus = sOPlus + this.getMod(vOPlus);
            nextRightVIMinus = this.nextRight(vIMinus);
            nextLeftVIPlus = this.nextLeft(vIPlus);
        }
        if (nextRightVIMinus != null && this.nextRight(vOPlus) == null) {
            this.setThread(vOPlus, nextRightVIMinus);
            this.setMod(vOPlus, this.getMod(vOPlus) + sIMinus - sOPlus);
        }
        if (nextLeftVIPlus != null && this.nextLeft(vOMinus) == null) {
            this.setThread(vOMinus, nextLeftVIPlus);
            this.setMod(vOMinus, this.getMod(vOMinus) + sIPlus - sOMinus);
            defaultAncestor = v2;
        }
        return defaultAncestor;
    }

    private void executeShifts(TreeNode v2) {
        double shift = 0.0;
        double change = 0.0;
        for (TreeNode w2 : this.tree.getChildrenReverse(v2)) {
            this.setPrelim(w2, this.getPrelim(w2) + shift);
            this.setMod(w2, this.getMod(w2) + shift);
            shift = shift + this.getShift(w2) + (change += this.getChange(w2));
        }
    }

    private void firstWalk(TreeNode v2, TreeNode leftSibling) {
        if (this.tree.isLeaf(v2)) {
            TreeNode w2 = leftSibling;
            if (w2 != null) {
                this.setPrelim(v2, this.getPrelim(w2) + this.getDistance(v2, w2));
            }
        } else {
            TreeNode defaultAncestor = this.tree.getFirstChild(v2);
            TreeNode previousChild = null;
            for (TreeNode w3 : this.tree.getChildren(v2)) {
                this.firstWalk(w3, previousChild);
                defaultAncestor = this.apportion(w3, defaultAncestor, previousChild, v2);
                previousChild = w3;
            }
            this.executeShifts(v2);
            double midpoint = (this.getPrelim(this.tree.getFirstChild(v2)) + this.getPrelim(this.tree.getLastChild(v2))) / 2.0;
            TreeNode w4 = leftSibling;
            if (w4 != null) {
                this.setPrelim(v2, this.getPrelim(w4) + this.getDistance(v2, w4));
                this.setMod(v2, this.getPrelim(v2) - midpoint);
            } else {
                this.setPrelim(v2, midpoint);
            }
        }
    }

    private void secondWalk(TreeNode v2, double m3, int level, double levelStart) {
        double levelChangeSign = this.getLevelChangeSign();
        boolean levelChangeOnYAxis = this.isLevelChangeInYAxis();
        double levelSize = this.getSizeOfLevel(level);
        double x2 = this.getPrelim(v2) + m3;
        Configuration.AlignmentInLevel alignment = this.configuration.getAlignmentInLevel();
        double y2 = alignment == Configuration.AlignmentInLevel.Center ? levelStart + levelChangeSign * (levelSize / 2.0) : (alignment == Configuration.AlignmentInLevel.TowardsRoot ? levelStart + levelChangeSign * (this.getNodeThickness(v2) / 2.0) : levelStart + levelSize - levelChangeSign * (this.getNodeThickness(v2) / 2.0));
        if (!levelChangeOnYAxis) {
            double t2 = x2;
            x2 = y2;
            y2 = t2;
        }
        this.positions.put(v2, new NormalizedPosition(x2, y2));
        this.updateBounds(v2, x2, y2);
        if (!this.tree.isLeaf(v2)) {
            double nextLevelStart = levelStart + (levelSize + this.configuration.getGapBetweenLevels(level + 1)) * levelChangeSign;
            for (TreeNode w2 : this.tree.getChildren(v2)) {
                this.secondWalk(w2, m3 + this.getMod(v2), level + 1, nextLevelStart);
            }
        }
    }

    public Map<TreeNode, Rectangle2D.Double> getNodeBounds() {
        if (this.nodeBounds == null) {
            this.nodeBounds = this.useIdentity ? new IdentityHashMap() : new HashMap();
            for (Map.Entry<TreeNode, Point2D> entry : this.positions.entrySet()) {
                TreeNode node = entry.getKey();
                Point2D pos = entry.getValue();
                double w2 = this.getNodeWidth(node);
                double h2 = this.getNodeHeight(node);
                double x2 = pos.getX() - w2 / 2.0;
                double y2 = pos.getY() - h2 / 2.0;
                this.nodeBounds.put(node, new Rectangle2D.Double(x2, y2, w2, h2));
            }
        }
        return this.nodeBounds;
    }

    public TreeLayout(TreeForTreeLayout<TreeNode> tree, NodeExtentProvider<TreeNode> nodeExtentProvider, Configuration<TreeNode> configuration, boolean useIdentity) {
        this.tree = tree;
        this.nodeExtentProvider = nodeExtentProvider;
        this.configuration = configuration;
        this.useIdentity = useIdentity;
        if (this.useIdentity) {
            this.mod = new IdentityHashMap<TreeNode, Double>();
            this.thread = new IdentityHashMap<TreeNode, TreeNode>();
            this.prelim = new IdentityHashMap<TreeNode, Double>();
            this.change = new IdentityHashMap<TreeNode, Double>();
            this.shift = new IdentityHashMap<TreeNode, Double>();
            this.ancestor = new IdentityHashMap<TreeNode, TreeNode>();
            this.number = new IdentityHashMap<TreeNode, Integer>();
            this.positions = new IdentityHashMap<TreeNode, Point2D>();
        } else {
            this.mod = new HashMap<TreeNode, Double>();
            this.thread = new HashMap<TreeNode, TreeNode>();
            this.prelim = new HashMap<TreeNode, Double>();
            this.change = new HashMap<TreeNode, Double>();
            this.shift = new HashMap<TreeNode, Double>();
            this.ancestor = new HashMap<TreeNode, TreeNode>();
            this.number = new HashMap<TreeNode, Integer>();
            this.positions = new HashMap<TreeNode, Point2D>();
        }
        TreeNode r2 = tree.getRoot();
        this.firstWalk(r2, null);
        this.calcSizeOfLevels(r2, 0);
        this.secondWalk(r2, -this.getPrelim(r2), 0, 0.0);
    }

    public TreeLayout(TreeForTreeLayout<TreeNode> tree, NodeExtentProvider<TreeNode> nodeExtentProvider, Configuration<TreeNode> configuration) {
        this(tree, nodeExtentProvider, configuration, false);
    }

    private void addUniqueNodes(Map<TreeNode, TreeNode> nodes, TreeNode newNode) {
        if (nodes.put(newNode, newNode) != null) {
            throw new RuntimeException(String.format("Node used more than once in tree: %s", newNode));
        }
        for (TreeNode n2 : this.tree.getChildren(newNode)) {
            this.addUniqueNodes(nodes, n2);
        }
    }

    public void checkTree() {
        AbstractMap nodes = this.useIdentity ? new IdentityHashMap() : new HashMap();
        this.addUniqueNodes(nodes, this.tree.getRoot());
    }

    private void dumpTree(PrintStream output, TreeNode node, int indent, DumpConfiguration dumpConfiguration) {
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < indent; ++i2) {
            sb.append(dumpConfiguration.indent);
        }
        if (dumpConfiguration.includeObjectToString) {
            sb.append("[");
            sb.append(node.getClass().getName() + "@" + Integer.toHexString(node.hashCode()));
            if (node.hashCode() != System.identityHashCode(node)) {
                sb.append("/identityHashCode:");
                sb.append(Integer.toHexString(System.identityHashCode(node)));
            }
            sb.append("]");
        }
        sb.append(StringUtil.quote(node != null ? node.toString() : null));
        if (dumpConfiguration.includeNodeSize) {
            sb.append(" (size: ");
            sb.append(this.getNodeWidth(node));
            sb.append("x");
            sb.append(this.getNodeHeight(node));
            sb.append(")");
        }
        output.println(sb.toString());
        for (TreeNode n2 : this.tree.getChildren(node)) {
            this.dumpTree(output, n2, indent + 1, dumpConfiguration);
        }
    }

    public void dumpTree(PrintStream printStream, DumpConfiguration dumpConfiguration) {
        this.dumpTree(printStream, this.tree.getRoot(), 0, dumpConfiguration);
    }

    public void dumpTree(PrintStream printStream) {
        this.dumpTree(printStream, new DumpConfiguration());
    }

    public static class DumpConfiguration {
        public final String indent;
        public final boolean includeNodeSize;
        public final boolean includeObjectToString;

        public DumpConfiguration(String indent, boolean includeNodeSize, boolean includePointer) {
            this.indent = indent;
            this.includeNodeSize = includeNodeSize;
            this.includeObjectToString = includePointer;
        }

        public DumpConfiguration() {
            this("    ", false, false);
        }
    }

    private class NormalizedPosition
    extends Point2D {
        private double x_relativeToRoot;
        private double y_relativeToRoot;

        public NormalizedPosition(double x_relativeToRoot, double y_relativeToRoot) {
            this.setLocation(x_relativeToRoot, y_relativeToRoot);
        }

        public double getX() {
            return this.x_relativeToRoot - TreeLayout.this.boundsLeft;
        }

        public double getY() {
            return this.y_relativeToRoot - TreeLayout.this.boundsTop;
        }

        public void setLocation(double x_relativeToRoot, double y_relativeToRoot) {
            this.x_relativeToRoot = x_relativeToRoot;
            this.y_relativeToRoot = y_relativeToRoot;
        }
    }
}

