/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.codegen;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.Token;
import org.antlr.v4.codegen.CodeGenerator;
import org.antlr.v4.codegen.OutputModelFactory;
import org.antlr.v4.codegen.model.RuleFunction;
import org.antlr.v4.codegen.model.chunk.ActionChunk;
import org.antlr.v4.codegen.model.chunk.ActionText;
import org.antlr.v4.codegen.model.chunk.ArgRef;
import org.antlr.v4.codegen.model.chunk.LabelRef;
import org.antlr.v4.codegen.model.chunk.ListLabelRef;
import org.antlr.v4.codegen.model.chunk.LocalRef;
import org.antlr.v4.codegen.model.chunk.NonLocalAttrRef;
import org.antlr.v4.codegen.model.chunk.QRetValueRef;
import org.antlr.v4.codegen.model.chunk.RetValueRef;
import org.antlr.v4.codegen.model.chunk.RulePropertyRef;
import org.antlr.v4.codegen.model.chunk.RulePropertyRef_ctx;
import org.antlr.v4.codegen.model.chunk.RulePropertyRef_parser;
import org.antlr.v4.codegen.model.chunk.RulePropertyRef_start;
import org.antlr.v4.codegen.model.chunk.RulePropertyRef_stop;
import org.antlr.v4.codegen.model.chunk.RulePropertyRef_text;
import org.antlr.v4.codegen.model.chunk.SetAttr;
import org.antlr.v4.codegen.model.chunk.SetNonLocalAttr;
import org.antlr.v4.codegen.model.chunk.ThisRulePropertyRef_ctx;
import org.antlr.v4.codegen.model.chunk.ThisRulePropertyRef_parser;
import org.antlr.v4.codegen.model.chunk.ThisRulePropertyRef_start;
import org.antlr.v4.codegen.model.chunk.ThisRulePropertyRef_stop;
import org.antlr.v4.codegen.model.chunk.ThisRulePropertyRef_text;
import org.antlr.v4.codegen.model.chunk.TokenPropertyRef;
import org.antlr.v4.codegen.model.chunk.TokenPropertyRef_channel;
import org.antlr.v4.codegen.model.chunk.TokenPropertyRef_index;
import org.antlr.v4.codegen.model.chunk.TokenPropertyRef_int;
import org.antlr.v4.codegen.model.chunk.TokenPropertyRef_line;
import org.antlr.v4.codegen.model.chunk.TokenPropertyRef_pos;
import org.antlr.v4.codegen.model.chunk.TokenPropertyRef_text;
import org.antlr.v4.codegen.model.chunk.TokenPropertyRef_type;
import org.antlr.v4.codegen.model.chunk.TokenRef;
import org.antlr.v4.codegen.model.decl.StructDecl;
import org.antlr.v4.parse.ActionSplitter;
import org.antlr.v4.parse.ActionSplitterListener;
import org.antlr.v4.tool.Attribute;
import org.antlr.v4.tool.ErrorType;
import org.antlr.v4.tool.Grammar;
import org.antlr.v4.tool.Rule;
import org.antlr.v4.tool.ast.ActionAST;

public class ActionTranslator
implements ActionSplitterListener {
    public static final Map<String, Class<? extends RulePropertyRef>> thisRulePropToModelMap = new HashMap<String, Class<? extends RulePropertyRef>>();
    public static final Map<String, Class<? extends RulePropertyRef>> rulePropToModelMap;
    public static final Map<String, Class<? extends TokenPropertyRef>> tokenPropToModelMap;
    CodeGenerator gen;
    ActionAST node;
    RuleFunction rf;
    List<ActionChunk> chunks = new ArrayList<ActionChunk>();
    OutputModelFactory factory;
    StructDecl nodeContext;

    public ActionTranslator(OutputModelFactory factory, ActionAST node) {
        this.factory = factory;
        this.node = node;
        this.gen = factory.getGenerator();
    }

    public static String toString(List<ActionChunk> chunks) {
        StringBuilder buf = new StringBuilder();
        for (ActionChunk c2 : chunks) {
            buf.append(c2.toString());
        }
        return buf.toString();
    }

    public static List<ActionChunk> translateAction(OutputModelFactory factory, RuleFunction rf, Token tokenWithinAction, ActionAST node) {
        String action = tokenWithinAction.getText();
        if (action != null && action.length() > 0 && action.charAt(0) == '{') {
            int firstCurly = action.indexOf(123);
            int lastCurly = action.lastIndexOf(125);
            if (firstCurly >= 0 && lastCurly >= 0) {
                action = action.substring(firstCurly + 1, lastCurly);
            }
        }
        return ActionTranslator.translateActionChunk(factory, rf, action, node);
    }

    public static List<ActionChunk> translateActionChunk(OutputModelFactory factory, RuleFunction rf, String action, ActionAST node) {
        Token tokenWithinAction = node.token;
        ActionTranslator translator = new ActionTranslator(factory, node);
        translator.rf = rf;
        factory.getGrammar().tool.log("action-translator", "translate " + action);
        String altLabel = node.getAltLabel();
        if (rf != null) {
            translator.nodeContext = rf.ruleCtx;
            if (altLabel != null) {
                translator.nodeContext = rf.altLabelCtxs.get(altLabel);
            }
        }
        ANTLRStringStream in = new ANTLRStringStream(action);
        in.setLine(tokenWithinAction.getLine());
        in.setCharPositionInLine(tokenWithinAction.getCharPositionInLine());
        ActionSplitter trigger = new ActionSplitter((CharStream)in, translator);
        trigger.getActionTokens();
        return translator.chunks;
    }

    @Override
    public void attr(String expr, Token x2) {
        this.gen.g.tool.log("action-translator", "attr " + x2);
        Attribute a2 = this.node.resolver.resolveToAttribute(x2.getText(), this.node);
        if (a2 != null) {
            switch (a2.dict.type) {
                case ARG: {
                    this.chunks.add(new ArgRef(this.nodeContext, x2.getText()));
                    break;
                }
                case RET: {
                    this.chunks.add(new RetValueRef(this.rf.ruleCtx, x2.getText()));
                    break;
                }
                case LOCAL: {
                    this.chunks.add(new LocalRef(this.nodeContext, x2.getText()));
                    break;
                }
                case PREDEFINED_RULE: {
                    this.chunks.add(this.getRulePropertyRef(x2));
                }
            }
        }
        if (this.node.resolver.resolvesToToken(x2.getText(), this.node)) {
            this.chunks.add(new TokenRef(this.nodeContext, this.getTokenLabel(x2.getText())));
            return;
        }
        if (this.node.resolver.resolvesToLabel(x2.getText(), this.node)) {
            this.chunks.add(new LabelRef(this.nodeContext, this.getTokenLabel(x2.getText())));
            return;
        }
        if (this.node.resolver.resolvesToListLabel(x2.getText(), this.node)) {
            this.chunks.add(new ListLabelRef(this.nodeContext, x2.getText()));
            return;
        }
        Rule r2 = this.factory.getGrammar().getRule(x2.getText());
        if (r2 != null) {
            this.chunks.add(new LabelRef(this.nodeContext, this.getRuleLabel(x2.getText())));
        }
    }

    @Override
    public void qualifiedAttr(String expr, Token x2, Token y2) {
        this.gen.g.tool.log("action-translator", "qattr " + x2 + "." + y2);
        if (this.node.resolver.resolveToAttribute(x2.getText(), this.node) != null) {
            this.attr(expr, x2);
            this.chunks.add(new ActionText(this.nodeContext, "." + y2.getText()));
            return;
        }
        Attribute a2 = this.node.resolver.resolveToAttribute(x2.getText(), y2.getText(), this.node);
        if (a2 == null) {
            this.gen.g.tool.errMgr.grammarError(ErrorType.UNKNOWN_SIMPLE_ATTRIBUTE, this.gen.g.fileName, x2, x2.getText(), "rule");
            return;
        }
        switch (a2.dict.type) {
            case ARG: {
                this.chunks.add(new ArgRef(this.nodeContext, y2.getText()));
                break;
            }
            case RET: {
                this.chunks.add(new QRetValueRef(this.nodeContext, this.getRuleLabel(x2.getText()), y2.getText()));
                break;
            }
            case PREDEFINED_RULE: {
                this.chunks.add(this.getRulePropertyRef(x2, y2));
                break;
            }
            case TOKEN: {
                this.chunks.add(this.getTokenPropertyRef(x2, y2));
            }
        }
    }

    @Override
    public void setAttr(String expr, Token x2, Token rhs) {
        this.gen.g.tool.log("action-translator", "setAttr " + x2 + " " + rhs);
        List<ActionChunk> rhsChunks = ActionTranslator.translateActionChunk(this.factory, this.rf, rhs.getText(), this.node);
        SetAttr s2 = new SetAttr(this.nodeContext, x2.getText(), rhsChunks);
        this.chunks.add(s2);
    }

    @Override
    public void nonLocalAttr(String expr, Token x2, Token y2) {
        this.gen.g.tool.log("action-translator", "nonLocalAttr " + x2 + "::" + y2);
        Rule r2 = this.factory.getGrammar().getRule(x2.getText());
        this.chunks.add(new NonLocalAttrRef(this.nodeContext, x2.getText(), y2.getText(), r2.index));
    }

    @Override
    public void setNonLocalAttr(String expr, Token x2, Token y2, Token rhs) {
        this.gen.g.tool.log("action-translator", "setNonLocalAttr " + x2 + "::" + y2 + "=" + rhs);
        Rule r2 = this.factory.getGrammar().getRule(x2.getText());
        List<ActionChunk> rhsChunks = ActionTranslator.translateActionChunk(this.factory, this.rf, rhs.getText(), this.node);
        SetNonLocalAttr s2 = new SetNonLocalAttr(this.nodeContext, x2.getText(), y2.getText(), r2.index, rhsChunks);
        this.chunks.add(s2);
    }

    @Override
    public void text(String text) {
        this.chunks.add(new ActionText(this.nodeContext, text));
    }

    TokenPropertyRef getTokenPropertyRef(Token x2, Token y2) {
        try {
            Class<? extends TokenPropertyRef> c2 = tokenPropToModelMap.get(y2.getText());
            Constructor<? extends TokenPropertyRef> ctor = c2.getConstructor(StructDecl.class, String.class);
            TokenPropertyRef ref = ctor.newInstance(this.nodeContext, this.getTokenLabel(x2.getText()));
            return ref;
        }
        catch (Exception e2) {
            this.factory.getGrammar().tool.errMgr.toolError(ErrorType.INTERNAL_ERROR, e2, new Object[0]);
            return null;
        }
    }

    RulePropertyRef getRulePropertyRef(Token prop) {
        try {
            Class<? extends RulePropertyRef> c2 = thisRulePropToModelMap.get(prop.getText());
            Constructor<? extends RulePropertyRef> ctor = c2.getConstructor(StructDecl.class, String.class);
            RulePropertyRef ref = ctor.newInstance(this.nodeContext, this.getRuleLabel(prop.getText()));
            return ref;
        }
        catch (Exception e2) {
            this.factory.getGrammar().tool.errMgr.toolError(ErrorType.INTERNAL_ERROR, e2, new Object[0]);
            return null;
        }
    }

    RulePropertyRef getRulePropertyRef(Token x2, Token prop) {
        Grammar g2 = this.factory.getGrammar();
        try {
            Class<? extends RulePropertyRef> c2 = rulePropToModelMap.get(prop.getText());
            Constructor<? extends RulePropertyRef> ctor = c2.getConstructor(StructDecl.class, String.class);
            RulePropertyRef ref = ctor.newInstance(this.nodeContext, this.getRuleLabel(x2.getText()));
            return ref;
        }
        catch (Exception e2) {
            g2.tool.errMgr.toolError(ErrorType.INTERNAL_ERROR, e2, prop.getText());
            return null;
        }
    }

    public String getTokenLabel(String x2) {
        if (this.node.resolver.resolvesToLabel(x2, this.node)) {
            return x2;
        }
        return this.factory.getGenerator().getTarget().getImplicitTokenLabel(x2);
    }

    public String getRuleLabel(String x2) {
        if (this.node.resolver.resolvesToLabel(x2, this.node)) {
            return x2;
        }
        return this.factory.getGenerator().getTarget().getImplicitRuleLabel(x2);
    }

    static {
        thisRulePropToModelMap.put("start", ThisRulePropertyRef_start.class);
        thisRulePropToModelMap.put("stop", ThisRulePropertyRef_stop.class);
        thisRulePropToModelMap.put("text", ThisRulePropertyRef_text.class);
        thisRulePropToModelMap.put("ctx", ThisRulePropertyRef_ctx.class);
        thisRulePropToModelMap.put("parser", ThisRulePropertyRef_parser.class);
        rulePropToModelMap = new HashMap<String, Class<? extends RulePropertyRef>>();
        rulePropToModelMap.put("start", RulePropertyRef_start.class);
        rulePropToModelMap.put("stop", RulePropertyRef_stop.class);
        rulePropToModelMap.put("text", RulePropertyRef_text.class);
        rulePropToModelMap.put("ctx", RulePropertyRef_ctx.class);
        rulePropToModelMap.put("parser", RulePropertyRef_parser.class);
        tokenPropToModelMap = new HashMap<String, Class<? extends TokenPropertyRef>>();
        tokenPropToModelMap.put("text", TokenPropertyRef_text.class);
        tokenPropToModelMap.put("type", TokenPropertyRef_type.class);
        tokenPropToModelMap.put("line", TokenPropertyRef_line.class);
        tokenPropToModelMap.put("index", TokenPropertyRef_index.class);
        tokenPropToModelMap.put("pos", TokenPropertyRef_pos.class);
        tokenPropToModelMap.put("channel", TokenPropertyRef_channel.class);
        tokenPropToModelMap.put("int", TokenPropertyRef_int.class);
    }
}

