/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.codegen.model;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import org.antlr.runtime.tree.TreeNodeStream;
import org.antlr.v4.misc.FrequencySet;
import org.antlr.v4.misc.MutableInt;
import org.antlr.v4.parse.GrammarTreeVisitor;
import org.antlr.v4.tool.ErrorManager;
import org.antlr.v4.tool.ast.ActionAST;
import org.antlr.v4.tool.ast.AltAST;
import org.antlr.v4.tool.ast.GrammarAST;
import org.antlr.v4.tool.ast.TerminalAST;

public class ElementFrequenciesVisitor
extends GrammarTreeVisitor {
    private static final FrequencySet<String> SENTINEL = new FrequencySet();
    final Deque<FrequencySet<String>> frequencies = new ArrayDeque<FrequencySet<String>>();
    private final Deque<FrequencySet<String>> minFrequencies;

    public ElementFrequenciesVisitor(TreeNodeStream input) {
        super(input);
        this.frequencies.push(new FrequencySet());
        this.minFrequencies = new ArrayDeque<FrequencySet<String>>();
        this.minFrequencies.push(SENTINEL);
    }

    FrequencySet<String> getMinFrequencies() {
        assert (this.minFrequencies.size() == 1);
        assert (this.minFrequencies.peek() != SENTINEL);
        assert (SENTINEL.isEmpty());
        return this.minFrequencies.peek();
    }

    @Override
    public ErrorManager getErrorManager() {
        return super.getErrorManager();
    }

    protected static FrequencySet<String> combineMax(FrequencySet<String> a2, FrequencySet<String> b2) {
        FrequencySet<String> result = ElementFrequenciesVisitor.combineAndClip(a2, b2, 1);
        for (Map.Entry entry : a2.entrySet()) {
            ((MutableInt)result.get(entry.getKey())).v = ((MutableInt)entry.getValue()).v;
        }
        for (Map.Entry entry : b2.entrySet()) {
            MutableInt slot = (MutableInt)result.get(entry.getKey());
            slot.v = Math.max(slot.v, ((MutableInt)entry.getValue()).v);
        }
        return result;
    }

    protected static FrequencySet<String> combineMin(FrequencySet<String> a2, FrequencySet<String> b2) {
        if (b2 == SENTINEL) {
            return a2;
        }
        assert (a2 != SENTINEL);
        FrequencySet<String> result = ElementFrequenciesVisitor.combineAndClip(a2, b2, Integer.MAX_VALUE);
        for (Map.Entry entry : result.entrySet()) {
            ((MutableInt)entry.getValue()).v = Math.min(a2.count((String)entry.getKey()), b2.count((String)entry.getKey()));
        }
        return result;
    }

    protected static FrequencySet<String> combineAndClip(FrequencySet<String> a2, FrequencySet<String> b2, int clip) {
        int i2;
        FrequencySet<String> result = new FrequencySet<String>();
        for (Map.Entry entry : a2.entrySet()) {
            for (i2 = 0; i2 < ((MutableInt)entry.getValue()).v; ++i2) {
                result.add((String)entry.getKey());
            }
        }
        for (Map.Entry entry : b2.entrySet()) {
            for (i2 = 0; i2 < ((MutableInt)entry.getValue()).v; ++i2) {
                result.add((String)entry.getKey());
            }
        }
        for (Map.Entry entry : result.entrySet()) {
            ((MutableInt)entry.getValue()).v = Math.min(((MutableInt)entry.getValue()).v, clip);
        }
        return result;
    }

    @Override
    public void tokenRef(TerminalAST ref) {
        this.frequencies.peek().add(ref.getText());
        this.minFrequencies.peek().add(ref.getText());
    }

    @Override
    public void ruleRef(GrammarAST ref, ActionAST arg) {
        this.frequencies.peek().add(ref.getText());
        this.minFrequencies.peek().add(ref.getText());
    }

    @Override
    protected void enterAlternative(AltAST tree) {
        this.frequencies.push(new FrequencySet());
        this.minFrequencies.push(new FrequencySet());
    }

    @Override
    protected void exitAlternative(AltAST tree) {
        this.frequencies.push(ElementFrequenciesVisitor.combineMax(this.frequencies.pop(), this.frequencies.pop()));
        this.minFrequencies.push(ElementFrequenciesVisitor.combineMin(this.minFrequencies.pop(), this.minFrequencies.pop()));
    }

    @Override
    protected void enterElement(GrammarAST tree) {
        this.frequencies.push(new FrequencySet());
        this.minFrequencies.push(new FrequencySet());
    }

    @Override
    protected void exitElement(GrammarAST tree) {
        this.frequencies.push(ElementFrequenciesVisitor.combineAndClip(this.frequencies.pop(), this.frequencies.pop(), 2));
        this.minFrequencies.push(ElementFrequenciesVisitor.combineAndClip(this.minFrequencies.pop(), this.minFrequencies.pop(), 2));
    }

    @Override
    protected void enterBlockSet(GrammarAST tree) {
        this.frequencies.push(new FrequencySet());
        this.minFrequencies.push(new FrequencySet());
    }

    @Override
    protected void exitBlockSet(GrammarAST tree) {
        for (Map.Entry entry : this.frequencies.peek().entrySet()) {
            ((MutableInt)entry.getValue()).v = 1;
        }
        if (this.minFrequencies.peek().size() > 1) {
            this.minFrequencies.peek().clear();
        }
        this.frequencies.push(ElementFrequenciesVisitor.combineAndClip(this.frequencies.pop(), this.frequencies.pop(), 2));
        this.minFrequencies.push(ElementFrequenciesVisitor.combineAndClip(this.minFrequencies.pop(), this.minFrequencies.pop(), 2));
    }

    @Override
    protected void exitSubrule(GrammarAST tree) {
        if (tree.getType() == 80 || tree.getType() == 90) {
            for (Map.Entry entry : this.frequencies.peek().entrySet()) {
                ((MutableInt)entry.getValue()).v = 2;
            }
        }
        if (tree.getType() == 80 || tree.getType() == 89) {
            this.minFrequencies.peek().clear();
        }
    }

    @Override
    protected void enterLexerAlternative(GrammarAST tree) {
        this.frequencies.push(new FrequencySet());
        this.minFrequencies.push(new FrequencySet());
    }

    @Override
    protected void exitLexerAlternative(GrammarAST tree) {
        this.frequencies.push(ElementFrequenciesVisitor.combineMax(this.frequencies.pop(), this.frequencies.pop()));
        this.minFrequencies.push(ElementFrequenciesVisitor.combineMin(this.minFrequencies.pop(), this.minFrequencies.pop()));
    }

    @Override
    protected void enterLexerElement(GrammarAST tree) {
        this.frequencies.push(new FrequencySet());
        this.minFrequencies.push(new FrequencySet());
    }

    @Override
    protected void exitLexerElement(GrammarAST tree) {
        this.frequencies.push(ElementFrequenciesVisitor.combineAndClip(this.frequencies.pop(), this.frequencies.pop(), 2));
        this.minFrequencies.push(ElementFrequenciesVisitor.combineAndClip(this.minFrequencies.pop(), this.minFrequencies.pop(), 2));
    }

    @Override
    protected void exitLexerSubrule(GrammarAST tree) {
        if (tree.getType() == 80 || tree.getType() == 90) {
            for (Map.Entry entry : this.frequencies.peek().entrySet()) {
                ((MutableInt)entry.getValue()).v = 2;
            }
        }
        if (tree.getType() == 80) {
            this.minFrequencies.peek().clear();
        }
    }
}

