/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.gui;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.antlr.v4.gui.SystemFontMetrics;

public class PostScriptDocument {
    public static final String DEFAULT_FONT = "CourierNew";
    public static final Map<String, String> POSTSCRIPT_FONT_NAMES = new HashMap<String, String>();
    protected int boundingBoxWidth;
    protected int boundingBoxHeight;
    protected SystemFontMetrics fontMetrics;
    protected String fontName;
    protected int fontSize = 12;
    protected double lineWidth = 0.3;
    protected String boundingBox;
    protected StringBuilder ps = new StringBuilder();
    protected boolean closed = false;

    public PostScriptDocument() {
        this(DEFAULT_FONT, 12);
    }

    public PostScriptDocument(String fontName, int fontSize) {
        this.header();
        this.setFont(fontName, fontSize);
    }

    public String getPS() {
        this.close();
        return this.header() + this.ps.toString();
    }

    public void boundingBox(int w2, int h2) {
        this.boundingBoxWidth = w2;
        this.boundingBoxHeight = h2;
        this.boundingBox = String.format(Locale.US, "%%%%BoundingBox: %d %d %d %d\n", 0, 0, this.boundingBoxWidth, this.boundingBoxHeight);
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.ps.append("%%Trailer\n");
        this.closed = true;
    }

    protected StringBuilder header() {
        StringBuilder b2 = new StringBuilder();
        b2.append("%!PS-Adobe-3.0 EPSF-3.0\n");
        b2.append(this.boundingBox).append("\n");
        b2.append("0.3 setlinewidth\n");
        b2.append("%% x y w h highlight\n/highlight {\n        4 dict begin\n        /h exch def\n        /w exch def\n        /y exch def\n        /x exch def\n        gsave\n        newpath\n        x y moveto\n        0 h rlineto     % up to left corner\n        w 0 rlineto     % to upper right corner\n        0 h neg rlineto % to lower right corner\n        w neg 0 rlineto % back home to lower left corner\n        closepath\n        .95 .83 .82 setrgbcolor\n        fill\n        grestore\n        end\n} def\n");
        return b2;
    }

    public void setFont(String fontName, int fontSize) {
        this.fontMetrics = new SystemFontMetrics(fontName);
        this.fontName = this.fontMetrics.getFont().getPSName();
        this.fontSize = fontSize;
        String psname = POSTSCRIPT_FONT_NAMES.get(this.fontName);
        if (psname == null) {
            psname = this.fontName;
        }
        this.ps.append(String.format(Locale.US, "/%s findfont %d scalefont setfont\n", psname, fontSize));
    }

    public void lineWidth(double w2) {
        this.lineWidth = w2;
        this.ps.append(w2).append(" setlinewidth\n");
    }

    public void move(double x2, double y2) {
        this.ps.append(String.format(Locale.US, "%1.3f %1.3f moveto\n", x2, y2));
    }

    public void lineto(double x2, double y2) {
        this.ps.append(String.format(Locale.US, "%1.3f %1.3f lineto\n", x2, y2));
    }

    public void line(double x1, double y1, double x2, double y2) {
        this.move(x1, y1);
        this.lineto(x2, y2);
    }

    public void rect(double x2, double y2, double width, double height) {
        this.line(x2, y2, x2, y2 + height);
        this.line(x2, y2 + height, x2 + width, y2 + height);
        this.line(x2 + width, y2 + height, x2 + width, y2);
        this.line(x2 + width, y2, x2, y2);
    }

    public void highlight(double x2, double y2, double width, double height) {
        this.ps.append(String.format(Locale.US, "%1.3f %1.3f %1.3f %1.3f highlight\n", x2, y2, width, height));
    }

    public void stroke() {
        this.ps.append("stroke\n");
    }

    public void text(String s2, double x2, double y2) {
        StringBuilder buf = new StringBuilder();
        block3: for (char c2 : s2.toCharArray()) {
            switch (c2) {
                case '(': 
                case ')': 
                case '\\': {
                    buf.append('\\');
                    buf.append(c2);
                    continue block3;
                }
                default: {
                    buf.append(c2);
                }
            }
        }
        s2 = buf.toString();
        this.move(x2, y2);
        this.ps.append(String.format(Locale.US, "(%s) show\n", s2));
        this.stroke();
    }

    public double getWidth(char c2) {
        return this.fontMetrics.getWidth(c2, this.fontSize);
    }

    public double getWidth(String s2) {
        return this.fontMetrics.getWidth(s2, this.fontSize);
    }

    public double getLineHeight() {
        return this.fontMetrics.getLineHeight(this.fontSize);
    }

    public int getFontSize() {
        return this.fontSize;
    }

    static {
        POSTSCRIPT_FONT_NAMES.put("SansSerif.plain", "ArialMT");
        POSTSCRIPT_FONT_NAMES.put("SansSerif.bold", "Arial-BoldMT");
        POSTSCRIPT_FONT_NAMES.put("SansSerif.italic", "Arial-ItalicMT");
        POSTSCRIPT_FONT_NAMES.put("SansSerif.bolditalic", "Arial-BoldItalicMT");
        POSTSCRIPT_FONT_NAMES.put("Serif.plain", "TimesNewRomanPSMT");
        POSTSCRIPT_FONT_NAMES.put("Serif.bold", "TimesNewRomanPS-BoldMT");
        POSTSCRIPT_FONT_NAMES.put("Serif.italic", "TimesNewRomanPS-ItalicMT");
        POSTSCRIPT_FONT_NAMES.put("Serif.bolditalic", "TimesNewRomanPS-BoldItalicMT");
        POSTSCRIPT_FONT_NAMES.put("Monospaced.plain", "CourierNewPSMT");
        POSTSCRIPT_FONT_NAMES.put("Monospaced.bold", "CourierNewPS-BoldMT");
        POSTSCRIPT_FONT_NAMES.put("Monospaced.italic", "CourierNewPS-ItalicMT");
        POSTSCRIPT_FONT_NAMES.put("Monospaced.bolditalic", "CourierNewPS-BoldItalicMT");
    }
}

