/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.misc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.antlr.v4.tool.ast.GrammarAST;

public class Utils {
    public static final int INTEGER_POOL_MAX_VALUE = 1000;
    static Integer[] ints = new Integer[1001];

    public static String stripFileExtension(String name) {
        if (name == null) {
            return null;
        }
        int lastDot = name.lastIndexOf(46);
        if (lastDot < 0) {
            return name;
        }
        return name.substring(0, lastDot);
    }

    public static String join(Object[] a2, String separator) {
        StringBuilder buf = new StringBuilder();
        for (int i2 = 0; i2 < a2.length; ++i2) {
            Object o2 = a2[i2];
            buf.append(o2.toString());
            if (i2 + 1 >= a2.length) continue;
            buf.append(separator);
        }
        return buf.toString();
    }

    public static String sortLinesInString(String s2) {
        Object[] lines = s2.split("\n");
        Arrays.sort(lines);
        List<Object> linesL = Arrays.asList(lines);
        StringBuilder buf = new StringBuilder();
        for (String string : linesL) {
            buf.append(string);
            buf.append('\n');
        }
        return buf.toString();
    }

    public static <T extends GrammarAST> List<String> nodesToStrings(List<T> nodes) {
        if (nodes == null) {
            return null;
        }
        ArrayList<String> a2 = new ArrayList<String>();
        for (GrammarAST t2 : nodes) {
            a2.add(t2.getText());
        }
        return a2;
    }

    public static String capitalize(String s2) {
        return Character.toUpperCase(s2.charAt(0)) + s2.substring(1);
    }

    public static String decapitalize(String s2) {
        return Character.toLowerCase(s2.charAt(0)) + s2.substring(1);
    }

    public static <From, To> List<To> select(List<From> list, Func1<From, To> selector) {
        if (list == null) {
            return null;
        }
        ArrayList<To> b2 = new ArrayList<To>();
        for (From f2 : list) {
            b2.add(selector.exec(f2));
        }
        return b2;
    }

    public static <T> T find(List<?> ops, Class<T> cl) {
        for (Object o2 : ops) {
            if (!cl.isInstance(o2)) continue;
            return cl.cast(o2);
        }
        return null;
    }

    public static <T> int indexOf(List<? extends T> elems, Filter<T> filter) {
        for (int i2 = 0; i2 < elems.size(); ++i2) {
            if (!filter.select(elems.get(i2))) continue;
            return i2;
        }
        return -1;
    }

    public static <T> int lastIndexOf(List<? extends T> elems, Filter<T> filter) {
        for (int i2 = elems.size() - 1; i2 >= 0; --i2) {
            if (!filter.select(elems.get(i2))) continue;
            return i2;
        }
        return -1;
    }

    public static void setSize(List<?> list, int size) {
        if (size < list.size()) {
            list.subList(size, list.size()).clear();
        } else {
            while (size > list.size()) {
                list.add(null);
            }
        }
    }

    public static interface Func1<T1, TResult> {
        public TResult exec(T1 var1);
    }

    public static interface Func0<TResult> {
        public TResult exec();
    }

    public static interface Filter<T> {
        public boolean select(T var1);
    }
}

