/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.semantics;

import java.util.List;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.Token;
import org.antlr.v4.parse.ActionSplitter;
import org.antlr.v4.parse.ActionSplitterListener;
import org.antlr.v4.tool.Alternative;
import org.antlr.v4.tool.ErrorManager;
import org.antlr.v4.tool.ErrorType;
import org.antlr.v4.tool.Grammar;
import org.antlr.v4.tool.LabelElementPair;
import org.antlr.v4.tool.LabelType;
import org.antlr.v4.tool.Rule;
import org.antlr.v4.tool.ast.ActionAST;
import org.antlr.v4.tool.ast.GrammarAST;

public class AttributeChecks
implements ActionSplitterListener {
    public Grammar g;
    public Rule r;
    public Alternative alt;
    public ActionAST node;
    public Token actionToken;
    public ErrorManager errMgr;

    public AttributeChecks(Grammar g2, Rule r2, Alternative alt, ActionAST node, Token actionToken) {
        this.g = g2;
        this.r = r2;
        this.alt = alt;
        this.node = node;
        this.actionToken = actionToken;
        this.errMgr = g2.tool.errMgr;
    }

    public static void checkAllAttributeExpressions(Grammar g2) {
        Object checker;
        for (ActionAST act : g2.namedActions.values()) {
            checker = new AttributeChecks(g2, null, null, act, act.token);
            ((AttributeChecks)checker).examineAction();
        }
        for (Rule r2 : g2.rules.values()) {
            for (ActionAST a2 : r2.namedActions.values()) {
                AttributeChecks checker2 = new AttributeChecks(g2, r2, null, a2, a2.token);
                checker2.examineAction();
            }
            for (int i2 = 1; i2 <= r2.numberOfAlts; ++i2) {
                Alternative alt = r2.alt[i2];
                for (ActionAST a3 : alt.actions) {
                    AttributeChecks checker3 = new AttributeChecks(g2, r2, alt, a3, a3.token);
                    checker3.examineAction();
                }
            }
            for (GrammarAST e2 : r2.exceptions) {
                ActionAST a4 = (ActionAST)e2.getChild(1);
                AttributeChecks checker4 = new AttributeChecks(g2, r2, null, a4, a4.token);
                checker4.examineAction();
            }
            if (r2.finallyAction == null) continue;
            checker = new AttributeChecks(g2, r2, null, r2.finallyAction, r2.finallyAction.token);
            ((AttributeChecks)checker).examineAction();
        }
    }

    public void examineAction() {
        ANTLRStringStream in = new ANTLRStringStream(this.actionToken.getText());
        in.setLine(this.actionToken.getLine());
        in.setCharPositionInLine(this.actionToken.getCharPositionInLine());
        ActionSplitter splitter = new ActionSplitter((CharStream)in, this);
        this.node.chunks = splitter.getActionTokens();
    }

    @Override
    public void qualifiedAttr(String expr, Token x2, Token y2) {
        if (this.g.isLexer()) {
            this.errMgr.grammarError(ErrorType.ATTRIBUTE_IN_LEXER_ACTION, this.g.fileName, x2, x2.getText() + "." + y2.getText(), expr);
            return;
        }
        if (this.node.resolver.resolveToAttribute(x2.getText(), this.node) != null) {
            this.attr(expr, x2);
            return;
        }
        if (this.node.resolver.resolveToAttribute(x2.getText(), y2.getText(), this.node) == null) {
            Rule rref = this.isolatedRuleRef(x2.getText());
            if (rref != null) {
                if (rref.args != null && rref.args.get(y2.getText()) != null) {
                    this.g.tool.errMgr.grammarError(ErrorType.INVALID_RULE_PARAMETER_REF, this.g.fileName, y2, y2.getText(), rref.name, expr);
                } else {
                    this.errMgr.grammarError(ErrorType.UNKNOWN_RULE_ATTRIBUTE, this.g.fileName, y2, y2.getText(), rref.name, expr);
                }
            } else if (!this.node.resolver.resolvesToAttributeDict(x2.getText(), this.node)) {
                this.errMgr.grammarError(ErrorType.UNKNOWN_SIMPLE_ATTRIBUTE, this.g.fileName, x2, x2.getText(), expr);
            } else {
                this.errMgr.grammarError(ErrorType.UNKNOWN_ATTRIBUTE_IN_SCOPE, this.g.fileName, y2, y2.getText(), expr);
            }
        }
    }

    @Override
    public void setAttr(String expr, Token x2, Token rhs) {
        if (this.g.isLexer()) {
            this.errMgr.grammarError(ErrorType.ATTRIBUTE_IN_LEXER_ACTION, this.g.fileName, x2, x2.getText(), expr);
            return;
        }
        if (this.node.resolver.resolveToAttribute(x2.getText(), this.node) == null) {
            ErrorType errorType = ErrorType.UNKNOWN_SIMPLE_ATTRIBUTE;
            if (this.node.resolver.resolvesToListLabel(x2.getText(), this.node)) {
                errorType = ErrorType.ASSIGNMENT_TO_LIST_LABEL;
            }
            this.errMgr.grammarError(errorType, this.g.fileName, x2, x2.getText(), expr);
        }
        new AttributeChecks(this.g, this.r, this.alt, this.node, rhs).examineAction();
    }

    @Override
    public void attr(String expr, Token x2) {
        if (this.g.isLexer()) {
            this.errMgr.grammarError(ErrorType.ATTRIBUTE_IN_LEXER_ACTION, this.g.fileName, x2, x2.getText(), expr);
            return;
        }
        if (this.node.resolver.resolveToAttribute(x2.getText(), this.node) == null) {
            if (this.node.resolver.resolvesToToken(x2.getText(), this.node)) {
                return;
            }
            if (this.node.resolver.resolvesToListLabel(x2.getText(), this.node)) {
                return;
            }
            if (this.isolatedRuleRef(x2.getText()) != null) {
                this.errMgr.grammarError(ErrorType.ISOLATED_RULE_REF, this.g.fileName, x2, x2.getText(), expr);
                return;
            }
            this.errMgr.grammarError(ErrorType.UNKNOWN_SIMPLE_ATTRIBUTE, this.g.fileName, x2, x2.getText(), expr);
        }
    }

    @Override
    public void nonLocalAttr(String expr, Token x2, Token y2) {
        Rule r2 = this.g.getRule(x2.getText());
        if (r2 == null) {
            this.errMgr.grammarError(ErrorType.UNDEFINED_RULE_IN_NONLOCAL_REF, this.g.fileName, x2, x2.getText(), y2.getText(), expr);
        } else if (r2.resolveToAttribute(y2.getText(), null) == null) {
            this.errMgr.grammarError(ErrorType.UNKNOWN_RULE_ATTRIBUTE, this.g.fileName, y2, y2.getText(), x2.getText(), expr);
        }
    }

    @Override
    public void setNonLocalAttr(String expr, Token x2, Token y2, Token rhs) {
        Rule r2 = this.g.getRule(x2.getText());
        if (r2 == null) {
            this.errMgr.grammarError(ErrorType.UNDEFINED_RULE_IN_NONLOCAL_REF, this.g.fileName, x2, x2.getText(), y2.getText(), expr);
        } else if (r2.resolveToAttribute(y2.getText(), null) == null) {
            this.errMgr.grammarError(ErrorType.UNKNOWN_RULE_ATTRIBUTE, this.g.fileName, y2, y2.getText(), x2.getText(), expr);
        }
    }

    @Override
    public void text(String text) {
    }

    public void templateInstance(String expr) {
    }

    public void indirectTemplateInstance(String expr) {
    }

    public void setExprAttribute(String expr) {
    }

    public void setSTAttribute(String expr) {
    }

    public void templateExpr(String expr) {
    }

    public Rule isolatedRuleRef(String x2) {
        if (this.node.resolver instanceof Grammar) {
            return null;
        }
        if (x2.equals(this.r.name)) {
            return this.r;
        }
        List labels = null;
        if (this.node.resolver instanceof Rule) {
            labels = (List)this.r.getElementLabelDefs().get(x2);
        } else if (this.node.resolver instanceof Alternative) {
            labels = (List)((Alternative)this.node.resolver).labelDefs.get(x2);
        }
        if (labels != null) {
            LabelElementPair anyLabelDef = (LabelElementPair)labels.get(0);
            if (anyLabelDef.type == LabelType.RULE_LABEL) {
                return this.g.getRule(anyLabelDef.element.getText());
            }
        }
        if (this.node.resolver instanceof Alternative && ((Alternative)this.node.resolver).ruleRefs.get(x2) != null) {
            return this.g.getRule(x2);
        }
        return null;
    }
}

