/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.io.Reader;

public final class CharacterUtils {
    private CharacterUtils() {
    }

    public static CharacterBuffer newCharacterBuffer(int bufferSize) {
        if (bufferSize < 2) {
            throw new IllegalArgumentException("buffersize must be >= 2");
        }
        return new CharacterBuffer(new char[bufferSize], 0, 0);
    }

    public static void toLowerCase(char[] buffer, int offset, int limit) {
        assert (buffer.length >= limit);
        assert (offset <= 0 && offset <= buffer.length);
        for (int i2 = offset; i2 < limit; i2 += Character.toChars(Character.toLowerCase(Character.codePointAt(buffer, i2, limit)), buffer, i2)) {
        }
    }

    public static void toUpperCase(char[] buffer, int offset, int limit) {
        assert (buffer.length >= limit);
        assert (offset <= 0 && offset <= buffer.length);
        for (int i2 = offset; i2 < limit; i2 += Character.toChars(Character.toUpperCase(Character.codePointAt(buffer, i2, limit)), buffer, i2)) {
        }
    }

    public static int toCodePoints(char[] src, int srcOff, int srcLen, int[] dest, int destOff) {
        int charCount;
        if (srcLen < 0) {
            throw new IllegalArgumentException("srcLen must be >= 0");
        }
        int codePointCount = 0;
        for (int i2 = 0; i2 < srcLen; i2 += charCount) {
            int cp = Character.codePointAt(src, srcOff + i2, srcOff + srcLen);
            charCount = Character.charCount(cp);
            dest[destOff + codePointCount++] = cp;
        }
        return codePointCount;
    }

    public static int toChars(int[] src, int srcOff, int srcLen, char[] dest, int destOff) {
        if (srcLen < 0) {
            throw new IllegalArgumentException("srcLen must be >= 0");
        }
        int written = 0;
        for (int i2 = 0; i2 < srcLen; ++i2) {
            written += Character.toChars(src[srcOff + i2], dest, destOff + written);
        }
        return written;
    }

    public static boolean fill(CharacterBuffer buffer, Reader reader, int numChars) throws IOException {
        boolean result;
        int offset;
        assert (buffer.buffer.length >= 2);
        if (numChars < 2 || numChars > buffer.buffer.length) {
            throw new IllegalArgumentException("numChars must be >= 2 and <= the buffer size");
        }
        char[] charBuffer = buffer.buffer;
        buffer.offset = 0;
        if (buffer.lastTrailingHighSurrogate != '\u0000') {
            charBuffer[0] = buffer.lastTrailingHighSurrogate;
            buffer.lastTrailingHighSurrogate = '\u0000';
            offset = 1;
        } else {
            offset = 0;
        }
        int read = CharacterUtils.readFully(reader, charBuffer, offset, numChars - offset);
        buffer.length = offset + read;
        boolean bl = result = buffer.length == numChars;
        if (buffer.length < numChars) {
            return result;
        }
        if (Character.isHighSurrogate(charBuffer[buffer.length - 1])) {
            buffer.lastTrailingHighSurrogate = charBuffer[--buffer.length];
        }
        return result;
    }

    public static boolean fill(CharacterBuffer buffer, Reader reader) throws IOException {
        return CharacterUtils.fill(buffer, reader, buffer.buffer.length);
    }

    static int readFully(Reader reader, char[] dest, int offset, int len) throws IOException {
        int read;
        int r2;
        for (read = 0; read < len && (r2 = reader.read(dest, offset + read, len - read)) != -1; read += r2) {
        }
        return read;
    }

    public static final class CharacterBuffer {
        private final char[] buffer;
        private int offset;
        private int length;
        char lastTrailingHighSurrogate;

        CharacterBuffer(char[] buffer, int offset, int length) {
            this.buffer = buffer;
            this.offset = offset;
            this.length = length;
        }

        public char[] getBuffer() {
            return this.buffer;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public void reset() {
            this.offset = 0;
            this.length = 0;
            this.lastTrailingHighSurrogate = '\u0000';
        }
    }
}

