/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo;

import java.text.ParseException;
import java.util.Arrays;
import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.geo.SimpleGeoJSONPolygonParser;

public final class Polygon {
    private final double[] polyLats;
    private final double[] polyLons;
    private final Polygon[] holes;
    public final double minLat;
    public final double maxLat;
    public final double minLon;
    public final double maxLon;

    public Polygon(double[] polyLats, double[] polyLons, Polygon ... holes) {
        int i2;
        if (polyLats == null) {
            throw new IllegalArgumentException("polyLats must not be null");
        }
        if (polyLons == null) {
            throw new IllegalArgumentException("polyLons must not be null");
        }
        if (holes == null) {
            throw new IllegalArgumentException("holes must not be null");
        }
        if (polyLats.length != polyLons.length) {
            throw new IllegalArgumentException("polyLats and polyLons must be equal length");
        }
        if (polyLats.length != polyLons.length) {
            throw new IllegalArgumentException("polyLats and polyLons must be equal length");
        }
        if (polyLats.length < 4) {
            throw new IllegalArgumentException("at least 4 polygon points required");
        }
        if (polyLats[0] != polyLats[polyLats.length - 1]) {
            throw new IllegalArgumentException("first and last points of the polygon must be the same (it must close itself): polyLats[0]=" + polyLats[0] + " polyLats[" + (polyLats.length - 1) + "]=" + polyLats[polyLats.length - 1]);
        }
        if (polyLons[0] != polyLons[polyLons.length - 1]) {
            throw new IllegalArgumentException("first and last points of the polygon must be the same (it must close itself): polyLons[0]=" + polyLons[0] + " polyLons[" + (polyLons.length - 1) + "]=" + polyLons[polyLons.length - 1]);
        }
        for (i2 = 0; i2 < polyLats.length; ++i2) {
            GeoUtils.checkLatitude(polyLats[i2]);
            GeoUtils.checkLongitude(polyLons[i2]);
        }
        for (i2 = 0; i2 < holes.length; ++i2) {
            Polygon inner = holes[i2];
            if (inner.holes.length <= 0) continue;
            throw new IllegalArgumentException("holes may not contain holes: polygons may not nest.");
        }
        this.polyLats = (double[])polyLats.clone();
        this.polyLons = (double[])polyLons.clone();
        this.holes = (Polygon[])holes.clone();
        double minLat = Double.POSITIVE_INFINITY;
        double maxLat = Double.NEGATIVE_INFINITY;
        double minLon = Double.POSITIVE_INFINITY;
        double maxLon = Double.NEGATIVE_INFINITY;
        for (int i3 = 0; i3 < polyLats.length; ++i3) {
            minLat = Math.min(polyLats[i3], minLat);
            maxLat = Math.max(polyLats[i3], maxLat);
            minLon = Math.min(polyLons[i3], minLon);
            maxLon = Math.max(polyLons[i3], maxLon);
        }
        this.minLat = minLat;
        this.maxLat = maxLat;
        this.minLon = minLon;
        this.maxLon = maxLon;
    }

    public double[] getPolyLats() {
        return (double[])this.polyLats.clone();
    }

    public double[] getPolyLons() {
        return (double[])this.polyLons.clone();
    }

    public Polygon[] getHoles() {
        return (Polygon[])this.holes.clone();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.holes);
        result = 31 * result + Arrays.hashCode(this.polyLats);
        result = 31 * result + Arrays.hashCode(this.polyLons);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Polygon other = (Polygon)obj;
        if (!Arrays.equals(this.holes, other.holes)) {
            return false;
        }
        if (!Arrays.equals(this.polyLats, other.polyLats)) {
            return false;
        }
        return Arrays.equals(this.polyLons, other.polyLons);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < this.polyLats.length; ++i2) {
            sb.append("[").append(this.polyLats[i2]).append(", ").append(this.polyLons[i2]).append("] ");
        }
        if (this.holes.length > 0) {
            sb.append(", holes=");
            sb.append(Arrays.toString(this.holes));
        }
        return sb.toString();
    }

    public static Polygon[] fromGeoJSON(String geojson) throws ParseException {
        return new SimpleGeoJSONPolygonParser(geojson).parse();
    }
}

