/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.BytesRef;

public abstract class FilteredTermsEnum
extends TermsEnum {
    private BytesRef initialSeekTerm;
    private boolean doSeek;
    protected BytesRef actualTerm;
    protected final TermsEnum tenum;

    protected abstract AcceptStatus accept(BytesRef var1) throws IOException;

    public FilteredTermsEnum(TermsEnum tenum) {
        this(tenum, true);
    }

    public FilteredTermsEnum(TermsEnum tenum, boolean startWithSeek) {
        assert (tenum != null);
        this.tenum = tenum;
        this.doSeek = startWithSeek;
    }

    protected final void setInitialSeekTerm(BytesRef term) {
        this.initialSeekTerm = term;
    }

    protected BytesRef nextSeekTerm(BytesRef currentTerm) throws IOException {
        BytesRef t2 = this.initialSeekTerm;
        this.initialSeekTerm = null;
        return t2;
    }

    @Override
    public AttributeSource attributes() {
        return this.tenum.attributes();
    }

    @Override
    public BytesRef term() throws IOException {
        return this.tenum.term();
    }

    @Override
    public int docFreq() throws IOException {
        return this.tenum.docFreq();
    }

    @Override
    public long totalTermFreq() throws IOException {
        return this.tenum.totalTermFreq();
    }

    @Override
    public boolean seekExact(BytesRef term) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support seeking");
    }

    @Override
    public TermsEnum.SeekStatus seekCeil(BytesRef term) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support seeking");
    }

    @Override
    public void seekExact(long ord) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support seeking");
    }

    @Override
    public long ord() throws IOException {
        return this.tenum.ord();
    }

    @Override
    public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
        return this.tenum.postings(reuse, flags);
    }

    @Override
    public void seekExact(BytesRef term, TermState state) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support seeking");
    }

    @Override
    public TermState termState() throws IOException {
        assert (this.tenum != null);
        return this.tenum.termState();
    }

    @Override
    public BytesRef next() throws IOException {
        while (true) {
            if (this.doSeek) {
                this.doSeek = false;
                BytesRef t2 = this.nextSeekTerm(this.actualTerm);
                assert (this.actualTerm == null || t2 == null || t2.compareTo(this.actualTerm) > 0) : "curTerm=" + this.actualTerm + " seekTerm=" + t2;
                if (t2 == null || this.tenum.seekCeil(t2) == TermsEnum.SeekStatus.END) {
                    return null;
                }
                this.actualTerm = this.tenum.term();
            } else {
                this.actualTerm = this.tenum.next();
                if (this.actualTerm == null) {
                    return null;
                }
            }
            switch (this.accept(this.actualTerm)) {
                case YES_AND_SEEK: {
                    this.doSeek = true;
                }
                case YES: {
                    return this.actualTerm;
                }
                case NO_AND_SEEK: {
                    this.doSeek = true;
                    break;
                }
                case END: {
                    return null;
                }
            }
        }
    }

    protected static enum AcceptStatus {
        YES,
        YES_AND_SEEK,
        NO,
        NO_AND_SEEK,
        END;

    }
}

