/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.payloads;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.payloads.PayloadSpanCollector;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.search.spans.SpanWeight;
import org.apache.lucene.search.spans.Spans;

public class PayloadSpanUtil {
    private IndexReaderContext context;

    public PayloadSpanUtil(IndexReaderContext context) {
        this.context = context;
    }

    public Collection<byte[]> getPayloadsForQuery(Query query) throws IOException {
        ArrayList<byte[]> payloads = new ArrayList<byte[]>();
        this.queryToSpanQuery(query, payloads);
        return payloads;
    }

    private void queryToSpanQuery(Query query, Collection<byte[]> payloads) throws IOException {
        if (query instanceof BooleanQuery) {
            for (BooleanClause clause : (BooleanQuery)query) {
                if (clause.isProhibited()) continue;
                this.queryToSpanQuery(clause.getQuery(), payloads);
            }
        } else if (query instanceof PhraseQuery) {
            Term[] phraseQueryTerms = ((PhraseQuery)query).getTerms();
            SpanQuery[] clauses = new SpanQuery[phraseQueryTerms.length];
            for (int i2 = 0; i2 < phraseQueryTerms.length; ++i2) {
                clauses[i2] = new SpanTermQuery(phraseQueryTerms[i2]);
            }
            int slop = ((PhraseQuery)query).getSlop();
            boolean inorder = false;
            if (slop == 0) {
                inorder = true;
            }
            SpanNearQuery sp = new SpanNearQuery(clauses, slop, inorder);
            this.getPayloads(payloads, sp);
        } else if (query instanceof TermQuery) {
            SpanTermQuery stq = new SpanTermQuery(((TermQuery)query).getTerm());
            this.getPayloads(payloads, stq);
        } else if (query instanceof SpanQuery) {
            this.getPayloads(payloads, (SpanQuery)query);
        } else if (query instanceof DisjunctionMaxQuery) {
            Iterator<Query> iterator = ((DisjunctionMaxQuery)query).iterator();
            while (iterator.hasNext()) {
                this.queryToSpanQuery(iterator.next(), payloads);
            }
        } else if (query instanceof MultiPhraseQuery) {
            MultiPhraseQuery mpq = (MultiPhraseQuery)query;
            Term[][] termArrays = mpq.getTermArrays();
            int[] positions = mpq.getPositions();
            if (positions.length > 0) {
                int maxPosition = positions[positions.length - 1];
                for (int i3 = 0; i3 < positions.length - 1; ++i3) {
                    if (positions[i3] <= maxPosition) continue;
                    maxPosition = positions[i3];
                }
                List[] disjunctLists = new List[maxPosition + 1];
                int distinctPositions = 0;
                for (int i4 = 0; i4 < termArrays.length; ++i4) {
                    Term[] termArray = termArrays[i4];
                    ArrayList<SpanTermQuery> disjuncts = disjunctLists[positions[i4]];
                    if (disjuncts == null) {
                        ArrayList<SpanTermQuery> arrayList = new ArrayList<SpanTermQuery>(termArray.length);
                        disjunctLists[positions[i4]] = arrayList;
                        disjuncts = arrayList;
                        ++distinctPositions;
                    }
                    for (Term term : termArray) {
                        disjuncts.add(new SpanTermQuery(term));
                    }
                }
                int positionGaps = 0;
                int position = 0;
                SpanQuery[] clauses = new SpanQuery[distinctPositions];
                for (int i5 = 0; i5 < disjunctLists.length; ++i5) {
                    List disjuncts = disjunctLists[i5];
                    if (disjuncts != null) {
                        clauses[position++] = new SpanOrQuery(disjuncts.toArray(new SpanQuery[disjuncts.size()]));
                        continue;
                    }
                    ++positionGaps;
                }
                int slop = mpq.getSlop();
                boolean inorder = slop == 0;
                SpanNearQuery sp = new SpanNearQuery(clauses, slop + positionGaps, inorder);
                this.getPayloads(payloads, sp);
            }
        }
    }

    private void getPayloads(Collection<byte[]> payloads, SpanQuery query) throws IOException {
        IndexSearcher searcher = new IndexSearcher(this.context);
        searcher.setQueryCache(null);
        SpanWeight w2 = (SpanWeight)searcher.createNormalizedWeight(query, false);
        PayloadSpanCollector collector = new PayloadSpanCollector();
        for (LeafReaderContext leafReaderContext : this.context.leaves()) {
            Spans spans = w2.getSpans(leafReaderContext, SpanWeight.Postings.PAYLOADS);
            if (spans == null) continue;
            while (spans.nextDoc() != Integer.MAX_VALUE) {
                while (spans.nextStartPosition() != Integer.MAX_VALUE) {
                    collector.reset();
                    spans.collect(collector);
                    payloads.addAll(collector.getPayloads());
                }
            }
        }
    }
}

