/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.flexible.standard;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.apache.lucene.queryparser.flexible.standard.StandardQueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;

public final class QueryParserUtil {
    public static Query parse(String[] queries, String[] fields, Analyzer analyzer) throws QueryNodeException {
        if (queries.length != fields.length) {
            throw new IllegalArgumentException("queries.length != fields.length");
        }
        BooleanQuery.Builder bQuery = new BooleanQuery.Builder();
        StandardQueryParser qp = new StandardQueryParser();
        qp.setAnalyzer(analyzer);
        for (int i2 = 0; i2 < fields.length; ++i2) {
            Query q2 = qp.parse(queries[i2], fields[i2]);
            if (q2 == null) continue;
            bQuery.add(q2, BooleanClause.Occur.SHOULD);
        }
        return bQuery.build();
    }

    public static Query parse(String query, String[] fields, BooleanClause.Occur[] flags, Analyzer analyzer) throws QueryNodeException {
        if (fields.length != flags.length) {
            throw new IllegalArgumentException("fields.length != flags.length");
        }
        BooleanQuery.Builder bQuery = new BooleanQuery.Builder();
        StandardQueryParser qp = new StandardQueryParser();
        qp.setAnalyzer(analyzer);
        for (int i2 = 0; i2 < fields.length; ++i2) {
            Query q2 = qp.parse(query, fields[i2]);
            if (q2 == null) continue;
            bQuery.add(q2, flags[i2]);
        }
        return bQuery.build();
    }

    public static Query parse(String[] queries, String[] fields, BooleanClause.Occur[] flags, Analyzer analyzer) throws QueryNodeException {
        if (queries.length != fields.length || queries.length != flags.length) {
            throw new IllegalArgumentException("queries, fields, and flags array have have different length");
        }
        BooleanQuery.Builder bQuery = new BooleanQuery.Builder();
        StandardQueryParser qp = new StandardQueryParser();
        qp.setAnalyzer(analyzer);
        for (int i2 = 0; i2 < fields.length; ++i2) {
            Query q2 = qp.parse(queries[i2], fields[i2]);
            if (q2 == null) continue;
            bQuery.add(q2, flags[i2]);
        }
        return bQuery.build();
    }

    public static String escape(String s2) {
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            char c2 = s2.charAt(i2);
            if (c2 == '\\' || c2 == '+' || c2 == '-' || c2 == '!' || c2 == '(' || c2 == ')' || c2 == ':' || c2 == '^' || c2 == '[' || c2 == ']' || c2 == '\"' || c2 == '{' || c2 == '}' || c2 == '~' || c2 == '*' || c2 == '?' || c2 == '|' || c2 == '&' || c2 == '/') {
                sb.append('\\');
            }
            sb.append(c2);
        }
        return sb.toString();
    }
}

