/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanWeight;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Multiset;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Weight;

public class BooleanQuery
extends Query
implements Iterable<BooleanClause> {
    private static int maxClauseCount = 1024;
    private final int minimumNumberShouldMatch;
    private final List<BooleanClause> clauses;
    private final Map<BooleanClause.Occur, Collection<Query>> clauseSets;
    private int hashCode;

    public static int getMaxClauseCount() {
        return maxClauseCount;
    }

    public static void setMaxClauseCount(int maxClauseCount) {
        if (maxClauseCount < 1) {
            throw new IllegalArgumentException("maxClauseCount must be >= 1");
        }
        BooleanQuery.maxClauseCount = maxClauseCount;
    }

    private BooleanQuery(int minimumNumberShouldMatch, BooleanClause[] clauses) {
        this.minimumNumberShouldMatch = minimumNumberShouldMatch;
        this.clauses = Collections.unmodifiableList(Arrays.asList(clauses));
        this.clauseSets = new EnumMap<BooleanClause.Occur, Collection<Query>>(BooleanClause.Occur.class);
        this.clauseSets.put(BooleanClause.Occur.SHOULD, new Multiset());
        this.clauseSets.put(BooleanClause.Occur.MUST, new Multiset());
        this.clauseSets.put(BooleanClause.Occur.FILTER, new HashSet());
        this.clauseSets.put(BooleanClause.Occur.MUST_NOT, new HashSet());
        for (BooleanClause clause : clauses) {
            this.clauseSets.get((Object)clause.getOccur()).add(clause.getQuery());
        }
    }

    public int getMinimumNumberShouldMatch() {
        return this.minimumNumberShouldMatch;
    }

    public List<BooleanClause> clauses() {
        return this.clauses;
    }

    Collection<Query> getClauses(BooleanClause.Occur occur) {
        return this.clauseSets.get((Object)occur);
    }

    @Override
    public final Iterator<BooleanClause> iterator() {
        return this.clauses.iterator();
    }

    private BooleanQuery rewriteNoScoring() {
        Builder newQuery = new Builder();
        newQuery.setMinimumNumberShouldMatch(this.getMinimumNumberShouldMatch());
        for (BooleanClause clause : this.clauses) {
            if (clause.getOccur() == BooleanClause.Occur.MUST) {
                newQuery.add(clause.getQuery(), BooleanClause.Occur.FILTER);
                continue;
            }
            newQuery.add(clause);
        }
        return newQuery.build();
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        BooleanQuery query = this;
        if (!needsScores) {
            query = this.rewriteNoScoring();
        }
        return new BooleanWeight(query, searcher, needsScores, boost);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query query;
        BoostQuery bq;
        Collection<Query> filters;
        boolean bl;
        boolean bl2;
        if (this.clauses.size() == 0) {
            return new MatchNoDocsQuery("empty BooleanQuery");
        }
        if (this.clauses.size() == 1) {
            BooleanClause c2 = this.clauses.get(0);
            Query query2 = c2.getQuery();
            if (this.minimumNumberShouldMatch == 1 && c2.getOccur() == BooleanClause.Occur.SHOULD) {
                return query2;
            }
            if (this.minimumNumberShouldMatch == 0) {
                switch (c2.getOccur()) {
                    case SHOULD: 
                    case MUST: {
                        return query2;
                    }
                    case FILTER: {
                        return new BoostQuery(new ConstantScoreQuery(query2), 0.0f);
                    }
                    case MUST_NOT: {
                        return new MatchNoDocsQuery("pure negative BooleanQuery");
                    }
                }
                throw new AssertionError();
            }
        }
        Builder builder2 = new Builder();
        builder2.setMinimumNumberShouldMatch(this.getMinimumNumberShouldMatch());
        boolean actuallyRewritten = false;
        for (BooleanClause booleanClause : this) {
            Query query2 = booleanClause.getQuery();
            Query rewritten = query2.rewrite(reader);
            if (rewritten != query2) {
                actuallyRewritten = true;
            }
            builder2.add(rewritten, booleanClause.getOccur());
        }
        if (actuallyRewritten) {
            return builder2.build();
        }
        int clauseCount = 0;
        for (Collection<Query> collection : this.clauseSets.values()) {
            clauseCount += collection.size();
        }
        if (clauseCount != this.clauses.size()) {
            Builder rewritten = new Builder();
            rewritten.setMinimumNumberShouldMatch(this.minimumNumberShouldMatch);
            for (Map.Entry<BooleanClause.Occur, Collection<Query>> entry : this.clauseSets.entrySet()) {
                BooleanClause.Occur occur = entry.getKey();
                for (Query query4 : entry.getValue()) {
                    rewritten.add(query4, occur);
                }
            }
            return rewritten.build();
        }
        Collection<Query> mustNotClauses = this.clauseSets.get((Object)BooleanClause.Occur.MUST_NOT);
        if (!mustNotClauses.isEmpty()) {
            Predicate<Query> p2 = this.clauseSets.get((Object)BooleanClause.Occur.MUST)::contains;
            if (mustNotClauses.stream().anyMatch(p2.or(this.clauseSets.get((Object)BooleanClause.Occur.FILTER)::contains))) {
                return new MatchNoDocsQuery("FILTER or MUST clause also in MUST_NOT");
            }
            if (mustNotClauses.contains(new MatchAllDocsQuery())) {
                return new MatchNoDocsQuery("MUST_NOT clause is MatchAllDocsQuery");
            }
        }
        if (this.clauseSets.get((Object)BooleanClause.Occur.MUST).size() > 0 && this.clauseSets.get((Object)BooleanClause.Occur.FILTER).size() > 0 && (bl2 = (bl = (filters = new HashSet<Query>(this.clauseSets.get((Object)BooleanClause.Occur.FILTER))).remove(new MatchAllDocsQuery())) | filters.removeAll(this.clauseSets.get((Object)BooleanClause.Occur.MUST)))) {
            Builder builder = new Builder();
            builder.setMinimumNumberShouldMatch(this.getMinimumNumberShouldMatch());
            for (BooleanClause clause : this.clauses) {
                if (clause.getOccur() == BooleanClause.Occur.FILTER) continue;
                builder.add(clause);
            }
            for (Query filter : filters) {
                builder.add(filter, BooleanClause.Occur.FILTER);
            }
            return builder.build();
        }
        if (this.clauseSets.get((Object)BooleanClause.Occur.SHOULD).size() > 0 && this.clauseSets.get((Object)BooleanClause.Occur.FILTER).size() > 0) {
            filters = this.clauseSets.get((Object)BooleanClause.Occur.FILTER);
            Collection<Query> collection = this.clauseSets.get((Object)BooleanClause.Occur.SHOULD);
            HashSet<Query> hashSet = new HashSet<Query>(filters);
            hashSet.retainAll(collection);
            if (!hashSet.isEmpty()) {
                Builder builder = new Builder();
                int minShouldMatch = this.getMinimumNumberShouldMatch();
                for (BooleanClause clause : this.clauses) {
                    if (hashSet.contains(clause.getQuery())) {
                        if (clause.getOccur() != BooleanClause.Occur.SHOULD) continue;
                        builder.add(new BooleanClause(clause.getQuery(), BooleanClause.Occur.MUST));
                        --minShouldMatch;
                        continue;
                    }
                    builder.add(clause);
                }
                builder.setMinimumNumberShouldMatch(Math.max(0, minShouldMatch));
                return builder.build();
            }
        }
        if (this.clauseSets.get((Object)BooleanClause.Occur.SHOULD).size() > 0 && this.minimumNumberShouldMatch <= 1) {
            HashMap<void, Double> shouldClauses = new HashMap<void, Double>();
            for (Query query3 : this.clauseSets.get((Object)BooleanClause.Occur.SHOULD)) {
                void var5_31;
                double d2 = 1.0;
                while (var5_31 instanceof BoostQuery) {
                    bq = (BoostQuery)var5_31;
                    d2 *= (double)bq.getBoost();
                    Query query4 = bq.getQuery();
                }
                shouldClauses.put(var5_31, shouldClauses.getOrDefault(var5_31, 0.0) + d2);
            }
            if (shouldClauses.size() != this.clauseSets.get((Object)BooleanClause.Occur.SHOULD).size()) {
                Builder builder = new Builder().setMinimumNumberShouldMatch(this.minimumNumberShouldMatch);
                for (Map.Entry entry : shouldClauses.entrySet()) {
                    query = (Query)entry.getKey();
                    float boost = ((Double)entry.getValue()).floatValue();
                    if (boost != 1.0f) {
                        query = new BoostQuery(query, boost);
                    }
                    builder.add(query, BooleanClause.Occur.SHOULD);
                }
                for (BooleanClause booleanClause : this.clauses) {
                    if (booleanClause.getOccur() == BooleanClause.Occur.SHOULD) continue;
                    builder.add(booleanClause);
                }
                return builder.build();
            }
        }
        if (this.clauseSets.get((Object)BooleanClause.Occur.MUST).size() > 0) {
            HashMap<void, Double> mustClauses = new HashMap<void, Double>();
            for (Query query5 : this.clauseSets.get((Object)BooleanClause.Occur.MUST)) {
                void var5_37;
                double d3 = 1.0;
                while (var5_37 instanceof BoostQuery) {
                    bq = (BoostQuery)var5_37;
                    d3 *= (double)bq.getBoost();
                    Query query6 = bq.getQuery();
                }
                mustClauses.put(var5_37, mustClauses.getOrDefault(var5_37, 0.0) + d3);
            }
            if (mustClauses.size() != this.clauseSets.get((Object)BooleanClause.Occur.MUST).size()) {
                Builder builder = new Builder().setMinimumNumberShouldMatch(this.minimumNumberShouldMatch);
                for (Map.Entry entry : mustClauses.entrySet()) {
                    query = (Query)entry.getKey();
                    float boost = ((Double)entry.getValue()).floatValue();
                    if (boost != 1.0f) {
                        query = new BoostQuery(query, boost);
                    }
                    builder.add(query, BooleanClause.Occur.MUST);
                }
                for (BooleanClause booleanClause : this.clauses) {
                    if (booleanClause.getOccur() == BooleanClause.Occur.MUST) continue;
                    builder.add(booleanClause);
                }
                return builder.build();
            }
        }
        Collection<Query> musts = this.clauseSets.get((Object)BooleanClause.Occur.MUST);
        Collection<Query> collection = this.clauseSets.get((Object)BooleanClause.Occur.FILTER);
        if (musts.size() == 1 && collection.size() > 0) {
            void var5_43;
            Query query7 = musts.iterator().next();
            float f2 = 1.0f;
            if (query7 instanceof BoostQuery) {
                BoostQuery boostQuery = (BoostQuery)query7;
                Query query8 = boostQuery.getQuery();
                f2 = boostQuery.getBoost();
            }
            if (var5_43.getClass() == MatchAllDocsQuery.class) {
                Builder builder5 = new Builder();
                for (BooleanClause clause : this.clauses) {
                    switch (clause.getOccur()) {
                        case FILTER: 
                        case MUST_NOT: {
                            builder5.add(clause);
                            break;
                        }
                    }
                }
                Query rewritten = builder5.build();
                rewritten = new ConstantScoreQuery(rewritten);
                if (f2 != 1.0f) {
                    rewritten = new BoostQuery(rewritten, f2);
                }
                builder5 = new Builder().setMinimumNumberShouldMatch(this.getMinimumNumberShouldMatch()).add(rewritten, BooleanClause.Occur.MUST);
                for (Query query6 : this.clauseSets.get((Object)BooleanClause.Occur.SHOULD)) {
                    builder5.add(query6, BooleanClause.Occur.SHOULD);
                }
                rewritten = builder5.build();
                return rewritten;
            }
        }
        return super.rewrite(reader);
    }

    @Override
    public String toString(String field) {
        boolean needParens;
        StringBuilder buffer = new StringBuilder();
        boolean bl = needParens = this.getMinimumNumberShouldMatch() > 0;
        if (needParens) {
            buffer.append("(");
        }
        int i2 = 0;
        for (BooleanClause c2 : this) {
            buffer.append(c2.getOccur().toString());
            Query subQuery = c2.getQuery();
            if (subQuery instanceof BooleanQuery) {
                buffer.append("(");
                buffer.append(subQuery.toString(field));
                buffer.append(")");
            } else {
                buffer.append(subQuery.toString(field));
            }
            if (i2 != this.clauses.size() - 1) {
                buffer.append(" ");
            }
            ++i2;
        }
        if (needParens) {
            buffer.append(")");
        }
        if (this.getMinimumNumberShouldMatch() > 0) {
            buffer.append('~');
            buffer.append(this.getMinimumNumberShouldMatch());
        }
        return buffer.toString();
    }

    @Override
    public boolean equals(Object o2) {
        return this.sameClassAs(o2) && this.equalsTo((BooleanQuery)this.getClass().cast(o2));
    }

    private boolean equalsTo(BooleanQuery other) {
        return this.getMinimumNumberShouldMatch() == other.getMinimumNumberShouldMatch() && this.clauseSets.equals(other.clauseSets);
    }

    private int computeHashCode() {
        int hashCode = Objects.hash(this.minimumNumberShouldMatch, this.clauseSets);
        if (hashCode == 0) {
            hashCode = 1;
        }
        return hashCode;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.computeHashCode();
            assert (this.hashCode != 0);
        }
        assert (this.hashCode == this.computeHashCode());
        return this.hashCode;
    }

    public static class Builder {
        private int minimumNumberShouldMatch;
        private final List<BooleanClause> clauses = new ArrayList<BooleanClause>();

        public Builder setMinimumNumberShouldMatch(int min2) {
            this.minimumNumberShouldMatch = min2;
            return this;
        }

        public Builder add(BooleanClause clause) {
            if (this.clauses.size() >= maxClauseCount) {
                throw new TooManyClauses();
            }
            this.clauses.add(clause);
            return this;
        }

        public Builder add(Query query, BooleanClause.Occur occur) {
            return this.add(new BooleanClause(query, occur));
        }

        public BooleanQuery build() {
            return new BooleanQuery(this.minimumNumberShouldMatch, this.clauses.toArray(new BooleanClause[0]));
        }
    }

    public static class TooManyClauses
    extends RuntimeException {
        public TooManyClauses() {
            super("maxClauseCount is set to " + maxClauseCount);
        }
    }
}

