/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Boolean2ScorerSupplier;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BooleanScorer;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.DisjunctionSumScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FakeScorer;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.ReqExclBulkScorer;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.Bits;

final class BooleanWeight
extends Weight {
    final Similarity similarity;
    final BooleanQuery query;
    final ArrayList<Weight> weights;
    final boolean needsScores;

    BooleanWeight(BooleanQuery query, IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        super(query);
        this.query = query;
        this.needsScores = needsScores;
        this.similarity = searcher.getSimilarity(needsScores);
        this.weights = new ArrayList();
        for (BooleanClause c2 : query) {
            Weight w2 = searcher.createWeight(c2.getQuery(), needsScores && c2.isScoring(), boost);
            this.weights.add(w2);
        }
    }

    @Override
    public void extractTerms(Set<Term> terms) {
        int i2 = 0;
        for (BooleanClause clause : this.query) {
            if (clause.isScoring() || !this.needsScores && !clause.isProhibited()) {
                this.weights.get(i2).extractTerms(terms);
            }
            ++i2;
        }
    }

    @Override
    public Explanation explain(LeafReaderContext context, int doc) throws IOException {
        int minShouldMatch = this.query.getMinimumNumberShouldMatch();
        ArrayList<Explanation> subs = new ArrayList<Explanation>();
        float sum = 0.0f;
        boolean fail = false;
        int matchCount = 0;
        int shouldMatchCount = 0;
        Iterator<BooleanClause> cIter = this.query.iterator();
        for (Weight w2 : this.weights) {
            BooleanClause c2 = cIter.next();
            Explanation e2 = w2.explain(context, doc);
            if (e2.isMatch()) {
                if (c2.isScoring()) {
                    subs.add(e2);
                    sum += e2.getValue();
                } else if (c2.isRequired()) {
                    subs.add(Explanation.match(0.0f, "match on required clause, product of:", Explanation.match(0.0f, (Object)((Object)BooleanClause.Occur.FILTER) + " clause", new Explanation[0]), e2));
                } else if (c2.isProhibited()) {
                    subs.add(Explanation.noMatch("match on prohibited clause (" + c2.getQuery().toString() + ")", e2));
                    fail = true;
                }
                if (!c2.isProhibited()) {
                    ++matchCount;
                }
                if (c2.getOccur() != BooleanClause.Occur.SHOULD) continue;
                ++shouldMatchCount;
                continue;
            }
            if (!c2.isRequired()) continue;
            subs.add(Explanation.noMatch("no match on required clause (" + c2.getQuery().toString() + ")", e2));
            fail = true;
        }
        if (fail) {
            return Explanation.noMatch("Failure to meet condition(s) of required/prohibited clause(s)", subs);
        }
        if (matchCount == 0) {
            return Explanation.noMatch("No matching clauses", subs);
        }
        if (shouldMatchCount < minShouldMatch) {
            return Explanation.noMatch("Failure to match minimum number of optional clauses: " + minShouldMatch, subs);
        }
        return Explanation.match(sum, "sum of:", subs);
    }

    static BulkScorer disableScoring(final BulkScorer scorer) {
        return new BulkScorer(){

            @Override
            public int score(final LeafCollector collector, Bits acceptDocs, int min2, int max) throws IOException {
                LeafCollector noScoreCollector = new LeafCollector(){
                    FakeScorer fake = new FakeScorer();

                    @Override
                    public void setScorer(Scorer scorer) throws IOException {
                        collector.setScorer(this.fake);
                    }

                    @Override
                    public void collect(int doc) throws IOException {
                        this.fake.doc = doc;
                        collector.collect(doc);
                    }
                };
                return scorer.score(noScoreCollector, acceptDocs, min2, max);
            }

            @Override
            public long cost() {
                return scorer.cost();
            }
        };
    }

    BulkScorer optionalBulkScorer(LeafReaderContext context) throws IOException {
        ArrayList<BulkScorer> optional = new ArrayList<BulkScorer>();
        Iterator<BooleanClause> cIter = this.query.iterator();
        for (Weight w2 : this.weights) {
            BulkScorer subScorer;
            BooleanClause c2 = cIter.next();
            if (c2.getOccur() != BooleanClause.Occur.SHOULD || (subScorer = w2.bulkScorer(context)) == null) continue;
            optional.add(subScorer);
        }
        if (optional.size() == 0) {
            return null;
        }
        if (this.query.getMinimumNumberShouldMatch() > optional.size()) {
            return null;
        }
        if (optional.size() == 1) {
            return (BulkScorer)optional.get(0);
        }
        return new BooleanScorer(this, optional, Math.max(1, this.query.getMinimumNumberShouldMatch()), this.needsScores);
    }

    private BulkScorer requiredBulkScorer(LeafReaderContext context) throws IOException {
        BulkScorer scorer = null;
        Iterator<BooleanClause> cIter = this.query.iterator();
        for (Weight w2 : this.weights) {
            BooleanClause c2 = cIter.next();
            if (!c2.isRequired()) continue;
            if (scorer != null) {
                return null;
            }
            scorer = w2.bulkScorer(context);
            if (scorer == null) {
                return null;
            }
            if (c2.isScoring() || !this.needsScores) continue;
            scorer = BooleanWeight.disableScoring(scorer);
        }
        return scorer;
    }

    BulkScorer booleanScorer(LeafReaderContext context) throws IOException {
        Scorer prohibitedScorer;
        BulkScorer positiveScorer;
        int numOptionalClauses = this.query.getClauses(BooleanClause.Occur.SHOULD).size();
        int numRequiredClauses = this.query.getClauses(BooleanClause.Occur.MUST).size() + this.query.getClauses(BooleanClause.Occur.FILTER).size();
        if (numRequiredClauses == 0) {
            positiveScorer = this.optionalBulkScorer(context);
            if (positiveScorer == null) {
                return null;
            }
            long costThreshold = this.query.getMinimumNumberShouldMatch() <= 1 ? -1L : (long)(context.reader().maxDoc() / 3);
            if (positiveScorer.cost() < costThreshold) {
                return null;
            }
        } else if (numRequiredClauses == 1 && numOptionalClauses == 0 && this.query.getMinimumNumberShouldMatch() == 0) {
            positiveScorer = this.requiredBulkScorer(context);
        } else {
            return null;
        }
        if (positiveScorer == null) {
            return null;
        }
        ArrayList<Scorer> prohibited = new ArrayList<Scorer>();
        Iterator<BooleanClause> cIter = this.query.iterator();
        for (Weight w2 : this.weights) {
            Scorer scorer;
            BooleanClause c2 = cIter.next();
            if (!c2.isProhibited() || (scorer = w2.scorer(context)) == null) continue;
            prohibited.add(scorer);
        }
        if (prohibited.isEmpty()) {
            return positiveScorer;
        }
        Scorer scorer = prohibitedScorer = prohibited.size() == 1 ? (Scorer)prohibited.get(0) : new DisjunctionSumScorer(this, prohibited, false);
        if (prohibitedScorer.twoPhaseIterator() != null) {
            return null;
        }
        return new ReqExclBulkScorer(positiveScorer, prohibitedScorer.iterator());
    }

    @Override
    public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
        BulkScorer bulkScorer = this.booleanScorer(context);
        if (bulkScorer != null) {
            return bulkScorer;
        }
        return super.bulkScorer(context);
    }

    @Override
    public Scorer scorer(LeafReaderContext context) throws IOException {
        ScorerSupplier scorerSupplier = this.scorerSupplier(context);
        if (scorerSupplier == null) {
            return null;
        }
        return scorerSupplier.get(Long.MAX_VALUE);
    }

    @Override
    public boolean isCacheable(LeafReaderContext ctx) {
        if (this.weights.size() > 16) {
            return false;
        }
        for (Weight w2 : this.weights) {
            if (w2.isCacheable(ctx)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
        int minShouldMatch = this.query.getMinimumNumberShouldMatch();
        EnumMap<BooleanClause.Occur, Collection<ScorerSupplier>> scorers = new EnumMap<BooleanClause.Occur, Collection<ScorerSupplier>>(BooleanClause.Occur.class);
        for (BooleanClause.Occur occur : BooleanClause.Occur.values()) {
            scorers.put(occur, new ArrayList());
        }
        Iterator<BooleanClause> cIter = this.query.iterator();
        for (Weight w2 : this.weights) {
            BooleanClause c2 = cIter.next();
            ScorerSupplier subScorer = w2.scorerSupplier(context);
            if (subScorer == null) {
                if (!c2.isRequired()) continue;
                return null;
            }
            ((Collection)scorers.get((Object)c2.getOccur())).add(subScorer);
        }
        if (((Collection)scorers.get((Object)BooleanClause.Occur.SHOULD)).size() == minShouldMatch) {
            ((Collection)scorers.get((Object)BooleanClause.Occur.MUST)).addAll((Collection)scorers.get((Object)BooleanClause.Occur.SHOULD));
            ((Collection)scorers.get((Object)BooleanClause.Occur.SHOULD)).clear();
            minShouldMatch = 0;
        }
        if (((Collection)scorers.get((Object)BooleanClause.Occur.FILTER)).isEmpty() && ((Collection)scorers.get((Object)BooleanClause.Occur.MUST)).isEmpty() && ((Collection)scorers.get((Object)BooleanClause.Occur.SHOULD)).isEmpty()) {
            return null;
        }
        if (((Collection)scorers.get((Object)BooleanClause.Occur.SHOULD)).size() < minShouldMatch) {
            return null;
        }
        if (!this.needsScores && minShouldMatch == 0 && ((Collection)scorers.get((Object)BooleanClause.Occur.MUST)).size() + ((Collection)scorers.get((Object)BooleanClause.Occur.FILTER)).size() > 0) {
            ((Collection)scorers.get((Object)BooleanClause.Occur.SHOULD)).clear();
        }
        return new Boolean2ScorerSupplier(this, scorers, this.needsScores, minShouldMatch);
    }
}

