/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.search.DisiWrapper;
import org.apache.lucene.search.DisjunctionScorer;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

final class DisjunctionMaxScorer
extends DisjunctionScorer {
    private final float tieBreakerMultiplier;

    DisjunctionMaxScorer(Weight weight, float tieBreakerMultiplier, List<Scorer> subScorers, boolean needsScores) {
        super(weight, subScorers, needsScores);
        this.tieBreakerMultiplier = tieBreakerMultiplier;
    }

    @Override
    protected float score(DisiWrapper topList) throws IOException {
        float scoreSum = 0.0f;
        float scoreMax = Float.NEGATIVE_INFINITY;
        DisiWrapper w2 = topList;
        while (w2 != null) {
            float subScore = w2.scorer.score();
            scoreSum += subScore;
            if (subScore > scoreMax) {
                scoreMax = subScore;
            }
            w2 = w2.next;
        }
        return scoreMax + (scoreSum - scoreMax) * this.tieBreakerMultiplier;
    }
}

