/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorer;

public class MultiCollectorManager
implements CollectorManager<Collectors, Object[]> {
    private final CollectorManager<Collector, ?>[] collectorManagers;

    @SafeVarargs
    public MultiCollectorManager(CollectorManager<? extends Collector, ?> ... collectorManagers) {
        this.collectorManagers = collectorManagers;
    }

    @Override
    public Collectors newCollector() throws IOException {
        return new Collectors();
    }

    @Override
    public Object[] reduce(Collection<Collectors> reducableCollectors) throws IOException {
        int size = reducableCollectors.size();
        Object[] results = new Object[this.collectorManagers.length];
        for (int i2 = 0; i2 < this.collectorManagers.length; ++i2) {
            ArrayList<Collector> reducableCollector = new ArrayList<Collector>(size);
            for (Collectors collectors : reducableCollectors) {
                reducableCollector.add(collectors.collectors[i2]);
            }
            results[i2] = this.collectorManagers[i2].reduce(reducableCollector);
        }
        return results;
    }

    public class Collectors
    implements Collector {
        private final Collector[] collectors;

        private Collectors() throws IOException {
            this.collectors = new Collector[MultiCollectorManager.this.collectorManagers.length];
            for (int i2 = 0; i2 < this.collectors.length; ++i2) {
                this.collectors[i2] = MultiCollectorManager.this.collectorManagers[i2].newCollector();
            }
        }

        @Override
        public final LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
            return new LeafCollectors(context);
        }

        @Override
        public final boolean needsScores() {
            for (Collector collector : this.collectors) {
                if (!collector.needsScores()) continue;
                return true;
            }
            return false;
        }

        public class LeafCollectors
        implements LeafCollector {
            private final LeafCollector[] leafCollectors;

            private LeafCollectors(LeafReaderContext context) throws IOException {
                this.leafCollectors = new LeafCollector[Collectors.this.collectors.length];
                for (int i2 = 0; i2 < Collectors.this.collectors.length; ++i2) {
                    this.leafCollectors[i2] = Collectors.this.collectors[i2].getLeafCollector(context);
                }
            }

            @Override
            public final void setScorer(Scorer scorer) throws IOException {
                for (LeafCollector leafCollector : this.leafCollectors) {
                    if (leafCollector == null) continue;
                    leafCollector.setScorer(scorer);
                }
            }

            @Override
            public final void collect(int doc) throws IOException {
                for (LeafCollector leafCollector : this.leafCollectors) {
                    if (leafCollector == null) continue;
                    leafCollector.collect(doc);
                }
            }
        }
    }
}

