/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.SortField;

public class Sort {
    public static final Sort RELEVANCE = new Sort();
    public static final Sort INDEXORDER = new Sort(SortField.FIELD_DOC);
    SortField[] fields;

    public Sort() {
        this(SortField.FIELD_SCORE);
    }

    public Sort(SortField field) {
        this.setSort(field);
    }

    public Sort(SortField ... fields) {
        this.setSort(fields);
    }

    public void setSort(SortField field) {
        this.fields = new SortField[]{field};
    }

    public void setSort(SortField ... fields) {
        if (fields.length == 0) {
            throw new IllegalArgumentException("There must be at least 1 sort field");
        }
        this.fields = fields;
    }

    public SortField[] getSort() {
        return this.fields;
    }

    public Sort rewrite(IndexSearcher searcher) throws IOException {
        boolean changed = false;
        SortField[] rewrittenSortFields = new SortField[this.fields.length];
        for (int i2 = 0; i2 < this.fields.length; ++i2) {
            rewrittenSortFields[i2] = this.fields[i2].rewrite(searcher);
            if (this.fields[i2] == rewrittenSortFields[i2]) continue;
            changed = true;
        }
        return changed ? new Sort(rewrittenSortFields) : this;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (int i2 = 0; i2 < this.fields.length; ++i2) {
            buffer.append(this.fields[i2].toString());
            if (i2 + 1 >= this.fields.length) continue;
            buffer.append(',');
        }
        return buffer.toString();
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof Sort)) {
            return false;
        }
        Sort other = (Sort)o2;
        return Arrays.equals(this.fields, other.fields);
    }

    public int hashCode() {
        return 1168832101 + Arrays.hashCode(this.fields);
    }

    public boolean needsScores() {
        for (SortField sortField : this.fields) {
            if (!sortField.needsScores()) continue;
            return true;
        }
        return false;
    }
}

