/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.similarities;

import java.util.List;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.similarities.BasicStats;
import org.apache.lucene.search.similarities.SimilarityBase;

public abstract class Axiomatic
extends SimilarityBase {
    protected final float s;
    protected final float k;
    protected final int queryLen;

    public Axiomatic(float s2, int queryLen, float k2) {
        if (!Float.isFinite(s2) || Float.isNaN(s2) || s2 < 0.0f || s2 > 1.0f) {
            throw new IllegalArgumentException("illegal s value: " + s2 + ", must be between 0 and 1");
        }
        if (!Float.isFinite(k2) || Float.isNaN(k2) || k2 < 0.0f || k2 > 1.0f) {
            throw new IllegalArgumentException("illegal k value: " + k2 + ", must be between 0 and 1");
        }
        if (queryLen < 0 || queryLen > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("illegal query length value: " + queryLen + ", must be larger 0 and smaller than MAX_INT");
        }
        this.s = s2;
        this.queryLen = queryLen;
        this.k = k2;
    }

    public Axiomatic(float s2) {
        this(s2, 1, 0.35f);
    }

    public Axiomatic(float s2, int queryLen) {
        this(s2, queryLen, 0.35f);
    }

    public Axiomatic() {
        this(0.25f, 1, 0.35f);
    }

    @Override
    public float score(BasicStats stats, float freq, float docLen) {
        return this.tf(stats, freq, docLen) * this.ln(stats, freq, docLen) * this.tfln(stats, freq, docLen) * this.idf(stats, freq, docLen) - this.gamma(stats, freq, docLen);
    }

    @Override
    protected void explain(List<Explanation> subs, BasicStats stats, int doc, float freq, float docLen) {
        if (stats.getBoost() != 1.0f) {
            subs.add(Explanation.match(stats.getBoost(), "boost", new Explanation[0]));
        }
        subs.add(Explanation.match(this.k, "k", new Explanation[0]));
        subs.add(Explanation.match(this.s, "s", new Explanation[0]));
        subs.add(Explanation.match((float)this.queryLen, "queryLen", new Explanation[0]));
        subs.add(Explanation.match(this.tf(stats, freq, docLen), "tf", new Explanation[0]));
        subs.add(Explanation.match(this.ln(stats, freq, docLen), "ln", new Explanation[0]));
        subs.add(Explanation.match(this.tfln(stats, freq, docLen), "tfln", new Explanation[0]));
        subs.add(Explanation.match(this.idf(stats, freq, docLen), "idf", new Explanation[0]));
        subs.add(Explanation.match(this.gamma(stats, freq, docLen), "gamma", new Explanation[0]));
        super.explain(subs, stats, doc, freq, docLen);
    }

    @Override
    public abstract String toString();

    protected abstract float tf(BasicStats var1, float var2, float var3);

    protected abstract float ln(BasicStats var1, float var2, float var3);

    protected abstract float tfln(BasicStats var1, float var2, float var3);

    protected abstract float idf(BasicStats var1, float var2, float var3);

    protected abstract float gamma(BasicStats var1, float var2, float var3);
}

