/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.similarities;

import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.similarities.BasicModel;
import org.apache.lucene.search.similarities.BasicStats;
import org.apache.lucene.search.similarities.SimilarityBase;

public class BasicModelIn
extends BasicModel {
    @Override
    public final float score(BasicStats stats, float tfn) {
        long N2 = stats.getNumberOfDocuments();
        long n2 = stats.getDocFreq();
        return tfn * (float)SimilarityBase.log2((double)(N2 + 1L) / ((double)n2 + 0.5));
    }

    @Override
    public final Explanation explain(BasicStats stats, float tfn) {
        return Explanation.match(this.score(stats, tfn), this.getClass().getSimpleName() + ", computed from: ", Explanation.match((float)stats.getNumberOfDocuments(), "numberOfDocuments", new Explanation[0]), Explanation.match((float)stats.getDocFreq(), "docFreq", new Explanation[0]));
    }

    @Override
    public String toString() {
        return "I(n)";
    }
}

