/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.lucene.store.BufferedChecksum;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.IndexInput;

public class BufferedChecksumIndexInput
extends ChecksumIndexInput {
    final IndexInput main;
    final Checksum digest;

    public BufferedChecksumIndexInput(IndexInput main) {
        super("BufferedChecksumIndexInput(" + main + ")");
        this.main = main;
        this.digest = new BufferedChecksum(new CRC32());
    }

    @Override
    public byte readByte() throws IOException {
        byte b2 = this.main.readByte();
        this.digest.update(b2);
        return b2;
    }

    @Override
    public void readBytes(byte[] b2, int offset, int len) throws IOException {
        this.main.readBytes(b2, offset, len);
        this.digest.update(b2, offset, len);
    }

    @Override
    public long getChecksum() {
        return this.digest.getValue();
    }

    @Override
    public void close() throws IOException {
        this.main.close();
    }

    @Override
    public long getFilePointer() {
        return this.main.getFilePointer();
    }

    @Override
    public long length() {
        return this.main.length();
    }

    @Override
    public IndexInput clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
        throw new UnsupportedOperationException();
    }
}

