/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.BytesRef;

public final class ByteArrayDataInput
extends DataInput {
    private byte[] bytes;
    private int pos;
    private int limit;

    public ByteArrayDataInput(byte[] bytes) {
        this.reset(bytes);
    }

    public ByteArrayDataInput(byte[] bytes, int offset, int len) {
        this.reset(bytes, offset, len);
    }

    public ByteArrayDataInput() {
        this.reset(BytesRef.EMPTY_BYTES);
    }

    public void reset(byte[] bytes) {
        this.reset(bytes, 0, bytes.length);
    }

    public void rewind() {
        this.pos = 0;
    }

    public int getPosition() {
        return this.pos;
    }

    public void setPosition(int pos) {
        this.pos = pos;
    }

    public void reset(byte[] bytes, int offset, int len) {
        this.bytes = bytes;
        this.pos = offset;
        this.limit = offset + len;
    }

    public int length() {
        return this.limit;
    }

    public boolean eof() {
        return this.pos == this.limit;
    }

    @Override
    public void skipBytes(long count) {
        this.pos = (int)((long)this.pos + count);
    }

    @Override
    public short readShort() {
        return (short)((this.bytes[this.pos++] & 0xFF) << 8 | this.bytes[this.pos++] & 0xFF);
    }

    @Override
    public int readInt() {
        return (this.bytes[this.pos++] & 0xFF) << 24 | (this.bytes[this.pos++] & 0xFF) << 16 | (this.bytes[this.pos++] & 0xFF) << 8 | this.bytes[this.pos++] & 0xFF;
    }

    @Override
    public long readLong() {
        int i1 = (this.bytes[this.pos++] & 0xFF) << 24 | (this.bytes[this.pos++] & 0xFF) << 16 | (this.bytes[this.pos++] & 0xFF) << 8 | this.bytes[this.pos++] & 0xFF;
        int i2 = (this.bytes[this.pos++] & 0xFF) << 24 | (this.bytes[this.pos++] & 0xFF) << 16 | (this.bytes[this.pos++] & 0xFF) << 8 | this.bytes[this.pos++] & 0xFF;
        return (long)i1 << 32 | (long)i2 & 0xFFFFFFFFL;
    }

    @Override
    public int readVInt() {
        byte b2;
        if ((b2 = this.bytes[this.pos++]) >= 0) {
            return b2;
        }
        int i2 = b2 & 0x7F;
        b2 = this.bytes[this.pos++];
        i2 |= (b2 & 0x7F) << 7;
        if (b2 >= 0) {
            return i2;
        }
        b2 = this.bytes[this.pos++];
        i2 |= (b2 & 0x7F) << 14;
        if (b2 >= 0) {
            return i2;
        }
        b2 = this.bytes[this.pos++];
        i2 |= (b2 & 0x7F) << 21;
        if (b2 >= 0) {
            return i2;
        }
        b2 = this.bytes[this.pos++];
        i2 |= (b2 & 0xF) << 28;
        if ((b2 & 0xF0) == 0) {
            return i2;
        }
        throw new RuntimeException("Invalid vInt detected (too many bits)");
    }

    @Override
    public long readVLong() {
        byte b2;
        if ((b2 = this.bytes[this.pos++]) >= 0) {
            return b2;
        }
        long i2 = (long)b2 & 0x7FL;
        b2 = this.bytes[this.pos++];
        i2 |= ((long)b2 & 0x7FL) << 7;
        if (b2 >= 0) {
            return i2;
        }
        b2 = this.bytes[this.pos++];
        i2 |= ((long)b2 & 0x7FL) << 14;
        if (b2 >= 0) {
            return i2;
        }
        b2 = this.bytes[this.pos++];
        i2 |= ((long)b2 & 0x7FL) << 21;
        if (b2 >= 0) {
            return i2;
        }
        b2 = this.bytes[this.pos++];
        i2 |= ((long)b2 & 0x7FL) << 28;
        if (b2 >= 0) {
            return i2;
        }
        b2 = this.bytes[this.pos++];
        i2 |= ((long)b2 & 0x7FL) << 35;
        if (b2 >= 0) {
            return i2;
        }
        b2 = this.bytes[this.pos++];
        i2 |= ((long)b2 & 0x7FL) << 42;
        if (b2 >= 0) {
            return i2;
        }
        b2 = this.bytes[this.pos++];
        i2 |= ((long)b2 & 0x7FL) << 49;
        if (b2 >= 0) {
            return i2;
        }
        b2 = this.bytes[this.pos++];
        i2 |= ((long)b2 & 0x7FL) << 56;
        if (b2 >= 0) {
            return i2;
        }
        throw new RuntimeException("Invalid vLong detected (negative values disallowed)");
    }

    @Override
    public byte readByte() {
        return this.bytes[this.pos++];
    }

    @Override
    public void readBytes(byte[] b2, int offset, int len) {
        System.arraycopy(this.bytes, this.pos, b2, offset, len);
        this.pos += len;
    }
}

