/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import org.apache.lucene.store.IndexInput;

public final class ByteArrayIndexInput
extends IndexInput {
    private byte[] bytes;
    private int pos;
    private int limit;

    public ByteArrayIndexInput(String description, byte[] bytes) {
        super(description);
        this.bytes = bytes;
        this.limit = bytes.length;
    }

    @Override
    public long getFilePointer() {
        return this.pos;
    }

    @Override
    public void seek(long pos) {
        this.pos = (int)pos;
    }

    public void reset(byte[] bytes, int offset, int len) {
        this.bytes = bytes;
        this.pos = offset;
        this.limit = offset + len;
    }

    @Override
    public long length() {
        return this.limit;
    }

    public boolean eof() {
        return this.pos == this.limit;
    }

    @Override
    public void skipBytes(long count) {
        this.pos = (int)((long)this.pos + count);
    }

    @Override
    public short readShort() {
        return (short)((this.bytes[this.pos++] & 0xFF) << 8 | this.bytes[this.pos++] & 0xFF);
    }

    @Override
    public int readInt() {
        return (this.bytes[this.pos++] & 0xFF) << 24 | (this.bytes[this.pos++] & 0xFF) << 16 | (this.bytes[this.pos++] & 0xFF) << 8 | this.bytes[this.pos++] & 0xFF;
    }

    @Override
    public long readLong() {
        int i1 = (this.bytes[this.pos++] & 0xFF) << 24 | (this.bytes[this.pos++] & 0xFF) << 16 | (this.bytes[this.pos++] & 0xFF) << 8 | this.bytes[this.pos++] & 0xFF;
        int i2 = (this.bytes[this.pos++] & 0xFF) << 24 | (this.bytes[this.pos++] & 0xFF) << 16 | (this.bytes[this.pos++] & 0xFF) << 8 | this.bytes[this.pos++] & 0xFF;
        return (long)i1 << 32 | (long)i2 & 0xFFFFFFFFL;
    }

    @Override
    public int readVInt() {
        byte b2;
        if ((b2 = this.bytes[this.pos++]) >= 0) {
            return b2;
        }
        int i2 = b2 & 0x7F;
        b2 = this.bytes[this.pos++];
        i2 |= (b2 & 0x7F) << 7;
        if (b2 >= 0) {
            return i2;
        }
        b2 = this.bytes[this.pos++];
        i2 |= (b2 & 0x7F) << 14;
        if (b2 >= 0) {
            return i2;
        }
        b2 = this.bytes[this.pos++];
        i2 |= (b2 & 0x7F) << 21;
        if (b2 >= 0) {
            return i2;
        }
        b2 = this.bytes[this.pos++];
        i2 |= (b2 & 0xF) << 28;
        if ((b2 & 0xF0) == 0) {
            return i2;
        }
        throw new RuntimeException("Invalid vInt detected (too many bits)");
    }

    @Override
    public long readVLong() {
        byte b2;
        if ((b2 = this.bytes[this.pos++]) >= 0) {
            return b2;
        }
        long i2 = (long)b2 & 0x7FL;
        b2 = this.bytes[this.pos++];
        i2 |= ((long)b2 & 0x7FL) << 7;
        if (b2 >= 0) {
            return i2;
        }
        b2 = this.bytes[this.pos++];
        i2 |= ((long)b2 & 0x7FL) << 14;
        if (b2 >= 0) {
            return i2;
        }
        b2 = this.bytes[this.pos++];
        i2 |= ((long)b2 & 0x7FL) << 21;
        if (b2 >= 0) {
            return i2;
        }
        b2 = this.bytes[this.pos++];
        i2 |= ((long)b2 & 0x7FL) << 28;
        if (b2 >= 0) {
            return i2;
        }
        b2 = this.bytes[this.pos++];
        i2 |= ((long)b2 & 0x7FL) << 35;
        if (b2 >= 0) {
            return i2;
        }
        b2 = this.bytes[this.pos++];
        i2 |= ((long)b2 & 0x7FL) << 42;
        if (b2 >= 0) {
            return i2;
        }
        b2 = this.bytes[this.pos++];
        i2 |= ((long)b2 & 0x7FL) << 49;
        if (b2 >= 0) {
            return i2;
        }
        b2 = this.bytes[this.pos++];
        i2 |= ((long)b2 & 0x7FL) << 56;
        if (b2 >= 0) {
            return i2;
        }
        throw new RuntimeException("Invalid vLong detected (negative values disallowed)");
    }

    @Override
    public byte readByte() {
        return this.bytes[this.pos++];
    }

    @Override
    public void readBytes(byte[] b2, int offset, int len) {
        System.arraycopy(this.bytes, this.pos, b2, offset, len);
        this.pos += len;
    }

    @Override
    public void close() {
    }

    @Override
    public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
        throw new UnsupportedOperationException();
    }
}

