/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.BytesRef;

public abstract class DataOutput {
    private static int COPY_BUFFER_SIZE = 16384;
    private byte[] copyBuffer;

    public abstract void writeByte(byte var1) throws IOException;

    public void writeBytes(byte[] b2, int length) throws IOException {
        this.writeBytes(b2, 0, length);
    }

    public abstract void writeBytes(byte[] var1, int var2, int var3) throws IOException;

    public void writeInt(int i2) throws IOException {
        this.writeByte((byte)(i2 >> 24));
        this.writeByte((byte)(i2 >> 16));
        this.writeByte((byte)(i2 >> 8));
        this.writeByte((byte)i2);
    }

    public void writeShort(short i2) throws IOException {
        this.writeByte((byte)(i2 >> 8));
        this.writeByte((byte)i2);
    }

    public final void writeVInt(int i2) throws IOException {
        while ((i2 & 0xFFFFFF80) != 0) {
            this.writeByte((byte)(i2 & 0x7F | 0x80));
            i2 >>>= 7;
        }
        this.writeByte((byte)i2);
    }

    public final void writeZInt(int i2) throws IOException {
        this.writeVInt(BitUtil.zigZagEncode(i2));
    }

    public void writeLong(long i2) throws IOException {
        this.writeInt((int)(i2 >> 32));
        this.writeInt((int)i2);
    }

    public final void writeVLong(long i2) throws IOException {
        if (i2 < 0L) {
            throw new IllegalArgumentException("cannot write negative vLong (got: " + i2 + ")");
        }
        this.writeSignedVLong(i2);
    }

    private void writeSignedVLong(long i2) throws IOException {
        while ((i2 & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.writeByte((byte)(i2 & 0x7FL | 0x80L));
            i2 >>>= 7;
        }
        this.writeByte((byte)i2);
    }

    public final void writeZLong(long i2) throws IOException {
        this.writeSignedVLong(BitUtil.zigZagEncode(i2));
    }

    public void writeString(String s2) throws IOException {
        BytesRef utf8Result = new BytesRef(s2);
        this.writeVInt(utf8Result.length);
        this.writeBytes(utf8Result.bytes, utf8Result.offset, utf8Result.length);
    }

    public void copyBytes(DataInput input, long numBytes) throws IOException {
        assert (numBytes >= 0L) : "numBytes=" + numBytes;
        long left = numBytes;
        if (this.copyBuffer == null) {
            this.copyBuffer = new byte[COPY_BUFFER_SIZE];
        }
        while (left > 0L) {
            int toCopy = left > (long)COPY_BUFFER_SIZE ? COPY_BUFFER_SIZE : (int)left;
            input.readBytes(this.copyBuffer, 0, toCopy);
            this.writeBytes(this.copyBuffer, 0, toCopy);
            left -= (long)toCopy;
        }
    }

    public void writeMapOfStrings(Map<String, String> map) throws IOException {
        this.writeVInt(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.writeString(entry.getKey());
            this.writeString(entry.getValue());
        }
    }

    public void writeSetOfStrings(Set<String> set) throws IOException {
        this.writeVInt(set.size());
        for (String value : set) {
            this.writeString(value);
        }
    }
}

