/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

public final class BitUtil {
    private static final long[] MAGIC = new long[]{0x5555555555555555L, 0x3333333333333333L, 0xF0F0F0F0F0F0F0FL, 0xFF00FF00FF00FFL, 0xFFFF0000FFFFL, 0xFFFFFFFFL, -6148914691236517206L};
    private static final short[] SHIFT = new short[]{1, 2, 4, 8, 16};

    private BitUtil() {
    }

    public static long pop_array(long[] arr, int wordOffset, int numWords) {
        long popCount = 0L;
        int end = wordOffset + numWords;
        for (int i2 = wordOffset; i2 < end; ++i2) {
            popCount += (long)Long.bitCount(arr[i2]);
        }
        return popCount;
    }

    public static long pop_intersect(long[] arr1, long[] arr2, int wordOffset, int numWords) {
        long popCount = 0L;
        int end = wordOffset + numWords;
        for (int i2 = wordOffset; i2 < end; ++i2) {
            popCount += (long)Long.bitCount(arr1[i2] & arr2[i2]);
        }
        return popCount;
    }

    public static long pop_union(long[] arr1, long[] arr2, int wordOffset, int numWords) {
        long popCount = 0L;
        int end = wordOffset + numWords;
        for (int i2 = wordOffset; i2 < end; ++i2) {
            popCount += (long)Long.bitCount(arr1[i2] | arr2[i2]);
        }
        return popCount;
    }

    public static long pop_andnot(long[] arr1, long[] arr2, int wordOffset, int numWords) {
        long popCount = 0L;
        int end = wordOffset + numWords;
        for (int i2 = wordOffset; i2 < end; ++i2) {
            popCount += (long)Long.bitCount(arr1[i2] & (arr2[i2] ^ 0xFFFFFFFFFFFFFFFFL));
        }
        return popCount;
    }

    public static long pop_xor(long[] arr1, long[] arr2, int wordOffset, int numWords) {
        long popCount = 0L;
        int end = wordOffset + numWords;
        for (int i2 = wordOffset; i2 < end; ++i2) {
            popCount += (long)Long.bitCount(arr1[i2] ^ arr2[i2]);
        }
        return popCount;
    }

    public static int nextHighestPowerOfTwo(int v2) {
        --v2;
        v2 |= v2 >> 1;
        v2 |= v2 >> 2;
        v2 |= v2 >> 4;
        v2 |= v2 >> 8;
        v2 |= v2 >> 16;
        return ++v2;
    }

    public static long nextHighestPowerOfTwo(long v2) {
        --v2;
        v2 |= v2 >> 1;
        v2 |= v2 >> 2;
        v2 |= v2 >> 4;
        v2 |= v2 >> 8;
        v2 |= v2 >> 16;
        v2 |= v2 >> 32;
        return ++v2;
    }

    public static long interleave(int even, int odd) {
        long v1 = 0xFFFFFFFFL & (long)even;
        long v2 = 0xFFFFFFFFL & (long)odd;
        v1 = (v1 | v1 << SHIFT[4]) & MAGIC[4];
        v1 = (v1 | v1 << SHIFT[3]) & MAGIC[3];
        v1 = (v1 | v1 << SHIFT[2]) & MAGIC[2];
        v1 = (v1 | v1 << SHIFT[1]) & MAGIC[1];
        v1 = (v1 | v1 << SHIFT[0]) & MAGIC[0];
        v2 = (v2 | v2 << SHIFT[4]) & MAGIC[4];
        v2 = (v2 | v2 << SHIFT[3]) & MAGIC[3];
        v2 = (v2 | v2 << SHIFT[2]) & MAGIC[2];
        v2 = (v2 | v2 << SHIFT[1]) & MAGIC[1];
        v2 = (v2 | v2 << SHIFT[0]) & MAGIC[0];
        return v2 << 1 | v1;
    }

    public static long deinterleave(long b2) {
        b2 &= MAGIC[0];
        b2 = (b2 ^ b2 >>> SHIFT[0]) & MAGIC[1];
        b2 = (b2 ^ b2 >>> SHIFT[1]) & MAGIC[2];
        b2 = (b2 ^ b2 >>> SHIFT[2]) & MAGIC[3];
        b2 = (b2 ^ b2 >>> SHIFT[3]) & MAGIC[4];
        b2 = (b2 ^ b2 >>> SHIFT[4]) & MAGIC[5];
        return b2;
    }

    public static final long flipFlop(long b2) {
        return (b2 & MAGIC[6]) >>> 1 | (b2 & MAGIC[0]) << 1;
    }

    public static int zigZagEncode(int i2) {
        return i2 >> 31 ^ i2 << 1;
    }

    public static long zigZagEncode(long l2) {
        return l2 >> 63 ^ l2 << 1;
    }

    public static int zigZagDecode(int i2) {
        return i2 >>> 1 ^ -(i2 & 1);
    }

    public static long zigZagDecode(long l2) {
        return l2 >>> 1 ^ -(l2 & 1L);
    }
}

