/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Arrays;
import java.util.Comparator;

public final class CharsRef
implements Comparable<CharsRef>,
CharSequence,
Cloneable {
    public static final char[] EMPTY_CHARS = new char[0];
    public char[] chars;
    public int offset;
    public int length;
    @Deprecated
    private static final Comparator<CharsRef> utf16SortedAsUTF8SortOrder = new UTF16SortedAsUTF8Comparator();

    public CharsRef() {
        this(EMPTY_CHARS, 0, 0);
    }

    public CharsRef(int capacity) {
        this.chars = new char[capacity];
    }

    public CharsRef(char[] chars, int offset, int length) {
        this.chars = chars;
        this.offset = offset;
        this.length = length;
        assert (this.isValid());
    }

    public CharsRef(String string) {
        this.chars = string.toCharArray();
        this.offset = 0;
        this.length = this.chars.length;
    }

    public CharsRef clone() {
        return new CharsRef(this.chars, this.offset, this.length);
    }

    public int hashCode() {
        int prime = 31;
        int result = 0;
        int end = this.offset + this.length;
        for (int i2 = this.offset; i2 < end; ++i2) {
            result = 31 * result + this.chars[i2];
        }
        return result;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof CharsRef) {
            return this.charsEquals((CharsRef)other);
        }
        return false;
    }

    public boolean charsEquals(CharsRef other) {
        if (this.length == other.length) {
            int otherUpto = other.offset;
            char[] otherChars = other.chars;
            int end = this.offset + this.length;
            int upto = this.offset;
            while (upto < end) {
                if (this.chars[upto] != otherChars[otherUpto]) {
                    return false;
                }
                ++upto;
                ++otherUpto;
            }
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(CharsRef other) {
        if (this == other) {
            return 0;
        }
        char[] aChars = this.chars;
        int aUpto = this.offset;
        char[] bChars = other.chars;
        int bUpto = other.offset;
        int aStop = aUpto + Math.min(this.length, other.length);
        while (aUpto < aStop) {
            char bInt;
            char aInt;
            if ((aInt = aChars[aUpto++]) > (bInt = bChars[bUpto++])) {
                return 1;
            }
            if (aInt >= bInt) continue;
            return -1;
        }
        return this.length - other.length;
    }

    @Override
    public String toString() {
        return new String(this.chars, this.offset, this.length);
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.chars[this.offset + index];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start < 0 || end > this.length || start > end) {
            throw new IndexOutOfBoundsException();
        }
        return new CharsRef(this.chars, this.offset + start, end - start);
    }

    @Deprecated
    public static Comparator<CharsRef> getUTF16SortedAsUTF8Comparator() {
        return utf16SortedAsUTF8SortOrder;
    }

    public static CharsRef deepCopyOf(CharsRef other) {
        return new CharsRef(Arrays.copyOfRange(other.chars, other.offset, other.offset + other.length), 0, other.length);
    }

    public boolean isValid() {
        if (this.chars == null) {
            throw new IllegalStateException("chars is null");
        }
        if (this.length < 0) {
            throw new IllegalStateException("length is negative: " + this.length);
        }
        if (this.length > this.chars.length) {
            throw new IllegalStateException("length is out of bounds: " + this.length + ",chars.length=" + this.chars.length);
        }
        if (this.offset < 0) {
            throw new IllegalStateException("offset is negative: " + this.offset);
        }
        if (this.offset > this.chars.length) {
            throw new IllegalStateException("offset out of bounds: " + this.offset + ",chars.length=" + this.chars.length);
        }
        if (this.offset + this.length < 0) {
            throw new IllegalStateException("offset+length is negative: offset=" + this.offset + ",length=" + this.length);
        }
        if (this.offset + this.length > this.chars.length) {
            throw new IllegalStateException("offset+length out of bounds: offset=" + this.offset + ",length=" + this.length + ",chars.length=" + this.chars.length);
        }
        return true;
    }

    @Deprecated
    private static class UTF16SortedAsUTF8Comparator
    implements Comparator<CharsRef> {
        private UTF16SortedAsUTF8Comparator() {
        }

        @Override
        public int compare(CharsRef a2, CharsRef b2) {
            if (a2 == b2) {
                return 0;
            }
            char[] aChars = a2.chars;
            int aUpto = a2.offset;
            char[] bChars = b2.chars;
            int bUpto = b2.offset;
            int aStop = aUpto + Math.min(a2.length, b2.length);
            while (aUpto < aStop) {
                char bChar;
                char aChar;
                if ((aChar = aChars[aUpto++]) == (bChar = bChars[bUpto++])) continue;
                if (aChar >= '\ud800' && bChar >= '\ud800') {
                    aChar = aChar >= '\ue000' ? (char)(aChar - 2048) : (char)(aChar + 8192);
                    bChar = bChar >= '\ue000' ? (char)(bChar - 2048) : (char)(bChar + 8192);
                }
                return aChar - bChar;
            }
            return a2.length - b2.length;
        }
    }
}

