/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Arrays;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IntroSorter;
import org.apache.lucene.util.Sorter;

public abstract class MSBRadixSorter
extends Sorter {
    private static final int LEVEL_THRESHOLD = 8;
    private static final int HISTOGRAM_SIZE = 257;
    private static final int LENGTH_THRESHOLD = 100;
    private final int[][] histograms = new int[8][];
    private final int[] endOffsets = new int[257];
    private final int[] commonPrefix;
    private final int maxLength;

    protected MSBRadixSorter(int maxLength) {
        this.maxLength = maxLength;
        this.commonPrefix = new int[Math.min(24, maxLength)];
    }

    protected abstract int byteAt(int var1, int var2);

    protected Sorter getFallbackSorter(final int k2) {
        return new IntroSorter(){
            private final BytesRefBuilder pivot = new BytesRefBuilder();

            @Override
            protected void swap(int i2, int j2) {
                MSBRadixSorter.this.swap(i2, j2);
            }

            @Override
            protected int compare(int i2, int j2) {
                for (int o2 = k2; o2 < MSBRadixSorter.this.maxLength; ++o2) {
                    int b2;
                    int b1 = MSBRadixSorter.this.byteAt(i2, o2);
                    if (b1 != (b2 = MSBRadixSorter.this.byteAt(j2, o2))) {
                        return b1 - b2;
                    }
                    if (b1 == -1) break;
                }
                return 0;
            }

            @Override
            protected void setPivot(int i2) {
                int b2;
                this.pivot.setLength(0);
                for (int o2 = k2; o2 < MSBRadixSorter.this.maxLength && (b2 = MSBRadixSorter.this.byteAt(i2, o2)) != -1; ++o2) {
                    this.pivot.append((byte)b2);
                }
            }

            @Override
            protected int comparePivot(int j2) {
                for (int o2 = 0; o2 < this.pivot.length(); ++o2) {
                    int b2;
                    int b1 = this.pivot.byteAt(o2) & 0xFF;
                    if (b1 == (b2 = MSBRadixSorter.this.byteAt(j2, k2 + o2))) continue;
                    return b1 - b2;
                }
                if (k2 + this.pivot.length() == MSBRadixSorter.this.maxLength) {
                    return 0;
                }
                return -1 - MSBRadixSorter.this.byteAt(j2, k2 + this.pivot.length());
            }
        };
    }

    @Override
    protected final int compare(int i2, int j2) {
        throw new UnsupportedOperationException("unused: not a comparison-based sort");
    }

    @Override
    public void sort(int from, int to) {
        this.checkRange(from, to);
        this.sort(from, to, 0, 0);
    }

    private void sort(int from, int to, int k2, int l2) {
        if (to - from <= 100 || l2 >= 8) {
            this.introSort(from, to, k2);
        } else {
            this.radixSort(from, to, k2, l2);
        }
    }

    private void introSort(int from, int to, int k2) {
        this.getFallbackSorter(k2).sort(from, to);
    }

    private void radixSort(int from, int to, int k2, int l2) {
        int[] histogram = this.histograms[l2];
        if (histogram == null) {
            this.histograms[l2] = new int[257];
            histogram = this.histograms[l2];
        } else {
            Arrays.fill(histogram, 0);
        }
        int commonPrefixLength = this.computeCommonPrefixLengthAndBuildHistogram(from, to, k2, histogram);
        if (commonPrefixLength > 0) {
            if (k2 + commonPrefixLength < this.maxLength && histogram[0] < to - from) {
                this.radixSort(from, to, k2 + commonPrefixLength, l2);
            }
            return;
        }
        assert (this.assertHistogram(commonPrefixLength, histogram));
        int[] startOffsets = histogram;
        int[] endOffsets = this.endOffsets;
        MSBRadixSorter.sumHistogram(histogram, endOffsets);
        this.reorder(from, to, startOffsets, endOffsets, k2);
        endOffsets = startOffsets;
        if (k2 + 1 < this.maxLength) {
            int prev = endOffsets[0];
            for (int i2 = 1; i2 < 257; ++i2) {
                int h2 = endOffsets[i2];
                int bucketLen = h2 - prev;
                if (bucketLen > 1) {
                    this.sort(from + prev, from + h2, k2 + 1, l2 + 1);
                }
                prev = h2;
            }
        }
    }

    private boolean assertHistogram(int commonPrefixLength, int[] histogram) {
        int numberOfUniqueBytes = 0;
        for (int freq : histogram) {
            if (freq <= 0) continue;
            ++numberOfUniqueBytes;
        }
        if (numberOfUniqueBytes == 1) {
            assert (commonPrefixLength >= 1);
        } else assert (commonPrefixLength == 0) : commonPrefixLength;
        return true;
    }

    private int getBucket(int i2, int k2) {
        return this.byteAt(i2, k2) + 1;
    }

    private int computeCommonPrefixLengthAndBuildHistogram(int from, int to, int k2, int[] histogram) {
        int i2;
        int[] commonPrefix = this.commonPrefix;
        int commonPrefixLength = Math.min(commonPrefix.length, this.maxLength - k2);
        for (int j2 = 0; j2 < commonPrefixLength; ++j2) {
            int b2;
            commonPrefix[j2] = b2 = this.byteAt(from, k2 + j2);
            if (b2 != -1) continue;
            commonPrefixLength = j2 + 1;
            break;
        }
        block1: for (i2 = from + 1; i2 < to; ++i2) {
            for (int j3 = 0; j3 < commonPrefixLength; ++j3) {
                int b3 = this.byteAt(i2, k2 + j3);
                if (b3 == commonPrefix[j3]) continue;
                commonPrefixLength = j3;
                if (commonPrefixLength != 0) continue block1;
                histogram[commonPrefix[0] + 1] = i2 - from;
                histogram[b3 + 1] = 1;
                break block1;
            }
        }
        if (i2 < to) {
            assert (commonPrefixLength == 0);
            this.buildHistogram(i2 + 1, to, k2, histogram);
        } else {
            assert (commonPrefixLength > 0);
            histogram[commonPrefix[0] + 1] = to - from;
        }
        return commonPrefixLength;
    }

    private void buildHistogram(int from, int to, int k2, int[] histogram) {
        for (int i2 = from; i2 < to; ++i2) {
            int n2 = this.getBucket(i2, k2);
            histogram[n2] = histogram[n2] + 1;
        }
    }

    private static void sumHistogram(int[] histogram, int[] endOffsets) {
        int accum = 0;
        for (int i2 = 0; i2 < 257; ++i2) {
            int count = histogram[i2];
            histogram[i2] = accum;
            endOffsets[i2] = accum += count;
        }
    }

    private void reorder(int from, int to, int[] startOffsets, int[] endOffsets, int k2) {
        for (int i2 = 0; i2 < 257; ++i2) {
            int limit = endOffsets[i2];
            int h1 = startOffsets[i2];
            while (h1 < limit) {
                int h2;
                int b2;
                int n2 = b2 = this.getBucket(from + h1, k2);
                startOffsets[n2] = startOffsets[n2] + 1;
                this.swap(from + h1, from + h2);
                h1 = startOffsets[i2];
            }
        }
    }
}

