/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

public final class MathUtil {
    private MathUtil() {
    }

    public static int log(long x2, int base) {
        if (base <= 1) {
            throw new IllegalArgumentException("base must be > 1");
        }
        int ret = 0;
        while (x2 >= (long)base) {
            x2 /= (long)base;
            ++ret;
        }
        return ret;
    }

    public static double log(double base, double x2) {
        return Math.log(x2) / Math.log(base);
    }

    public static long gcd(long a2, long b2) {
        a2 = Math.abs(a2);
        b2 = Math.abs(b2);
        if (a2 == 0L) {
            return b2;
        }
        if (b2 == 0L) {
            return a2;
        }
        int commonTrailingZeros = Long.numberOfTrailingZeros(a2 | b2);
        a2 >>>= Long.numberOfTrailingZeros(a2);
        while (a2 != (b2 >>>= Long.numberOfTrailingZeros(b2))) {
            if (a2 > b2 || a2 == Long.MIN_VALUE) {
                long tmp = a2;
                a2 = b2;
                b2 = tmp;
            }
            if (a2 == 1L) break;
            b2 -= a2;
        }
        return a2 << commonTrailingZeros;
    }

    public static double asinh(double a2) {
        double sign;
        if (Double.doubleToRawLongBits(a2) < 0L) {
            a2 = Math.abs(a2);
            sign = -1.0;
        } else {
            sign = 1.0;
        }
        return sign * Math.log(Math.sqrt(a2 * a2 + 1.0) + a2);
    }

    public static double acosh(double a2) {
        return Math.log(Math.sqrt(a2 * a2 - 1.0) + a2);
    }

    public static double atanh(double a2) {
        double mult;
        if (Double.doubleToRawLongBits(a2) < 0L) {
            a2 = Math.abs(a2);
            mult = -0.5;
        } else {
            mult = 0.5;
        }
        return mult * Math.log((1.0 + a2) / (1.0 - a2));
    }
}

