/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.Set;
import org.apache.lucene.util.SPIClassIterator;

public final class NamedSPILoader<S extends NamedSPI>
implements Iterable<S> {
    private volatile Map<String, S> services = Collections.emptyMap();
    private final Class<S> clazz;

    public NamedSPILoader(Class<S> clazz) {
        this(clazz, null);
    }

    public NamedSPILoader(Class<S> clazz, ClassLoader classloader) {
        this.clazz = clazz;
        ClassLoader clazzClassloader = clazz.getClassLoader();
        if (classloader == null) {
            classloader = clazzClassloader;
        }
        if (clazzClassloader != null && !SPIClassIterator.isParentClassLoader(clazzClassloader, classloader)) {
            this.reload(clazzClassloader);
        }
        this.reload(classloader);
    }

    public void reload(ClassLoader classloader) {
        Objects.requireNonNull(classloader, "classloader");
        LinkedHashMap<String, S> services = new LinkedHashMap<String, S>(this.services);
        SPIClassIterator<S> loader = SPIClassIterator.get(this.clazz, classloader);
        while (loader.hasNext()) {
            Object c2 = loader.next();
            try {
                NamedSPI service = (NamedSPI)((Class)c2).newInstance();
                String name = service.getName();
                if (services.containsKey(name)) continue;
                NamedSPILoader.checkServiceName(name);
                services.put(name, service);
            }
            catch (Exception e2) {
                throw new ServiceConfigurationError("Cannot instantiate SPI class: " + ((Class)c2).getName(), e2);
            }
        }
        this.services = Collections.unmodifiableMap(services);
    }

    public static void checkServiceName(String name) {
        if (name.length() >= 128) {
            throw new IllegalArgumentException("Illegal service name: '" + name + "' is too long (must be < 128 chars).");
        }
        int len = name.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = name.charAt(i2);
            if (NamedSPILoader.isLetterOrDigit(c2)) continue;
            throw new IllegalArgumentException("Illegal service name: '" + name + "' must be simple ascii alphanumeric.");
        }
    }

    private static boolean isLetterOrDigit(char c2) {
        return 'a' <= c2 && c2 <= 'z' || 'A' <= c2 && c2 <= 'Z' || '0' <= c2 && c2 <= '9';
    }

    public S lookup(String name) {
        NamedSPI service = (NamedSPI)this.services.get(name);
        if (service != null) {
            return (S)service;
        }
        throw new IllegalArgumentException("An SPI class of type " + this.clazz.getName() + " with name '" + name + "' does not exist.  You need to add the corresponding JAR file supporting this SPI to your classpath.  The current classpath supports the following names: " + this.availableServices());
    }

    public Set<String> availableServices() {
        return this.services.keySet();
    }

    @Override
    public Iterator<S> iterator() {
        return this.services.values().iterator();
    }

    public static interface NamedSPI {
        public String getName();
    }
}

