/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Arrays;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IntroSelector;
import org.apache.lucene.util.Selector;

public abstract class RadixSelector
extends Selector {
    private static final int LEVEL_THRESHOLD = 8;
    private static final int HISTOGRAM_SIZE = 257;
    private static final int LENGTH_THRESHOLD = 100;
    private final int[] histogram = new int[257];
    private final int[] commonPrefix;
    private final int maxLength;

    protected RadixSelector(int maxLength) {
        this.maxLength = maxLength;
        this.commonPrefix = new int[Math.min(24, maxLength)];
    }

    protected abstract int byteAt(int var1, int var2);

    protected Selector getFallbackSelector(final int d2) {
        return new IntroSelector(){
            private final BytesRefBuilder pivot = new BytesRefBuilder();

            @Override
            protected void swap(int i2, int j2) {
                RadixSelector.this.swap(i2, j2);
            }

            @Override
            protected int compare(int i2, int j2) {
                for (int o2 = d2; o2 < RadixSelector.this.maxLength; ++o2) {
                    int b2;
                    int b1 = RadixSelector.this.byteAt(i2, o2);
                    if (b1 != (b2 = RadixSelector.this.byteAt(j2, o2))) {
                        return b1 - b2;
                    }
                    if (b1 == -1) break;
                }
                return 0;
            }

            @Override
            protected void setPivot(int i2) {
                int b2;
                this.pivot.setLength(0);
                for (int o2 = d2; o2 < RadixSelector.this.maxLength && (b2 = RadixSelector.this.byteAt(i2, o2)) != -1; ++o2) {
                    this.pivot.append((byte)b2);
                }
            }

            @Override
            protected int comparePivot(int j2) {
                for (int o2 = 0; o2 < this.pivot.length(); ++o2) {
                    int b2;
                    int b1 = this.pivot.byteAt(o2) & 0xFF;
                    if (b1 == (b2 = RadixSelector.this.byteAt(j2, d2 + o2))) continue;
                    return b1 - b2;
                }
                if (d2 + this.pivot.length() == RadixSelector.this.maxLength) {
                    return 0;
                }
                return -1 - RadixSelector.this.byteAt(j2, d2 + this.pivot.length());
            }
        };
    }

    @Override
    public void select(int from, int to, int k2) {
        this.checkArgs(from, to, k2);
        this.select(from, to, k2, 0, 0);
    }

    private void select(int from, int to, int k2, int d2, int l2) {
        if (to - from <= 100 || d2 >= 8) {
            this.getFallbackSelector(d2).select(from, to, k2);
        } else {
            this.radixSelect(from, to, k2, d2, l2);
        }
    }

    private void radixSelect(int from, int to, int k2, int d2, int l2) {
        int[] histogram = this.histogram;
        Arrays.fill(histogram, 0);
        int commonPrefixLength = this.computeCommonPrefixLengthAndBuildHistogram(from, to, d2, histogram);
        if (commonPrefixLength > 0) {
            if (d2 + commonPrefixLength < this.maxLength && histogram[0] < to - from) {
                this.radixSelect(from, to, k2, d2 + commonPrefixLength, l2);
            }
            return;
        }
        assert (this.assertHistogram(commonPrefixLength, histogram));
        int bucketFrom = from;
        for (int bucket = 0; bucket < 257; ++bucket) {
            int bucketTo = bucketFrom + histogram[bucket];
            if (bucketTo > k2) {
                this.partition(from, to, bucket, bucketFrom, bucketTo, d2);
                if (bucket != 0 && d2 + 1 < this.maxLength) {
                    this.select(bucketFrom, bucketTo, k2, d2 + 1, l2 + 1);
                }
                return;
            }
            bucketFrom = bucketTo;
        }
        throw new AssertionError((Object)"Unreachable code");
    }

    private boolean assertHistogram(int commonPrefixLength, int[] histogram) {
        int numberOfUniqueBytes = 0;
        for (int freq : histogram) {
            if (freq <= 0) continue;
            ++numberOfUniqueBytes;
        }
        if (numberOfUniqueBytes == 1 ? !$assertionsDisabled && commonPrefixLength < 1 : !$assertionsDisabled && commonPrefixLength != 0) {
            throw new AssertionError();
        }
        return true;
    }

    private int getBucket(int i2, int k2) {
        return this.byteAt(i2, k2) + 1;
    }

    private int computeCommonPrefixLengthAndBuildHistogram(int from, int to, int k2, int[] histogram) {
        int i2;
        int[] commonPrefix = this.commonPrefix;
        int commonPrefixLength = Math.min(commonPrefix.length, this.maxLength - k2);
        for (int j2 = 0; j2 < commonPrefixLength; ++j2) {
            int b2;
            commonPrefix[j2] = b2 = this.byteAt(from, k2 + j2);
            if (b2 != -1) continue;
            commonPrefixLength = j2 + 1;
            break;
        }
        block1: for (i2 = from + 1; i2 < to; ++i2) {
            for (int j3 = 0; j3 < commonPrefixLength; ++j3) {
                int b3 = this.byteAt(i2, k2 + j3);
                if (b3 == commonPrefix[j3]) continue;
                commonPrefixLength = j3;
                if (commonPrefixLength != 0) continue block1;
                histogram[commonPrefix[0] + 1] = i2 - from;
                histogram[b3 + 1] = 1;
                break block1;
            }
        }
        if (i2 < to) {
            assert (commonPrefixLength == 0);
            this.buildHistogram(i2 + 1, to, k2, histogram);
        } else {
            assert (commonPrefixLength > 0);
            histogram[commonPrefix[0] + 1] = to - from;
        }
        return commonPrefixLength;
    }

    private void buildHistogram(int from, int to, int k2, int[] histogram) {
        for (int i2 = from; i2 < to; ++i2) {
            int n2 = this.getBucket(i2, k2);
            histogram[n2] = histogram[n2] + 1;
        }
    }

    private void partition(int from, int to, int bucket, int bucketFrom, int bucketTo, int d2) {
        int left = from;
        int right = to - 1;
        int slot = bucketFrom;
        while (true) {
            int leftBucket = this.getBucket(left, d2);
            int rightBucket = this.getBucket(right, d2);
            while (leftBucket <= bucket && left < bucketFrom) {
                if (leftBucket == bucket) {
                    this.swap(left, slot++);
                } else {
                    ++left;
                }
                leftBucket = this.getBucket(left, d2);
            }
            while (rightBucket >= bucket && right >= bucketTo) {
                if (rightBucket == bucket) {
                    this.swap(right, slot++);
                } else {
                    --right;
                }
                rightBucket = this.getBucket(right, d2);
            }
            if (left >= bucketFrom || right < bucketTo) break;
            this.swap(left++, right--);
        }
        assert (left == bucketFrom);
        assert (right == bucketTo - 1);
    }
}

