/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntroSorter;
import org.apache.lucene.util.MSBRadixSorter;
import org.apache.lucene.util.Sorter;

abstract class StringMSBRadixSorter
extends MSBRadixSorter {
    StringMSBRadixSorter() {
        super(Integer.MAX_VALUE);
    }

    protected abstract BytesRef get(int var1);

    @Override
    protected int byteAt(int i2, int k2) {
        BytesRef ref = this.get(i2);
        if (ref.length <= k2) {
            return -1;
        }
        return ref.bytes[ref.offset + k2] & 0xFF;
    }

    @Override
    protected Sorter getFallbackSorter(final int k2) {
        return new IntroSorter(){
            private final BytesRef pivot = new BytesRef();
            private final BytesRef scratch1 = new BytesRef();
            private final BytesRef scratch2 = new BytesRef();

            private void get(int i2, int k22, BytesRef scratch) {
                BytesRef ref = StringMSBRadixSorter.this.get(i2);
                assert (ref.length >= k22);
                scratch.bytes = ref.bytes;
                scratch.offset = ref.offset + k22;
                scratch.length = ref.length - k22;
            }

            @Override
            protected void swap(int i2, int j2) {
                StringMSBRadixSorter.this.swap(i2, j2);
            }

            @Override
            protected int compare(int i2, int j2) {
                this.get(i2, k2, this.scratch1);
                this.get(j2, k2, this.scratch2);
                return this.scratch1.compareTo(this.scratch2);
            }

            @Override
            protected void setPivot(int i2) {
                this.get(i2, k2, this.pivot);
            }

            @Override
            protected int comparePivot(int j2) {
                this.get(j2, k2, this.scratch2);
                return this.pivot.compareTo(this.scratch2);
            }
        };
    }
}

