/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Arrays;
import org.apache.lucene.util.Sorter;

public abstract class TimSorter
extends Sorter {
    static final int MINRUN = 32;
    static final int THRESHOLD = 64;
    static final int STACKSIZE = 49;
    static final int MIN_GALLOP = 7;
    final int maxTempSlots;
    int minRun;
    int to;
    int stackSize;
    int[] runEnds = new int[50];

    protected TimSorter(int maxTempSlots) {
        this.maxTempSlots = maxTempSlots;
    }

    static int minRun(int length) {
        int n2;
        assert (length >= 32);
        int r2 = 0;
        for (n2 = length; n2 >= 64; n2 >>>= 1) {
            r2 |= n2 & 1;
        }
        int minRun = n2 + r2;
        assert (minRun >= 32 && minRun <= 64);
        return minRun;
    }

    int runLen(int i2) {
        int off = this.stackSize - i2;
        return this.runEnds[off] - this.runEnds[off - 1];
    }

    int runBase(int i2) {
        return this.runEnds[this.stackSize - i2 - 1];
    }

    int runEnd(int i2) {
        return this.runEnds[this.stackSize - i2];
    }

    void setRunEnd(int i2, int runEnd) {
        this.runEnds[this.stackSize - i2] = runEnd;
    }

    void pushRunLen(int len) {
        this.runEnds[this.stackSize + 1] = this.runEnds[this.stackSize] + len;
        ++this.stackSize;
    }

    int nextRun() {
        int o2;
        int runBase = this.runEnd(0);
        assert (runBase < this.to);
        if (runBase == this.to - 1) {
            return 1;
        }
        if (this.compare(runBase, runBase + 1) > 0) {
            for (o2 = runBase + 2; o2 < this.to && this.compare(o2 - 1, o2) > 0; ++o2) {
            }
            this.reverse(runBase, o2);
        } else {
            while (o2 < this.to && this.compare(o2 - 1, o2) <= 0) {
                ++o2;
            }
        }
        int runHi = Math.max(o2, Math.min(this.to, runBase + this.minRun));
        this.binarySort(runBase, runHi, o2);
        return runHi - runBase;
    }

    void ensureInvariants() {
        while (this.stackSize > 1) {
            int runLen2;
            int runLen0 = this.runLen(0);
            int runLen1 = this.runLen(1);
            if (this.stackSize > 2 && (runLen2 = this.runLen(2)) <= runLen1 + runLen0) {
                if (runLen2 < runLen0) {
                    this.mergeAt(1);
                    continue;
                }
                this.mergeAt(0);
                continue;
            }
            if (runLen1 > runLen0) break;
            this.mergeAt(0);
        }
    }

    void exhaustStack() {
        while (this.stackSize > 1) {
            this.mergeAt(0);
        }
    }

    void reset(int from, int to) {
        this.stackSize = 0;
        Arrays.fill(this.runEnds, 0);
        this.runEnds[0] = from;
        this.to = to;
        int length = to - from;
        this.minRun = length <= 64 ? length : TimSorter.minRun(length);
    }

    void mergeAt(int n2) {
        assert (this.stackSize >= 2);
        this.merge(this.runBase(n2 + 1), this.runBase(n2), this.runEnd(n2));
        for (int j2 = n2 + 1; j2 > 0; --j2) {
            this.setRunEnd(j2, this.runEnd(j2 - 1));
        }
        --this.stackSize;
    }

    void merge(int lo, int mid, int hi) {
        if (this.compare(mid - 1, mid) <= 0) {
            return;
        }
        lo = this.upper2(lo, mid, mid);
        if ((hi = this.lower2(mid, hi, mid - 1)) - mid <= mid - lo && hi - mid <= this.maxTempSlots) {
            this.mergeHi(lo, mid, hi);
        } else if (mid - lo <= this.maxTempSlots) {
            this.mergeLo(lo, mid, hi);
        } else {
            this.mergeInPlace(lo, mid, hi);
        }
    }

    @Override
    public void sort(int from, int to) {
        this.checkRange(from, to);
        if (to - from <= 1) {
            return;
        }
        this.reset(from, to);
        do {
            this.ensureInvariants();
            this.pushRunLen(this.nextRun());
        } while (this.runEnd(0) < to);
        this.exhaustStack();
        assert (this.runEnd(0) == to);
    }

    @Override
    void doRotate(int lo, int mid, int hi) {
        int len1 = mid - lo;
        int len2 = hi - mid;
        if (len1 == len2) {
            while (mid < hi) {
                this.swap(lo++, mid++);
            }
        } else if (len2 < len1 && len2 <= this.maxTempSlots) {
            this.save(mid, len2);
            int i2 = lo + len1 - 1;
            int j2 = hi - 1;
            while (i2 >= lo) {
                this.copy(i2, j2);
                --i2;
                --j2;
            }
            i2 = 0;
            j2 = lo;
            while (i2 < len2) {
                this.restore(i2, j2);
                ++i2;
                ++j2;
            }
        } else if (len1 <= this.maxTempSlots) {
            this.save(lo, len1);
            int i3 = mid;
            int j3 = lo;
            while (i3 < hi) {
                this.copy(i3, j3);
                ++i3;
                ++j3;
            }
            i3 = 0;
            for (j3 = lo + len2; j3 < hi; ++j3) {
                this.restore(i3, j3);
                ++i3;
            }
        } else {
            this.reverse(lo, mid);
            this.reverse(mid, hi);
            this.reverse(lo, hi);
        }
    }

    void mergeLo(int lo, int mid, int hi) {
        assert (this.compare(lo, mid) > 0);
        int len1 = mid - lo;
        this.save(lo, len1);
        this.copy(mid, lo);
        int i2 = 0;
        int j2 = mid + 1;
        int dest = lo + 1;
        block0: while (true) {
            int count = 0;
            while (count < 7) {
                if (i2 >= len1 || j2 >= hi) break block0;
                if (this.compareSaved(i2, j2) <= 0) {
                    this.restore(i2++, dest++);
                    count = 0;
                    continue;
                }
                this.copy(j2++, dest++);
                ++count;
            }
            int next = this.lowerSaved3(j2, hi, i2);
            while (j2 < next) {
                this.copy(j2++, dest);
                ++dest;
            }
            this.restore(i2++, dest++);
        }
        while (i2 < len1) {
            this.restore(i2++, dest);
            ++dest;
        }
        assert (j2 == dest);
    }

    void mergeHi(int lo, int mid, int hi) {
        assert (this.compare(mid - 1, hi - 1) > 0);
        int len2 = hi - mid;
        this.save(mid, len2);
        this.copy(mid - 1, hi - 1);
        int i2 = mid - 2;
        int j2 = len2 - 1;
        int dest = hi - 2;
        block0: while (true) {
            int count = 0;
            while (count < 7) {
                if (i2 < lo || j2 < 0) break block0;
                if (this.compareSaved(j2, i2) >= 0) {
                    this.restore(j2--, dest--);
                    count = 0;
                    continue;
                }
                this.copy(i2--, dest--);
                ++count;
            }
            int next = this.upperSaved3(lo, i2 + 1, j2);
            while (i2 >= next) {
                this.copy(i2--, dest--);
            }
            this.restore(j2--, dest--);
        }
        while (j2 >= 0) {
            this.restore(j2--, dest);
            --dest;
        }
        assert (i2 == dest);
    }

    int lowerSaved(int from, int to, int val) {
        int len = to - from;
        while (len > 0) {
            int half = len >>> 1;
            int mid = from + half;
            if (this.compareSaved(val, mid) > 0) {
                from = mid + 1;
                len = len - half - 1;
                continue;
            }
            len = half;
        }
        return from;
    }

    int upperSaved(int from, int to, int val) {
        int len = to - from;
        while (len > 0) {
            int half = len >>> 1;
            int mid = from + half;
            if (this.compareSaved(val, mid) < 0) {
                len = half;
                continue;
            }
            from = mid + 1;
            len = len - half - 1;
        }
        return from;
    }

    int lowerSaved3(int from, int to, int val) {
        int delta;
        int f2 = from;
        for (int t2 = f2 + 1; t2 < to; t2 += delta << 1) {
            if (this.compareSaved(val, t2) <= 0) {
                return this.lowerSaved(f2, t2, val);
            }
            delta = t2 - f2;
            f2 = t2;
        }
        return this.lowerSaved(f2, to, val);
    }

    int upperSaved3(int from, int to, int val) {
        int delta;
        int t2 = to;
        for (int f2 = to - 1; f2 > from; f2 -= delta << 1) {
            if (this.compareSaved(val, f2) >= 0) {
                return this.upperSaved(f2, t2, val);
            }
            delta = t2 - f2;
            t2 = f2;
        }
        return this.upperSaved(from, t2, val);
    }

    protected abstract void copy(int var1, int var2);

    protected abstract void save(int var1, int var2);

    protected abstract void restore(int var1, int var2);

    protected abstract int compareSaved(int var1, int var2);
}

