/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.automaton;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.Transition;

public final class MinimizationOperations {
    private MinimizationOperations() {
    }

    public static Automaton minimize(Automaton a2, int maxDeterminizedStates) {
        int n2;
        int j2;
        int x2;
        int q2;
        if (a2.getNumStates() == 0 || !a2.isAccept(0) && a2.getNumTransitions(0) == 0) {
            return new Automaton();
        }
        if ((a2 = Operations.determinize(a2, maxDeterminizedStates)).getNumTransitions(0) == 1) {
            Transition t2 = new Transition();
            a2.getTransition(0, 0, t2);
            if (t2.dest == 0 && t2.min == 0 && t2.max == 0x10FFFF) {
                return a2;
            }
        }
        a2 = Operations.totalize(a2);
        int[] sigma = a2.getStartPoints();
        int sigmaLen = sigma.length;
        int statesLen = a2.getNumStates();
        ArrayList[][] reverse = new ArrayList[statesLen][sigmaLen];
        HashSet[] partition = new HashSet[statesLen];
        ArrayList[] splitblock = new ArrayList[statesLen];
        int[] block = new int[statesLen];
        StateList[][] active = new StateList[statesLen][sigmaLen];
        StateListNode[][] active2 = new StateListNode[statesLen][sigmaLen];
        LinkedList<IntPair> pending = new LinkedList<IntPair>();
        BitSet pending2 = new BitSet(sigmaLen * statesLen);
        BitSet split = new BitSet(statesLen);
        BitSet refine = new BitSet(statesLen);
        BitSet refine2 = new BitSet(statesLen);
        for (q2 = 0; q2 < statesLen; ++q2) {
            splitblock[q2] = new ArrayList();
            partition[q2] = new HashSet();
            for (x2 = 0; x2 < sigmaLen; ++x2) {
                active[q2][x2] = new StateList();
            }
        }
        for (q2 = 0; q2 < statesLen; ++q2) {
            j2 = a2.isAccept(q2) ? 0 : 1;
            partition[j2].add(q2);
            block[q2] = j2;
            for (int x3 = 0; x3 < sigmaLen; ++x3) {
                ArrayList[] r2 = reverse[a2.step(q2, sigma[x3])];
                if (r2[x3] == null) {
                    r2[x3] = new ArrayList();
                }
                r2[x3].add(q2);
            }
        }
        for (int j3 = 0; j3 <= 1; ++j3) {
            for (x2 = 0; x2 < sigmaLen; ++x2) {
                Iterator x3 = partition[j3].iterator();
                while (x3.hasNext()) {
                    int q3 = (Integer)x3.next();
                    if (reverse[q3][x2] == null) continue;
                    active2[q3][x2] = active[j3][x2].add(q3);
                }
            }
        }
        for (int x4 = 0; x4 < sigmaLen; ++x4) {
            j2 = active[0][x4].size <= active[1][x4].size ? 0 : 1;
            pending.add(new IntPair(j2, x4));
            pending2.set(x4 * statesLen + j2);
        }
        int k2 = 2;
        while (!pending.isEmpty()) {
            IntPair ip = (IntPair)pending.removeFirst();
            int p2 = ip.n1;
            int x5 = ip.n2;
            pending2.clear(x5 * statesLen + p2);
            StateListNode m3 = active[p2][x5].first;
            while (m3 != null) {
                ArrayList r3 = reverse[m3.q][x5];
                if (r3 != null) {
                    Iterator iterator = r3.iterator();
                    while (iterator.hasNext()) {
                        int i2 = (Integer)iterator.next();
                        if (split.get(i2)) continue;
                        split.set(i2);
                        int j4 = block[i2];
                        splitblock[j4].add(i2);
                        if (refine2.get(j4)) continue;
                        refine2.set(j4);
                        refine.set(j4);
                    }
                }
                m3 = m3.next;
            }
            int j5 = refine.nextSetBit(0);
            while (j5 >= 0) {
                Object b1;
                ArrayList sb = splitblock[j5];
                if (sb.size() < partition[j5].size()) {
                    b1 = partition[j5];
                    HashSet b2 = partition[k2];
                    Iterator j4 = sb.iterator();
                    while (j4.hasNext()) {
                        int s2 = (Integer)j4.next();
                        ((HashSet)b1).remove(s2);
                        b2.add(s2);
                        block[s2] = k2;
                        for (int c2 = 0; c2 < sigmaLen; ++c2) {
                            StateListNode sn = active2[s2][c2];
                            if (sn == null || sn.sl != active[j5][c2]) continue;
                            sn.remove();
                            active2[s2][c2] = active[k2][c2].add(s2);
                        }
                    }
                    for (int c3 = 0; c3 < sigmaLen; ++c3) {
                        int aj2 = active[j5][c3].size;
                        int ak2 = active[k2][c3].size;
                        int ofs = c3 * statesLen;
                        if (!pending2.get(ofs + j5) && 0 < aj2 && aj2 <= ak2) {
                            pending2.set(ofs + j5);
                            pending.add(new IntPair(j5, c3));
                            continue;
                        }
                        pending2.set(ofs + k2);
                        pending.add(new IntPair(k2, c3));
                    }
                    ++k2;
                }
                refine2.clear(j5);
                b1 = sb.iterator();
                while (b1.hasNext()) {
                    int s3 = (Integer)b1.next();
                    split.clear(s3);
                }
                sb.clear();
                j5 = refine.nextSetBit(j5 + 1);
            }
            refine.clear();
        }
        Automaton result = new Automaton();
        Transition t3 = new Transition();
        int[] stateMap = new int[statesLen];
        int[] stateRep = new int[k2];
        result.createState();
        for (n2 = 0; n2 < k2; ++n2) {
            boolean isInitial = false;
            Iterator s3 = partition[n2].iterator();
            while (s3.hasNext()) {
                int q4 = (Integer)s3.next();
                if (q4 != 0) continue;
                isInitial = true;
                break;
            }
            int newState = isInitial ? 0 : result.createState();
            Iterator iterator = partition[n2].iterator();
            while (iterator.hasNext()) {
                int q5 = (Integer)iterator.next();
                stateMap[q5] = newState;
                result.setAccept(newState, a2.isAccept(q5));
                stateRep[newState] = q5;
            }
        }
        for (n2 = 0; n2 < k2; ++n2) {
            int numTransitions = a2.initTransition(stateRep[n2], t3);
            for (int i3 = 0; i3 < numTransitions; ++i3) {
                a2.getNextTransition(t3);
                result.addTransition(n2, stateMap[t3.dest], t3.min, t3.max);
            }
        }
        result.finishState();
        return Operations.removeDeadStates(result);
    }

    static final class StateListNode {
        final int q;
        StateListNode next;
        StateListNode prev;
        final StateList sl;

        StateListNode(int q2, StateList sl) {
            this.q = q2;
            this.sl = sl;
            if (sl.size++ == 0) {
                sl.first = sl.last = this;
            } else {
                sl.last.next = this;
                this.prev = sl.last;
                sl.last = this;
            }
        }

        void remove() {
            --this.sl.size;
            if (this.sl.first == this) {
                this.sl.first = this.next;
            } else {
                this.prev.next = this.next;
            }
            if (this.sl.last == this) {
                this.sl.last = this.prev;
            } else {
                this.next.prev = this.prev;
            }
        }
    }

    static final class StateList {
        int size;
        StateListNode first;
        StateListNode last;

        StateList() {
        }

        StateListNode add(int q2) {
            return new StateListNode(q2, this);
        }
    }

    static final class IntPair {
        final int n1;
        final int n2;

        IntPair(int n1, int n2) {
            this.n1 = n1;
            this.n2 = n2;
        }
    }
}

