/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.automaton;

import java.util.Map;
import java.util.TreeMap;
import org.apache.lucene.util.ArrayUtil;

final class SortedIntSet {
    int[] values;
    int[] counts;
    int upto;
    private int hashCode;
    private static final int TREE_MAP_CUTOVER = 30;
    private final Map<Integer, Integer> map = new TreeMap<Integer, Integer>();
    private boolean useTreeMap;
    int state;

    public SortedIntSet(int capacity) {
        this.values = new int[capacity];
        this.counts = new int[capacity];
    }

    public void incr(int num) {
        int i2;
        if (this.useTreeMap) {
            Integer key = num;
            Integer val = this.map.get(key);
            if (val == null) {
                this.map.put(key, 1);
            } else {
                this.map.put(key, 1 + val);
            }
            return;
        }
        if (this.upto == this.values.length) {
            this.values = ArrayUtil.grow(this.values, 1 + this.upto);
            this.counts = ArrayUtil.grow(this.counts, 1 + this.upto);
        }
        for (i2 = 0; i2 < this.upto; ++i2) {
            if (this.values[i2] == num) {
                int n2 = i2;
                this.counts[n2] = this.counts[n2] + 1;
                return;
            }
            if (num >= this.values[i2]) continue;
            for (int j2 = this.upto - 1; j2 >= i2; --j2) {
                this.values[1 + j2] = this.values[j2];
                this.counts[1 + j2] = this.counts[j2];
            }
            this.values[i2] = num;
            this.counts[i2] = 1;
            ++this.upto;
            return;
        }
        this.values[this.upto] = num;
        this.counts[this.upto] = 1;
        ++this.upto;
        if (this.upto == 30) {
            this.useTreeMap = true;
            for (i2 = 0; i2 < this.upto; ++i2) {
                this.map.put(this.values[i2], this.counts[i2]);
            }
        }
    }

    public void decr(int num) {
        if (this.useTreeMap) {
            int count = this.map.get(num);
            if (count == 1) {
                this.map.remove(num);
            } else {
                this.map.put(num, count - 1);
            }
            if (this.map.size() == 0) {
                this.useTreeMap = false;
                this.upto = 0;
            }
            return;
        }
        for (int i2 = 0; i2 < this.upto; ++i2) {
            if (this.values[i2] != num) continue;
            int n2 = i2;
            this.counts[n2] = this.counts[n2] - 1;
            if (this.counts[i2] == 0) {
                int limit = this.upto - 1;
                while (i2 < limit) {
                    this.values[i2] = this.values[i2 + 1];
                    this.counts[i2] = this.counts[i2 + 1];
                    ++i2;
                }
                this.upto = limit;
            }
            return;
        }
        assert (false);
    }

    public void computeHash() {
        if (this.useTreeMap) {
            if (this.map.size() > this.values.length) {
                int size = ArrayUtil.oversize(this.map.size(), 4);
                this.values = new int[size];
                this.counts = new int[size];
            }
            this.hashCode = this.map.size();
            this.upto = 0;
            for (int state : this.map.keySet()) {
                this.hashCode = 683 * this.hashCode + state;
                this.values[this.upto++] = state;
            }
        } else {
            this.hashCode = this.upto;
            for (int i2 = 0; i2 < this.upto; ++i2) {
                this.hashCode = 683 * this.hashCode + this.values[i2];
            }
        }
    }

    public FrozenIntSet freeze(int state) {
        int[] c2 = new int[this.upto];
        System.arraycopy(this.values, 0, c2, 0, this.upto);
        return new FrozenIntSet(c2, this.hashCode, state);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object _other) {
        if (_other == null) {
            return false;
        }
        if (!(_other instanceof FrozenIntSet)) {
            return false;
        }
        FrozenIntSet other = (FrozenIntSet)_other;
        if (this.hashCode != other.hashCode) {
            return false;
        }
        if (other.values.length != this.upto) {
            return false;
        }
        for (int i2 = 0; i2 < this.upto; ++i2) {
            if (other.values[i2] == this.values[i2]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append('[');
        for (int i2 = 0; i2 < this.upto; ++i2) {
            if (i2 > 0) {
                sb.append(' ');
            }
            sb.append(this.values[i2]).append(':').append(this.counts[i2]);
        }
        sb.append(']');
        return sb.toString();
    }

    public static final class FrozenIntSet {
        final int[] values;
        final int hashCode;
        final int state;

        public FrozenIntSet(int[] values, int hashCode, int state) {
            this.values = values;
            this.hashCode = hashCode;
            this.state = state;
        }

        public FrozenIntSet(int num, int state) {
            this.values = new int[]{num};
            this.state = state;
            this.hashCode = 683 + num;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object _other) {
            if (_other == null) {
                return false;
            }
            if (_other instanceof FrozenIntSet) {
                FrozenIntSet other = (FrozenIntSet)_other;
                if (this.hashCode != other.hashCode) {
                    return false;
                }
                if (other.values.length != this.values.length) {
                    return false;
                }
                for (int i2 = 0; i2 < this.values.length; ++i2) {
                    if (other.values[i2] == this.values[i2]) continue;
                    return false;
                }
                return true;
            }
            if (_other instanceof SortedIntSet) {
                SortedIntSet other = (SortedIntSet)_other;
                if (this.hashCode != other.hashCode) {
                    return false;
                }
                if (other.values.length != this.values.length) {
                    return false;
                }
                for (int i3 = 0; i3 < this.values.length; ++i3) {
                    if (other.values[i3] == this.values[i3]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder().append('[');
            for (int i2 = 0; i2 < this.values.length; ++i2) {
                if (i2 > 0) {
                    sb.append(' ');
                }
                sb.append(this.values[i2]);
            }
            sb.append(']');
            return sb.toString();
        }
    }
}

