/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.mutable;

import org.apache.lucene.util.mutable.MutableValue;

public class MutableValueDouble
extends MutableValue {
    public double value = 0.0;

    @Override
    public Object toObject() {
        assert (this.exists || 0.0 == this.value);
        return this.exists ? Double.valueOf(this.value) : null;
    }

    @Override
    public void copy(MutableValue source) {
        MutableValueDouble s2 = (MutableValueDouble)source;
        this.value = s2.value;
        this.exists = s2.exists;
    }

    @Override
    public MutableValue duplicate() {
        MutableValueDouble v2 = new MutableValueDouble();
        v2.value = this.value;
        v2.exists = this.exists;
        return v2;
    }

    @Override
    public boolean equalsSameType(Object other) {
        assert (this.exists || 0.0 == this.value);
        MutableValueDouble b2 = (MutableValueDouble)other;
        return this.value == b2.value && this.exists == b2.exists;
    }

    @Override
    public int compareSameType(Object other) {
        assert (this.exists || 0.0 == this.value);
        MutableValueDouble b2 = (MutableValueDouble)other;
        int c2 = Double.compare(this.value, b2.value);
        if (c2 != 0) {
            return c2;
        }
        if (this.exists == b2.exists) {
            return 0;
        }
        return this.exists ? 1 : -1;
    }

    @Override
    public int hashCode() {
        assert (this.exists || 0.0 == this.value);
        long x2 = Double.doubleToLongBits(this.value);
        return (int)x2 + (int)(x2 >>> 32);
    }
}

