/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.packed.DirectWriter;

public final class DirectMonotonicWriter {
    public static final int MIN_BLOCK_SHIFT = 2;
    public static final int MAX_BLOCK_SHIFT = 22;
    final IndexOutput meta;
    final IndexOutput data;
    final long numValues;
    final long baseDataPointer;
    final long[] buffer;
    int bufferSize;
    long count;
    boolean finished;
    long previous = Long.MIN_VALUE;

    DirectMonotonicWriter(IndexOutput metaOut, IndexOutput dataOut, long numValues, int blockShift) {
        this.meta = metaOut;
        this.data = dataOut;
        this.numValues = numValues;
        if (blockShift < 2 || blockShift > 30) {
            throw new IllegalArgumentException("blockShift must be in [3-30], got " + blockShift);
        }
        int blockSize = 1 << blockShift;
        this.buffer = new long[blockSize];
        this.bufferSize = 0;
        this.baseDataPointer = dataOut.getFilePointer();
    }

    private void flush() throws IOException {
        assert (this.bufferSize != 0);
        float avgInc = (float)((double)(this.buffer[this.bufferSize - 1] - this.buffer[0]) / (double)Math.max(1, this.bufferSize - 1));
        int i2 = 0;
        while (i2 < this.bufferSize) {
            long expected = (long)(avgInc * (float)i2);
            int n2 = i2++;
            this.buffer[n2] = this.buffer[n2] - expected;
        }
        long min2 = this.buffer[0];
        for (int i3 = 1; i3 < this.bufferSize; ++i3) {
            min2 = Math.min(this.buffer[i3], min2);
        }
        long maxDelta = 0L;
        for (int i4 = 0; i4 < this.bufferSize; ++i4) {
            int n3 = i4;
            this.buffer[n3] = this.buffer[n3] - min2;
            maxDelta |= this.buffer[i4];
        }
        this.meta.writeLong(min2);
        this.meta.writeInt(Float.floatToIntBits(avgInc));
        this.meta.writeLong(this.data.getFilePointer() - this.baseDataPointer);
        if (maxDelta == 0L) {
            this.meta.writeByte((byte)0);
        } else {
            int bitsRequired = DirectWriter.unsignedBitsRequired(maxDelta);
            DirectWriter writer = DirectWriter.getInstance(this.data, this.bufferSize, bitsRequired);
            for (int i5 = 0; i5 < this.bufferSize; ++i5) {
                writer.add(this.buffer[i5]);
            }
            writer.finish();
            this.meta.writeByte((byte)bitsRequired);
        }
        this.bufferSize = 0;
    }

    public void add(long v2) throws IOException {
        if (v2 < this.previous) {
            throw new IllegalArgumentException("Values do not come in order: " + this.previous + ", " + v2);
        }
        if (this.bufferSize == this.buffer.length) {
            this.flush();
        }
        this.buffer[this.bufferSize++] = v2;
        this.previous = v2;
        ++this.count;
    }

    public void finish() throws IOException {
        if (this.count != this.numValues) {
            throw new IllegalStateException("Wrong number of values added, expected: " + this.numValues + ", got: " + this.count);
        }
        if (this.finished) {
            throw new IllegalStateException("#finish has been called already");
        }
        if (this.bufferSize > 0) {
            this.flush();
        }
        this.finished = true;
    }

    public static DirectMonotonicWriter getInstance(IndexOutput metaOut, IndexOutput dataOut, long numValues, int blockShift) {
        return new DirectMonotonicWriter(metaOut, dataOut, numValues, blockShift);
    }
}

